/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.native_;

import android.support.annotation.NonNull;
import com.zero.common.base.BaseNative;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.widget.WrapTadView;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.handler.IParalleHandler;
import com.zero.mediation.interfacz.IAdParallel;
import java.util.List;

public class NativeParalle
implements IParalleHandler<BaseNative> {
    private String TAG = "NativeParalle";
    private final NetWork ax;
    protected WrapTadView mParentView;
    protected String mPlacementId = "";
    protected TAdRequestBody mAdRequestBody;
    private List<TAdNativeInfo> aG;
    private BaseNative aH = null;
    private IAdParallel ay;
    private TAdRequestBody aI;

    public NativeParalle(@NonNull NetWork netWork, IAdParallel iAdParallel) {
        this.ax = netWork;
        this.mPlacementId = netWork.getPmid();
        this.ay = iAdParallel;
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.aI = tAdRequestBody;
        this.mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAllianceListener(new TAdAllianceListener(){

            public void onAllianceLoad(List<TAdNativeInfo> list) {
                if (NativeParalle.this.ay != null) {
                    AdLogUtil.Log().d(NativeParalle.this.TAG, "Ad load success,plaformId is " + NativeParalle.this.mPlacementId);
                    NativeParalle.this.aG = list;
                    NativeParalle.this.ay.paralleAdBeLoad(NativeParalle.this.mPlacementId);
                }
            }

            public void onAllianceError(TAdErrorCode tAdErrorCode) {
                NativeParalle.this.detorySelf();
                if (NativeParalle.this.ay != null) {
                    if (NativeParalle.this.ay.paralleAdSizeOut()) {
                        AdLogUtil.Log().e(NativeParalle.this.TAG, "error count is time out");
                        if (NativeParalle.this.aI != null) {
                            NativeParalle.this.aI.getAllianceListener().onAllianceError(tAdErrorCode);
                        }
                    } else {
                        AdLogUtil.Log().e(NativeParalle.this.TAG, "count is not out,wait next");
                    }
                }
            }

            public void onShow() {
                if (NativeParalle.this.aI != null) {
                    NativeParalle.this.aI.getAllianceListener().onShow();
                }
            }

            public void onClicked() {
                if (NativeParalle.this.aI != null) {
                    NativeParalle.this.aI.getAllianceListener().onClicked();
                }
            }

            public void onClosed() {
                if (NativeParalle.this.aI != null) {
                    NativeParalle.this.aI.getAllianceListener().onClosed();
                }
            }

            public void onClickIntercept(InterceptAdapter interceptAdapter) {
                if (NativeParalle.this.aI != null) {
                    NativeParalle.this.aI.getAllianceListener().onClickIntercept(interceptAdapter);
                }
            }
        }).setReturnUrlsForImageAssets(this.aI != null && this.aI.isUrlForImage()).build();
    }

    @Override
    public void onParalleFilterTheBest() {
        if (this.aI != null && this.aI.getAllianceListener() != null) {
            AdLogUtil.Log().d(this.TAG, this.TAG + " onAllianceLoad");
            this.aI.getAllianceListener().onAllianceLoad(this.aG);
        }
    }

    @Override
    public NetWork getNetwork() {
        return this.ax;
    }

    @Override
    public void setAllianceExecuter(BaseNative baseNative) {
        this.aH = baseNative;
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d(this.TAG, "NativeParalle start Load");
        if (this.aH != null) {
            this.aH.setRequestBody(this.mAdRequestBody);
            this.aH.loadAd();
        }
    }

    protected void detorySelf() {
        if (this.aH != null) {
            AdLogUtil.Log().d(this.TAG, "NativeParalle destroy self");
            this.aH.destroyAd();
            this.aH = null;
        }
        if (this.aG != null && this.aG.size() > 0) {
            for (TAdNativeInfo tAdNativeInfo : this.aG) {
                tAdNativeInfo.release();
            }
            this.aG.clear();
        }
    }

    @Override
    public void destroyAd() {
        AdLogUtil.Log().d(this.TAG, this.TAG + " destroyAd");
        this.ay = null;
        this.aI = null;
        this.detorySelf();
    }

    public String toString() {
        return "NativeParalle{TAG='" + this.TAG + '\'' + ", netWork=" + this.ax + ", iadParallel=" + this.ay + ", mParentView=" + this.mParentView + ", mPlacementId='" + this.mPlacementId + '\'' + ", mAdRequestBody=" + this.mAdRequestBody + ", adRequestBody=" + this.aI + '}';
    }
}

