/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.handler.native_;

import com.zero.common.base.BaseNative;
import com.zero.common.bean.InterceptAdapter;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.interfacz.TAdAllianceListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.bean.NetWork;
import com.zero.mediation.handler.ISerialHandler;
import java.util.List;

public class NativeSerial
implements ISerialHandler<BaseNative> {
    private String TAG = "NativeSerial";
    private NativeSerial aK;
    protected String mPlacementId = "";
    protected TAdRequestBody mAdRequestBody;
    private TAdRequestBody aI;
    private BaseNative aH = null;

    public NativeSerial(NetWork netWork) {
        this.mPlacementId = netWork.getPmid();
    }

    public NativeSerial getNextHandler() {
        return this.aK;
    }

    public void setNextHandler(NativeSerial nativeSerial) {
        this.aK = nativeSerial;
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.aI = tAdRequestBody;
        this.mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAllianceListener(new TAdAllianceListener(){

            public void onAllianceError(TAdErrorCode tAdErrorCode) {
                NativeSerial.this.destroySelf();
                if (NativeSerial.this.aK != null) {
                    AdLogUtil.Log().d(NativeSerial.this.TAG, "load error, next");
                    NativeSerial.this.aK.loadAd();
                } else if (NativeSerial.this.aI != null) {
                    NativeSerial.this.aI.getAllianceListener().onAllianceError(tAdErrorCode);
                }
            }

            public void onAllianceLoad(List<TAdNativeInfo> list) {
                super.onAllianceLoad(list);
                if (NativeSerial.this.aI != null) {
                    NativeSerial.this.aI.getAllianceListener().onAllianceLoad(list);
                }
            }

            public void onShow() {
                if (NativeSerial.this.aI != null) {
                    NativeSerial.this.aI.getAllianceListener().onShow();
                }
            }

            public void onClicked() {
                if (NativeSerial.this.aI != null) {
                    NativeSerial.this.aI.getAllianceListener().onClicked();
                }
            }

            public void onClosed() {
                if (NativeSerial.this.aI != null) {
                    NativeSerial.this.aI.getAllianceListener().onClosed();
                }
            }

            public void onClickIntercept(InterceptAdapter interceptAdapter) {
                if (NativeSerial.this.aI != null) {
                    NativeSerial.this.aI.getAllianceListener().onClickIntercept(interceptAdapter);
                }
            }
        }).setReturnUrlsForImageAssets(this.aI != null && this.aI.isUrlForImage()).build();
    }

    @Override
    public void loadAd() {
        AdLogUtil.Log().d(this.TAG, "NativeSerial start Load");
        if (this.aH != null) {
            this.aH.setRequestBody(this.mAdRequestBody);
            this.aH.loadAd();
        }
    }

    public BaseNative getNative() {
        return this.aH;
    }

    protected void destroySelf() {
        if (this.aH != null) {
            AdLogUtil.Log().d(this.TAG, "AdFanNativeSerial destroy self");
            this.aH.destroyAd();
            this.aH = null;
        }
    }

    @Override
    public void destroyAd() {
        this.aI = null;
        if (this.aK != null) {
            AdLogUtil.Log().d(this.TAG, this.TAG + " destroy");
            this.aK.destroyAd();
            this.aK = null;
        }
        this.destroySelf();
    }

    @Override
    public void setAllianceExecuter(BaseNative baseNative) {
        this.aH = baseNative;
    }

    public String toString() {
        return "NativeSerial{TAG='" + this.TAG + '\'' + ", nextHandler=" + this.aK + ", mPlacementId='" + this.mPlacementId + '\'' + ", mAdRequestBody=" + this.mAdRequestBody + ", adRequestBody=" + this.aI + ", mNative=" + this.aH + '}';
    }
}

