/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.util;

import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import com.transsion.core.CoreUtil;
import com.zero.common.utils.AdLogUtil;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class MacUtil {
    public static String getLocalMacAddress() {
        String string = "";
        if (Build.VERSION.SDK_INT >= 23) {
            string = MacUtil.j();
            AdLogUtil.Log().d("MacUtil", "get mac from M+");
        } else {
            WifiInfo wifiInfo;
            WifiManager wifiManager = (WifiManager)CoreUtil.getContext().getApplicationContext().getSystemService("wifi");
            if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
                string = wifiInfo.getMacAddress();
            }
            AdLogUtil.Log().d("MacUtil", "normal get mac");
        }
        AdLogUtil.Log().d("MacUtil", "mac is " + string);
        return string;
    }

    private static String j() {
        try {
            ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : arrayList) {
                if (!networkInterface.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] byArray = networkInterface.getHardwareAddress();
                if (byArray == null || byArray.length == 0) {
                    return "";
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (byte by : byArray) {
                    stringBuilder.append(String.format("%02X:", by));
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                return stringBuilder.toString();
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().d("MacUtil", "get mac is error: " + exception.getMessage());
        }
        return "";
    }
}

