/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.toolbox;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.LruCache;
import androidx.annotation.NonNull;
import com.transsion.core.CoreUtil;
import com.transsion.http.util.MD5;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.toolbox.interfacez.ResponseListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.http.callback.DrawableResponseListener;
import com.zero.mediation.http.request.DownLoadRequest;
import com.zero.mediation.util.AppUtil;
import com.zero.ta.common.bean.AdImage;
import com.zero.ta.common.constant.ComConstant;
import com.zero.ta.common.gif.DefaultImageHeaderParser;
import com.zero.ta.common.gif.ImageHeaderParser;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public class AdImageLoadHelper {
    public static final String TAG = "AdImageLoadHelper";
    public static AdImageLoadHelper loader;
    public static LruCache<String, WeakReference<AdImage>> cache;
    public static final int MB = 0x100000;
    public ReferenceQueue<AdImage> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdImageLoadHelper with() {
        if (loader != null) return loader;
        Class<AdImageLoadHelper> clazz = AdImageLoadHelper.class;
        synchronized (AdImageLoadHelper.class) {
            if (loader != null) return loader;
            loader = new AdImageLoadHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return loader;
        }
    }

    public AdImageLoadHelper() {
        int n = Math.min(Math.max(0x1400000, (int)(Runtime.getRuntime().maxMemory() / 8L)), 0xC800000);
        cache = new LruCache<String, WeakReference<AdImage>>(n){

            public int sizeOf(String string, WeakReference<AdImage> weakReference) {
                if (weakReference.get() != null) {
                    ((AdImage)weakReference.get()).getByteSize();
                }
                return super.size();
            }
        };
        this.queue = new ReferenceQueue();
    }

    private void downloadBitmap(final String string, String string2, final ResponseListener responseListener) {
        new DownLoadRequest().a(new DrawableResponseListener(){

            @Override
            public void onRequestError(TAdErrorCode tAdErrorCode) {
                AdLogUtil.Log().e(AdImageLoadHelper.TAG, "download fail code:" + tAdErrorCode.toString());
                AdImageLoadHelper.this.dispatchResult(string, null, responseListener);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onServerRequestSuccess(int n, byte[] byArray, String string2) {
                try {
                    Object object = new DefaultImageHeaderParser().getType(ByteBuffer.wrap(byArray));
                    Bitmap bitmap = null;
                    boolean bl = false;
                    if (object == ImageHeaderParser.ImageType.GIF && ComConstant.isGlideExisted) {
                        if (object == ImageHeaderParser.ImageType.GIF) {
                            bl = true;
                            AdLogUtil.Log().d(AdImageLoadHelper.TAG, "Image type is gif");
                        }
                    } else {
                        bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                    }
                    object = bitmap == null ? null : AdImageLoadHelper.this.transform(bitmap);
                    if (!bl) {
                        byArray = null;
                    }
                    bitmap = new AdImage((Drawable)object, byArray, string2);
                    AdImageLoadHelper.this.dispatchResult(string, (AdImage)bitmap, responseListener);
                    return;
                }
                catch (Throwable throwable) {
                    AdImageLoadHelper.this.dispatchResult(string, null, responseListener);
                }
            }
        }).setUrl(string2).netRequestPreExecute();
    }

    private void dispatchResult(final String string, final AdImage adImage, final ResponseListener responseListener) {
        AppUtil.b(new Runnable(){

            @Override
            public void run() {
                AdImage adImage2 = responseListener2.adImage;
                if (adImage2 == null) {
                    ResponseListener responseListener2 = responseListener2.responseListener;
                    if (responseListener2 != null) {
                        responseListener2.onFail();
                    }
                    return;
                }
                if (!adImage2.isRecycled() && !TextUtils.isEmpty((CharSequence)responseListener2.string)) {
                    cache.put((Object)responseListener2.string, new WeakReference<AdImage>(responseListener2.adImage, responseListener2.AdImageLoadHelper.this.queue));
                }
                if (responseListener2.responseListener != null) {
                    if (responseListener2.adImage.isRecycled()) {
                        responseListener2.responseListener.onFail();
                    } else {
                        responseListener2.responseListener.onSuccess(responseListener2.adImage);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable transform(@NonNull Bitmap bitmap) {
        AdImageLoadHelper adImageLoadHelper = null;
        if (bitmap == null) {
            return null;
        }
        return new BitmapDrawable(CoreUtil.getContext().getResources(), bitmap);
        {
            catch (Throwable throwable) {
                return adImageLoadHelper;
            }
            catch (Throwable throwable) {}
            {
                AdLogUtil.Log().e(TAG, "transform bitmap to drawable exception");
                return adImageLoadHelper;
            }
        }
    }

    public void loadImage(@NonNull String string, ResponseListener responseListener) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.dispatchResult("", null, responseListener);
            return;
        }
        String string2 = MD5.MD5Encode((String)string);
        WeakReference weakReference = (WeakReference)cache.get((Object)string2);
        if (weakReference != null && weakReference.get() != null && ((AdImage)weakReference.get()).isRecycled()) {
            this.dispatchResult(null, (AdImage)weakReference.get(), responseListener);
        } else {
            this.downloadBitmap(string2, string, responseListener);
        }
    }
}

