/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.http.callback;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.zero.common.bean.TAdErrorCode;

public abstract class ResponseBaseListener {
    public static final int SUCCESS = 200;
    public Handler handler;

    public ResponseBaseListener() {
        this(null);
    }

    public ResponseBaseListener(boolean bl) {
        Looper looper = bl ? null : Looper.myLooper();
        this(looper, bl);
    }

    public ResponseBaseListener(Looper looper) {
        if (looper == null) {
            looper = Looper.myLooper();
        }
        this(looper, false);
    }

    public ResponseBaseListener(Looper looper, boolean bl) {
        this.handler = null;
        this.handler = !bl ? new ResponderHandler(looper) : null;
    }

    public abstract void onRequestError(TAdErrorCode var1);

    public void onServerRequestFailure(int n, Bitmap bitmap, Throwable throwable) {
        this.onServerRequestFailure(new TAdErrorCode(n, "error code  " + n));
    }

    public void onServerRequestFailure(int n, String string, Throwable throwable) {
        this.onServerRequestFailure(new TAdErrorCode(n, "erro msg = " + string));
    }

    public void onServerRequestFailure(int n, byte[] byArray, Throwable throwable) {
        this.onServerRequestFailure(new TAdErrorCode(n, "erro msg = " + byArray));
    }

    public void onServerRequestFailure(final TAdErrorCode tAdErrorCode) {
        Handler handler = this.handler;
        if (handler != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ResponseBaseListener.this.onRequestError(tAdErrorCode);
                }
            });
        } else {
            this.onRequestError(tAdErrorCode);
        }
    }

    public void onServerRequestSuccess(int n, Bitmap bitmap) {
    }

    public void onServerRequestSuccess(Bitmap bitmap) {
        this.onServerRequestSuccess(200, bitmap);
    }

    public void onServerRequestSuccess(int n, String string) {
    }

    public void onServerRequestSuccess(String string) {
        this.onServerRequestSuccess(200, string);
    }

    public abstract void onServerRequestSuccess(int var1, byte[] var2);

    public void onRequestStart(int n) {
    }

    public void onServerRequestStart(final int n) {
        Handler handler = this.handler;
        if (handler != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ResponseBaseListener.this.onRequestStart(n);
                }
            });
        } else {
            this.onRequestStart(n);
        }
    }

    private class ResponderHandler
    extends Handler {
        public ResponderHandler(Looper looper) {
            super(looper);
        }
    }
}

