/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pushui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.SharedPreferencesUtil;
import com.transsion.json.Tson;
import com.transsion.pushui.IReceiveListener;
import com.transsion.pushui.activity.TransparentActivity;
import com.transsion.pushui.bean.PushMessage;
import com.transsion.pushui.bean.PushNotification;
import com.transsion.pushui.tracker.Tracker;
import com.transsion.pushui.utils.NotificationAssistUtils;
import com.transsion.pushui.utils.NotificationHelper;
import com.transsion.pushui.utils.PushLogUtils;
import com.transsion.pushui.utils.PushTypeException;
import com.transsion.pushui.utils.ServiceUtils;

public final class PushUIManager {
    private Context a;
    private IReceiveListener b;
    private SharedPreferencesUtil c = SharedPreferencesUtil.getInstance((String)"sp_pushui");

    private PushUIManager() {
    }

    public static PushUIManager getInstance() {
        return com.transsion.pushui.PushUIManager$a.a;
    }

    private boolean a(String string) {
        PackageManager packageManager;
        try {
            packageManager = CoreUtil.getContext().getPackageManager();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return true;
        }
        packageManager.getApplicationInfo(string, 128);
        return false;
    }

    /* synthetic */ PushUIManager(com.transsion.pushui.a a2) {
        this();
    }

    public void init(Context context) {
        IntentFilter intentFilter;
        Context context2 = context;
        pushUIManager.a = context.getApplicationContext();
        CoreUtil.init((Context)context2.getApplicationContext());
        PushUIManager pushUIManager = intentFilter;
        new IntentFilter().addAction(context.getPackageName() + ".push.action");
        pushUIManager.addAction("action_notification_deleted");
        context2.registerReceiver((BroadcastReceiver)new com.transsion.pushui.a.a(), (IntentFilter)pushUIManager);
        Tracker.getInstance().trackInit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handlerMessage(PushMessage pushMessage) {
        if (pushMessage == null) {
            Tracker.getInstance().trackTrace("push exception, handler message is null");
            Tracker.getInstance().trackMessage(0L, 0, "", "fail", -1);
            PushLogUtils.LOG.e((Object)"The message is empty");
            return;
        }
        try {
            int n;
            String string;
            String string2;
            int n2;
            long l;
            Tracker tracker;
            if (this.a.getPackageName().equals(pushMessage.packageName)) {
                ServiceUtils.startService(null, pushMessage);
                tracker = Tracker.getInstance();
                l = pushMessage.messageId;
                n2 = pushMessage.type;
                string2 = pushMessage.timeStamp;
                string = "success";
                n = 0;
            } else {
                Intent intent;
                if (this.a(pushMessage.packageName)) {
                    Tracker.getInstance().trackMessage(pushMessage.messageId, pushMessage.type, pushMessage.timeStamp, "fail", 3);
                    Tracker.getInstance().trackUninstall(pushMessage.messageId, pushMessage.packageName);
                    return;
                }
                PushUIManager pushUIManager = this;
                PushUIManager pushUIManager2 = this = intent;
                pushUIManager2();
                pushUIManager2.putExtra("message", Tson.toJson((Object)pushMessage));
                intent.setClassName(pushMessage.packageName, TransparentActivity.class.getName());
                intent.setFlags(0x10000000);
                pushUIManager.a.startActivity((Intent)this);
                tracker = Tracker.getInstance();
                l = pushMessage.messageId;
                n2 = pushMessage.type;
                string2 = pushMessage.timeStamp;
                string = "success";
                n = 0;
            }
            tracker.trackMessage(l, n2, string2, string, n);
            return;
        }
        catch (Exception exception) {
            Tracker.getInstance().trackMessage(pushMessage.messageId, pushMessage.type, pushMessage.timeStamp, "fail", 2);
            Tracker.getInstance().trackTrace("push exception, handler message exception, e:" + exception.getMessage());
            PushLogUtils.LOG.e((Object)("Notification or transmission exception,e:" + exception.getMessage()));
            return;
        }
        catch (PushTypeException pushTypeException) {
            Tracker.getInstance().trackMessage(pushMessage.messageId, pushMessage.type, pushMessage.timeStamp, "fail", 4);
            Tracker.getInstance().trackTrace("push exception, handler message exception, e:" + pushTypeException.getMessage());
            PushLogUtils.LOG.e((Object)("Notification or transmission exception,e:" + pushTypeException.getMessage()));
        }
    }

    public IReceiveListener getReceiveListener() {
        return this.b;
    }

    public void setReceiveListener(IReceiveListener iReceiveListener) {
        this.b = iReceiveListener;
    }

    public boolean isOpenNotification(Context context) {
        return NotificationAssistUtils.isOpenNotification(context);
    }

    public void showOpenNotificationDialog(Activity activity) {
        NotificationAssistUtils.showOpenNotificationDialog(activity);
    }

    public void addCustomNotification(PushNotification pushNotification) {
        NotificationHelper.addCustomNotification(pushNotification);
    }

    public boolean getIsMessageHandled(long l) {
        String string2 = ((PushUIManager)((Object)string2)).c.getString("pushui_message_ids");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.contains(String.valueOf(l));
    }

    public void setMessageHandled(long l) {
        String string2 = this.c.getString("pushui_message_ids");
        if (string2.contains(String.valueOf(l))) {
            return;
        }
        String string3 = string2 + " " + l;
        if (string3.length() > 1024) {
            string3 = string3.substring(256);
        }
        this.c.putString("pushui_message_ids", string3);
    }

    private static final class a {
        private static final PushUIManager a = new PushUIManager(null);
    }
}

