/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pushui.utils;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.SparseArray;
import android.widget.RemoteViews;
import com.transsion.http.impl.BitmapCallback;
import com.transsion.json.Tson;
import com.transsion.pushui.R;
import com.transsion.pushui.bean.PushMessage;
import com.transsion.pushui.bean.PushNotification;
import com.transsion.pushui.tracker.Tracker;
import com.transsion.pushui.utils.ImageUtils;
import com.transsion.pushui.utils.NotificationAssistUtils;
import com.transsion.pushui.utils.PushLogUtils;
import java.util.UUID;

public final class NotificationHelper {
    private static SparseArray<PushNotification> a = new SparseArray();

    public static Notification getNotification(Context context, PushMessage pushMessage, Bitmap bitmap, Bitmap bitmap2) {
        PushNotification pushNotification;
        int n;
        if (pushMessage == null) {
            PushLogUtils.LOG.e((Object)"Get the notification object, the message is empty");
            return null;
        }
        int n2 = pushMessage.notiType;
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            PushLogUtils.LOG.e((Object)("Notification type is not supported\uff0cnotiType:" + pushMessage.notiType));
            return null;
        }
        n2 = pushMessage.notiExType;
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            PushLogUtils.LOG.e((Object)("Notification expansion type is not supported\uff0cnotiExType:" + pushMessage.notiExType));
            return null;
        }
        if (3 == pushMessage.notiOpenType) {
            ImageUtils.loadImage(pushMessage.downloadImgUrl);
        }
        Context context2 = context;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context2, context2.getPackageName()).setWhen(System.currentTimeMillis()).setShowWhen(true).setAutoCancel(true).setDefaults(2).setDefaults(1).setPriority(0).setDeleteIntent(NotificationHelper.b(context)).setContentIntent(NotificationHelper.a(context, pushMessage));
        NotificationHelper.a(context, builder, pushMessage, bitmap, bitmap2);
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setChannelId(pushMessage.packageName);
        }
        if ((n = NotificationHelper.a(context)) > 0) {
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)n));
        }
        int n3 = (pushNotification = (PushNotification)a.get(pushMessage.notiType)) != null ? pushNotification.getSmallIcon() : R.drawable.pushui_notify_icon;
        NotificationCompat.Builder builder2 = builder;
        builder2.setSmallIcon(n3);
        Tracker.getInstance().trackShow(pushMessage.messageId, pushMessage.type, pushMessage.timeStamp, NotificationAssistUtils.isOpenNotification(context));
        return builder2.build();
    }

    public static Notification getEmptyNotification(Context context, int n) {
        RemoteViews remoteViews;
        RemoteViews remoteViews2 = remoteViews;
        remoteViews = new RemoteViews(context.getPackageName(), R.layout.pushui_notification_custom_0dp);
        remoteViews2 = new NotificationCompat.Builder(context).setWhen(System.currentTimeMillis()).setShowWhen(true).setAutoCancel(true).setDefaults(1).setPriority(0).setCustomContentView(remoteViews2);
        PushNotification pushNotification = (PushNotification)a.get(n);
        int n2 = pushNotification != null ? pushNotification.getSmallIcon() : R.drawable.pushui_notify_icon;
        remoteViews2.setSmallIcon(n2);
        if (Build.VERSION.SDK_INT >= 26) {
            remoteViews2.setChannelId(context.getPackageName());
        }
        return remoteViews2.build();
    }

    public static void addCustomNotification(PushNotification pushNotification) {
        a.put(pushNotification.getType(), (Object)pushNotification);
    }

    public static boolean checkIsDownloadBitmap(PushMessage pushMessage) {
        int n;
        return pushMessage.notiType == 1 && pushMessage.notiExType == 3 || (n = pushMessage.notiType) == 2 || n == 3 || n == 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void downloadBitmap(final PushMessage pushMessage, final BitmapDownloadListener bitmapDownloadListener) {
        final String string2 = null;
        if (pushMessage.notiType == 1 && pushMessage.notiExType == 3) {
            string2 = pushMessage.notiImgEx;
        } else {
            int n = pushMessage.notiType;
            if (n == 2) {
                string2 = pushMessage.notiImg;
            } else if (n == 3 || n == 4) {
                string2 = pushMessage.notiIcon;
            } else {
                PushLogUtils.LOG.w((Object)"This type does not need to download bitmap");
            }
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            PushLogUtils.LOG.w((Object)"The downloaded image URL is empty");
            return;
        }
        ImageUtils.loadImage(string2, new BitmapCallback(){

            public void onFailure(int n, Bitmap bitmap, Throwable throwable) {
                PushLogUtils.LOG.e((Object)("Bitmap download failed\uff0curl:" + string2));
            }

            public void onSuccess(int n, Bitmap bitmap) {
                block6: {
                    PushMessage pushMessage2;
                    block7: {
                        block4: {
                            int n2;
                            block5: {
                                if (bitmap == null) {
                                    PushLogUtils.LOG.w((Object)"Bitmap download was successful, but Bitmap was empty");
                                    return;
                                }
                                pushMessage2 = object.pushMessage;
                                if (pushMessage2.notiType != 4) break block4;
                                n2 = pushMessage2.notiExType;
                                if (n2 != 4) break block5;
                                NotificationHelper.b(pushMessage2, bitmap, pushMessage2.notiImgEx, object.bitmapDownloadListener);
                                break block6;
                            }
                            if (n2 != 1 || (object = object.bitmapDownloadListener) == null) break block6;
                            break block7;
                        }
                        Object object = object.bitmapDownloadListener;
                        if (object == null) break block6;
                    }
                    object.downloadComplete(pushMessage2, bitmap, null);
                }
            }
        });
    }

    private static void b(final PushMessage pushMessage, final Bitmap bitmap, final String string2, final BitmapDownloadListener bitmapDownloadListener) {
        ImageUtils.loadImage(string2, new BitmapCallback(){

            public void onFailure(int n, Bitmap bitmap2, Throwable throwable) {
                PushLogUtils.LOG.e((Object)("Bitmap download failed\uff0curl:" + string2));
            }

            public void onSuccess(int n, Bitmap bitmap2) {
                if (bitmap2 == null) {
                    PushLogUtils.LOG.w((Object)"Bitmap download was successful, but Bitmap was empty");
                    return;
                }
                BitmapDownloadListener bitmapDownloadListener2 = bitmapDownloadListener;
                if (bitmapDownloadListener2 != null) {
                    bitmapDownloadListener2.downloadComplete(pushMessage, bitmap, bitmap2);
                }
            }
        });
    }

    private static void a(Context context, NotificationCompat.Builder builder, PushMessage pushMessage, Bitmap bitmap, Bitmap bitmap2) {
        PushNotification pushNotification = (PushNotification)a.get(pushMessage.notiType);
        boolean bl = pushNotification != null;
        switch (pushMessage.notiType) {
            default: {
                PushLogUtils.LOG.w((Object)"Unsupported notification type, setting content");
                break;
            }
            case 4: {
                boolean bl2 = bl && pushNotification.getLayoutId() > 0;
                String string2 = context.getPackageName();
                int n = bl2 ? pushNotification.getLayoutId() : R.layout.pushui_notification_custom_style_4;
                RemoteViews remoteViews = new RemoteViews(string2, n);
                int n2 = bl2 ? pushNotification.getIconId() : R.id.pushui_notification_image;
                remoteViews.setImageViewBitmap(n2, bitmap);
                int n3 = bl2 ? pushNotification.getTitleId() : R.id.pushui_notification_title;
                remoteViews.setTextViewText(n3, (CharSequence)pushMessage.notiTitle);
                n3 = bl2 ? pushNotification.getContentId() : R.id.pushui_notification_content;
                RemoteViews remoteViews2 = remoteViews;
                remoteViews2.setTextViewText(n3, (CharSequence)pushMessage.notiDes);
                builder.setCustomContentView(remoteViews2);
                if (pushMessage.notiExType != 4) break;
                n3 = bl && pushNotification.getLayoutBigId() > 0 ? 1 : 0;
                String string3 = context.getPackageName();
                int n4 = n3 != 0 ? pushNotification.getLayoutBigId() : R.layout.pushui_notification_custom_style_4_big;
                RemoteViews remoteViews3 = new RemoteViews(string3, n4);
                int n5 = NotificationHelper.a(context);
                if (n5 > 0) {
                    n4 = n3 != 0 ? pushNotification.getIconBigId() : R.id.pushui_notification_icon;
                    remoteViews3.setImageViewBitmap(n4, BitmapFactory.decodeResource((Resources)context.getResources(), (int)n5));
                }
                int n6 = n3 != 0 ? pushNotification.getImgBigId() : R.id.pushui_notification_image;
                remoteViews3.setImageViewBitmap(n6, bitmap2);
                n6 = n3 != 0 ? pushNotification.getTitleBigId() : R.id.pushui_notification_title;
                remoteViews3.setTextViewText(n6, (CharSequence)pushMessage.notiTitle);
                n6 = n3 != 0 ? pushNotification.getContentBigId() : R.id.pushui_notification_content;
                remoteViews3.setTextViewText(n6, (CharSequence)pushMessage.notiTxtEx);
                n6 = n3 != 0 ? pushNotification.getSourceBigId() : R.id.pushui_notification_source;
                RemoteViews remoteViews4 = remoteViews3;
                remoteViews4.setTextViewText(n6, (CharSequence)pushMessage.notiMarkerEx);
                builder.setCustomBigContentView(remoteViews4);
                break;
            }
            case 3: {
                boolean bl3 = bl && pushNotification.getLayoutId() > 0;
                Context context2 = context;
                String string4 = context2.getPackageName();
                int n = bl3 ? pushNotification.getLayoutId() : R.layout.pushui_notification_custom_style_3;
                context = new RemoteViews(string4, n);
                int n7 = bl3 ? pushNotification.getIconId() : R.id.pushui_notification_icon;
                context.setImageViewBitmap(n7, bitmap);
                int n8 = bl3 ? pushNotification.getTitleId() : R.id.pushui_notification_title;
                context.setTextViewText(n8, (CharSequence)pushMessage.notiTitle);
                n8 = bl3 ? pushNotification.getContentId() : R.id.pushui_notification_content;
                context.setTextViewText(n8, (CharSequence)pushMessage.notiDes);
                n8 = bl3 ? pushNotification.getBtnId() : R.id.pushui_notification_btn;
                Context context3 = context;
                context3.setTextViewText(n8, (CharSequence)pushMessage.notiBtn);
                builder.setCustomContentView((RemoteViews)context3);
                break;
            }
            case 2: {
                RemoteViews remoteViews = new RemoteViews(context.getPackageName(), R.layout.pushui_notification_custom_style_2);
                remoteViews.setImageViewBitmap(R.id.pushui_notification_big_img, bitmap);
                builder.setCustomContentView(remoteViews);
                break;
            }
            case 1: {
                builder.setContentTitle((CharSequence)pushMessage.notiTitle).setContentText((CharSequence)pushMessage.notiDes);
                int n = pushMessage.notiExType;
                if (n == 2) {
                    builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)pushMessage.notiTxtEx));
                    break;
                }
                if (n != 3) break;
                builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap));
            }
        }
    }

    private static PendingIntent a(Context context, PushMessage pushMessage) {
        Intent intent;
        Intent intent2 = intent;
        intent2(context.getPackageName() + ".push.action");
        intent.putExtra("message", Tson.toJson((Object)pushMessage));
        return PendingIntent.getBroadcast((Context)context, (int)UUID.randomUUID().hashCode(), (Intent)intent2, (int)0x8000000);
    }

    private static PendingIntent b(Context context) {
        Intent intent;
        Context context2 = context;
        context = intent;
        intent = new Intent("action_notification_deleted");
        return PendingIntent.getBroadcast((Context)context2, (int)UUID.randomUUID().hashCode(), (Intent)context, (int)0x8000000);
    }

    private static int a(Context context) {
        block5: {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) break block5;
            PackageManager packageManager2 = packageManager;
            String string2 = context.getPackageName();
            try {
                int n = packageManager2.getPackageInfo((String)string2, (int)0).applicationInfo.icon;
                if (n > 0) {
                    return n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return -1;
    }

    public static interface BitmapDownloadListener {
        public void downloadComplete(PushMessage var1, Bitmap var2, Bitmap var3);
    }
}

