/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pushui.utils;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.AppUtil;
import com.transsion.json.Tson;
import com.transsion.pushui.PushUIManager;
import com.transsion.pushui.bean.PushMessage;
import com.transsion.pushui.service.NotificationService;
import com.transsion.pushui.tracker.Tracker;
import com.transsion.pushui.utils.NotificationHelper;
import com.transsion.pushui.utils.PushLogUtils;
import com.transsion.pushui.utils.PushTypeException;

public final class ServiceUtils {
    public static void startService(final Activity activity, PushMessage pushMessage) {
        if (pushMessage == null) {
            PushLogUtils.LOG.w((Object)"Transparent page, empty message");
            if (activity != null) {
                activity.finish();
            }
            return;
        }
        int n = pushMessage.type;
        if (n != 1 && n != 3 && n != 2) {
            PushLogUtils.LOG.e((Object)"Message type is not supported");
            if (activity != null) {
                activity.finish();
            }
            throw new PushTypeException("message type is error, type is " + pushMessage.type);
        }
        if (PushUIManager.getInstance().getIsMessageHandled(pushMessage.messageId)) {
            Tracker.getInstance().trackTarget(pushMessage.messageId, pushMessage.type, pushMessage.timeStamp, pushMessage.rpkg, "handled");
            if (activity != null) {
                activity.finish();
            }
            return;
        }
        if (NotificationHelper.checkIsDownloadBitmap(pushMessage)) {
            NotificationHelper.downloadBitmap(pushMessage, new NotificationHelper.BitmapDownloadListener(){

                @Override
                public void downloadComplete(PushMessage pushMessage, Bitmap bitmap, Bitmap bitmap2) {
                    ServiceUtils.b(activity, pushMessage);
                }
            });
        } else {
            ServiceUtils.b(activity, pushMessage);
        }
        PushUIManager.getInstance().setMessageHandled(pushMessage.messageId);
    }

    private static void b(final Activity activity, PushMessage pushMessage) {
        block6: {
            block7: {
                Context context;
                block8: {
                    int n;
                    block5: {
                        Intent intent;
                        context = CoreUtil.getContext();
                        PushLogUtils.LOG.d((Object)("Start up service\uff0cmessage:" + pushMessage));
                        n = Build.VERSION.SDK_INT;
                        if (n < 28) break block5;
                        Intent intent2 = intent;
                        intent2(context, NotificationService.class);
                        intent.putExtra("message", Tson.toJson((Object)pushMessage));
                        if (pushMessage.type == 1) {
                            context.startForegroundService(intent2);
                        } else {
                            context.startService(intent2);
                        }
                        if (activity == null) break block6;
                        break block7;
                    }
                    if (n < 26) break block8;
                    Intent intent = new Intent(context, NotificationService.class);
                    intent.putExtra("message", Tson.toJson((Object)pushMessage));
                    context.startService(intent);
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            2 this_ = this_.activity;
                            if (this_ != null) {
                                this_.finish();
                            }
                        }
                    }, 50L);
                    break block6;
                }
                Intent intent = new Intent(context, NotificationService.class);
                intent.putExtra("message", Tson.toJson((Object)pushMessage));
                context.startService(intent);
                if (activity == null) break block6;
            }
            activity.finish();
        }
    }

    public static void stopPService(Context context) {
        if (Build.VERSION.SDK_INT >= 28) {
            context.stopService(new Intent(context, NotificationService.class));
        }
    }

    public static void startEmptyAndStopPService(Service service) {
        if (Build.VERSION.SDK_INT >= 28 && service != null) {
            Service service2 = service;
            NotificationManager notificationManager = (NotificationManager)service2.getApplication().getSystemService("notification");
            notificationManager.createNotificationChannel(new NotificationChannel(service.getPackageName(), (CharSequence)AppUtil.getAppName(), 3));
            Notification notification = NotificationHelper.getEmptyNotification(service.getApplicationContext(), -1);
            notificationManager.notify(1, notification);
            service2.startForeground(1, notification);
            service2.stopService(new Intent(service.getApplicationContext(), NotificationService.class));
        }
    }
}

