/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.config;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.SharedPreferencesUtil;
import com.transsion.crypto.TCrypterSdk;
import com.transsion.json.Tson;
import com.transsion.push.IClientIdListener;
import com.transsion.push.ITopicListener;
import com.transsion.push.bean.ConfigInfo;
import com.transsion.push.bean.SelfDestroyInfo;
import com.transsion.push.config.IDataSource;
import com.transsion.push.config.b;
import com.transsion.push.config.d;
import com.transsion.push.config.e;
import com.transsion.push.config.f;
import com.transsion.push.config.g;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.ThreadManager;
import com.transsion.push.utils.i;
import com.transsion.push.utils.q;
import com.transsion.push.utils.t;
import com.transsion.push.utils.u;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class PushRepository
implements IDataSource {
    private static PushRepository a;
    private SharedPreferencesUtil b = SharedPreferencesUtil.getInstance((String)"sp_push");
    private g c = new g();
    private ConfigInfo.Config d;
    private String e;

    private PushRepository() {
    }

    public static synchronized PushRepository getInstance() {
        if (a == null) {
            a = new PushRepository();
        }
        return a;
    }

    private void a(IClientIdListener iClientIdListener) {
        if (this.c == null) {
            if (iClientIdListener != null) {
                iClientIdListener.onFail("mRemoteDataSource is null");
            }
            PushLogUtils.LOG.w((Object)"mRemoteDataSource is null");
            return;
        }
        ThreadManager.executeInBackground(new f(this, iClientIdListener));
    }

    private void a() {
        int n2 = this.getSpValue("retry_count", 0);
        int n3 = q.d();
        PushLogUtils.LOG.d((Object)("Reporting Failure, Retry Reporting,retryCount\uff1a" + n2 + ", max retryCount\uff1a" + n3));
        if (n2 >= n3) {
            PushRepository pushRepository = this;
            PushLogUtils.LOG.d((Object)"More than the maximum number of retries");
            pushRepository.saveReportTime(System.currentTimeMillis() + q.c());
            pushRepository.putSpValue("retry_count", 0);
            return;
        }
        PushRepository pushRepository = this;
        pushRepository.putSpValue("retry_count", n2 + 1);
        pushRepository.saveReportTime(System.currentTimeMillis() + q.e());
    }

    static /* synthetic */ g a(PushRepository pushRepository) {
        return pushRepository.c;
    }

    static /* synthetic */ void a(PushRepository pushRepository, IClientIdListener iClientIdListener) {
        pushRepository.a(iClientIdListener);
    }

    @Override
    public long getReportTime() {
        long l2 = System.currentTimeMillis() - 1L;
        SharedPreferencesUtil sharedPreferencesUtil = this.b;
        if (sharedPreferencesUtil == null) {
            return l2;
        }
        long l3 = sharedPreferencesUtil.getLong("report_active_time", 0L);
        if (l3 <= 0L) {
            this.b.putLong("report_active_time", l2);
            l3 = l2;
        }
        return l3;
    }

    @Override
    public void saveReportTime(long l2) {
        if (this.b == null) {
            return;
        }
        PushLogUtils.LOG.d((Object)("Update reporting time\uff0creportTime:" + l2));
        this.b.putLong("report_active_time", l2);
    }

    @Override
    public ConfigInfo.Config getConfig() {
        ConfigInfo.Config config = ((PushRepository)object).d;
        if (config != null) {
            return config;
        }
        Object object = ((PushRepository)object).b;
        if (object == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.getString("push_config", null)))) {
            return null;
        }
        try {
            return (ConfigInfo.Config)Tson.fromJson((String)new String(Base64.decode((String)object, (int)0)), ConfigInfo.Config.class);
        }
        catch (Exception exception) {
            PushLogUtils.LOG.e((Object)("get config fail, e:" + exception.getMessage()));
            return null;
        }
    }

    @Override
    public void saveConfig(ConfigInfo.Config config) {
        SharedPreferencesUtil sharedPreferencesUtil;
        if (config != null && (sharedPreferencesUtil = this.b) != null) {
            String string;
            SharedPreferencesUtil sharedPreferencesUtil2 = sharedPreferencesUtil;
            this.d = config;
            String string2 = string;
            String string3 = string;
            byte[] byArray = Tson.toJson((Object)config).getBytes();
            try {
                string2(Base64.encode((byte[])byArray, (int)0));
                sharedPreferencesUtil2.putString("push_config", string3);
            }
            catch (Exception exception) {
                PushLogUtils.LOG.e((Object)("save config fail, e:" + exception.getMessage()));
            }
            return;
        }
    }

    @Override
    public ConfigInfo.Whitelist getWhiteList() {
        String string;
        block7: {
            Context context;
            if (!TextUtils.isEmpty((CharSequence)this.e)) {
                try {
                    return (ConfigInfo.Whitelist)Tson.fromJson((String)this.e, ConfigInfo.Whitelist.class);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            try {
                context = CoreUtil.getContext();
            }
            catch (Exception exception) {
                PushLogUtils.LOG.e((Object)("get white list fail, e:" + exception.getMessage()));
                return null;
            }
            string = TCrypterSdk.getSafeString((Context)context, (String)"push_white_list");
            if (!TextUtils.isEmpty((CharSequence)string)) break block7;
            return null;
        }
        this.e = string;
        return (ConfigInfo.Whitelist)Tson.fromJson((String)string, ConfigInfo.Whitelist.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveWhiteList(ConfigInfo.Whitelist whitelist) {
        if (whitelist == null) return;
        List<ConfigInfo.Apps> list = whitelist.apps;
        if (list == null) return;
        if (list.size() == 0) {
            return;
        }
        try {
            if (TextUtils.isEmpty((CharSequence)this.e)) {
                this.e = Tson.toJson((Object)whitelist);
                TCrypterSdk.saveSafeString((Context)CoreUtil.getContext(), (String)"push_white_list", (String)this.e);
                return;
            }
            list = ((ConfigInfo.Whitelist)Tson.fromJson((String)this.e, ConfigInfo.Whitelist.class)).apps;
            Iterator<ConfigInfo.Apps> iterator = whitelist.apps.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    new ConfigInfo.Whitelist().version = whitelist.version;
                    new ConfigInfo.Whitelist().apps = new ArrayList<ConfigInfo.Apps>(list);
                    this.e = Tson.toJson((Object)new ConfigInfo.Whitelist());
                    TCrypterSdk.saveSafeString((Context)CoreUtil.getContext(), (String)"push_white_list", (String)this.e);
                    return;
                }
                ConfigInfo.Apps apps = iterator.next();
                if (list.contains(apps)) continue;
                list.add(apps);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getSpValue(String string, T t2) {
        PushRepository pushRepository = pushRepository.b;
        if (pushRepository == null) {
            return t2;
        }
        try {
            if (t2 instanceof String) {
                return (T)pushRepository.getString(string, (String)t2);
            }
            if (t2 instanceof Boolean) {
                return (T)Boolean.valueOf(pushRepository.getBoolean(string, (Boolean)t2));
            }
            if (t2 instanceof Integer) {
                return (T)Integer.valueOf(pushRepository.getInt(string, (Integer)t2));
            }
            if (t2 instanceof Long) {
                return (T)Long.valueOf(pushRepository.getLong(string, (Long)t2));
            }
            if (t2 instanceof Float) {
                return (T)Float.valueOf(pushRepository.getFloat(string, ((Float)t2).floatValue()));
            }
            if (t2 instanceof Set) {
                return (T)pushRepository.getStringSet(string, new HashSet());
            }
            PushLogUtils.LOG.e((Object)("Type of " + t2.getClass().getSimpleName() + " is not supported."));
            return t2;
        }
        catch (ClassCastException classCastException) {
            PushLogUtils.LOG.e((Object)("Type of default value is not match with value stored." + System.lineSeparator() + classCastException.getMessage()));
            return t2;
        }
    }

    @Override
    public void removeSpValue(String string) {
        block3: {
            if (this.b == null) break block3;
            try {
                this.b.remove(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void putSpValue(String string, Object object) {
        PushRepository pushRepository = pushRepository.b;
        if (pushRepository == null) {
            return;
        }
        try {
            if (object instanceof String) {
                pushRepository.putString(string, (String)object);
                return;
            }
            if (object instanceof Boolean) {
                pushRepository.putBoolean(string, (Boolean)object);
                return;
            }
            if (object instanceof Integer) {
                pushRepository.putInt(string, (Integer)object);
                return;
            }
            if (object instanceof Long) {
                pushRepository.putLong(string, (Long)object);
                return;
            }
            if (object instanceof Float) {
                pushRepository.putFloat(string, ((Float)object).floatValue());
                return;
            }
            if (object instanceof Set) {
                pushRepository.putStringSet(string, (Set)object);
                return;
            }
            PushLogUtils.LOG.e((Object)("Value: " + object + " is not supported."));
            return;
        }
        catch (Exception exception) {
            PushLogUtils.LOG.e((Object)("put sp, Type of default value is not match with value stored." + System.lineSeparator() + exception.getMessage()));
        }
    }

    @Override
    public void updateNewToken(String string) {
        PushRepository pushRepository = this;
        pushRepository.putSpValue("push_token", string);
        pushRepository.putSpValue("push_is_report_detail", true);
        pushRepository.syncActive();
    }

    @Override
    public void subscribeToTopic(String string, ITopicListener iTopicListener) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (iTopicListener != null) {
                iTopicListener.onFail("subscribe topic is empty");
                PushLogUtils.LOG.e((Object)"subscribe topic is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)PushRepository.getInstance().getSpValue("push_client_id", ""))) {
            if (iTopicListener != null) {
                iTopicListener.onFail("subscribe clientId is empty");
                PushLogUtils.LOG.e((Object)"subscribe clientId is empty");
            }
            return;
        }
        ThreadManager.executeInBackground(new b(this, string, iTopicListener));
    }

    @Override
    public void unsubscribeFromTopic(String string, ITopicListener iTopicListener) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (iTopicListener != null) {
                iTopicListener.onFail("unsubscribe topic is empty");
                PushLogUtils.LOG.e((Object)"unsubscribe topic is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)PushRepository.getInstance().getSpValue("push_client_id", ""))) {
            if (iTopicListener != null) {
                iTopicListener.onFail("unsubscribe clientId is empty");
                PushLogUtils.LOG.e((Object)"unsubscribe clientId is empty");
            }
            return;
        }
        ThreadManager.executeInBackground(new d(this, string, iTopicListener));
    }

    @Override
    public void syncActive() {
        ConfigInfo.Config config;
        if (TextUtils.isEmpty((CharSequence)this.getSpValue("push_token", ""))) {
            PushLogUtils.LOG.w((Object)"Token is empty");
            return;
        }
        if (q.i()) {
            PushLogUtils.LOG.w((Object)"push self-destroying");
            return;
        }
        if (this.c == null) {
            PushLogUtils.LOG.w((Object)"mRemoteDataSource is null");
            return;
        }
        Tracker.getInstance().trackReport();
        Object object = this.c.b();
        if (object == null) {
            PushLogUtils.LOG.d((Object)"syncActive onFail");
            this.a();
            return;
        }
        ConfigInfo configInfo = object;
        this.putSpValue("retry_count", 0);
        PushLogUtils.LOG.d((Object)("get config response data: " + ((ConfigInfo)object).toString()));
        this.putSpValue("push_is_next_with_app", ((ConfigInfo)object).nextWithApp);
        this.putSpValue("push_is_report_detail", ((ConfigInfo)object).nextWithDetail);
        this.putSpValue("push_client_id", ((ConfigInfo)object).clientId);
        this.putSpValue("push_start_point_report", ((ConfigInfo)object).startPointReport);
        t.a(configInfo.destroyAppIds, ((ConfigInfo)object).syncInfoInterval);
        u.i();
        if (configInfo.configRefresh && (config = ((ConfigInfo)object).config) != null && config.version > 0) {
            this.saveConfig(config);
            this.putSpValue("push_self_destroying", ((ConfigInfo)object).config.destroy);
        }
        if (((ConfigInfo)object).whitelistRefresh && (object = ((ConfigInfo)object).whitelist) != null && ((ConfigInfo.Whitelist)object).version > 0) {
            this.saveWhiteList((ConfigInfo.Whitelist)object);
        }
        this.saveReportTime(System.currentTimeMillis() + q.c());
        Tracker.getInstance().trackInstall();
    }

    @Override
    public void syncSelfDestroying() {
        if (this.c == null) {
            PushLogUtils.LOG.w((Object)"mRemoteDataSource is null");
            return;
        }
        Tracker.getInstance().trackReport();
        SelfDestroyInfo selfDestroyInfo = this.c.a();
        if (selfDestroyInfo == null) {
            PushLogUtils.LOG.e((Object)"sync self-destroying fail");
            this.putSpValue("push_self_destroying_time", System.currentTimeMillis() + q.f());
            return;
        }
        PushRepository pushRepository = this;
        PushLogUtils.LOG.d((Object)("get self-destroying response data: " + selfDestroyInfo.toString()));
        this.putSpValue("push_self_destroying", selfDestroyInfo.destroy);
        pushRepository.putSpValue("push_self_destroying_interval", selfDestroyInfo.interval);
        pushRepository.putSpValue("push_self_destroying_time", System.currentTimeMillis() + q.f());
    }

    @Override
    public void getClientId(IClientIdListener iClientIdListener) {
        PushLogUtils.LOG.d((Object)"get client id");
        String string = this.getSpValue("push_client_id", "");
        if (!TextUtils.isEmpty((CharSequence)string) && iClientIdListener != null) {
            iClientIdListener.onSuccess(string);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.getSpValue("push_token", ""))) {
            i.a(new e(this, iClientIdListener));
        } else {
            this.a(iClientIdListener);
        }
    }
}

