/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.afmobi.tudcsdk.TudcsdkException;
import com.afmobi.tudcsdk.constant.BuildApkConfig;
import com.afmobi.tudcsdk.internal.MidCoreWrapper;
import com.afmobi.tudcsdk.utils.ValidateUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.log.LogUtils;

public final class Tudcsdk {
    private static Boolean sdkInitialized = Boolean.FALSE;
    private static Context applicationConext;
    private static int callbackRequestCodeOffset;
    private static String mUserApp_Id;
    private static String mUserApp_Key;
    private static String mUserApp_Secret;
    private static String mGoogleServerClientId;
    private static String mFaceBookAppId;
    private static String mTwitterKey;
    private static String mTwitterSecret;
    private static InitializeCallback mInitializeCallback;
    private static boolean toShareTgtByAuthorize;
    private static boolean allowToLoginByShareTgt;
    private static String mChannelId;
    private static int appFrontCount;
    public static int RUN_ENVIRONMENT_TEST;
    public static int RUN_ENVIRONMENT_PROD;
    public static int RUN_ENVIRONMENT_PRE_PROD;
    public static int RUN_ENVIRONMENT_MUTIDATA;

    public static synchronized void sdkInitialize(Context context, InitializeCallback initializeCallback) {
        CoreUtil.init((Context)context);
        mInitializeCallback = initializeCallback;
        applicationConext = context;
        sdkInitialized = Boolean.TRUE;
        ValidateUtil.notNull(context, "applicationContext");
        MidCoreWrapper.initMidCore(context);
    }

    public static void loadDefaultsFromMetadata(Context context) {
        Object object;
        if (context == null) {
            return;
        }
        try {
            context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
        if (context == null || context.metaData == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)mUserApp_Id)) {
            object = context.metaData.get("com.afmobi.tudc.APPID");
            if (object instanceof String) {
                mUserApp_Id = (String)object;
            } else if (object instanceof Integer) {
                throw new TudcsdkException("App Ids cannot be directly placed in the manifest.They must be placed in the string resource file.");
            }
        }
        if (TextUtils.isEmpty((CharSequence)mUserApp_Key)) {
            object = context.metaData.get("com.afmobi.tudc.APPKEY");
            if (object instanceof String) {
                mUserApp_Key = (String)object;
            } else if (object instanceof Integer) {
                throw new TudcsdkException("App Ids cannot be directly placed in the manifest.They must be placed in the string resource file.");
            }
        }
        if (TextUtils.isEmpty((CharSequence)mUserApp_Secret)) {
            object = context.metaData.get("com.afmobi.tudc.APPSECRET");
            if (object instanceof String) {
                mUserApp_Secret = (String)object;
            } else if (object instanceof Integer) {
                throw new TudcsdkException("App Ids cannot be directly placed in the manifest.They must be placed in the string resource file.");
            }
        }
        if (TextUtils.isEmpty((CharSequence)mGoogleServerClientId) && (object = context.metaData.get("com.google.server.clientId")) instanceof String) {
            mGoogleServerClientId = (String)object;
        }
        if (TextUtils.isEmpty((CharSequence)mFaceBookAppId) && (object = context.metaData.get("com.facebook.sdk.ApplicationId")) instanceof String) {
            mFaceBookAppId = (String)object;
        }
        if (TextUtils.isEmpty((CharSequence)mTwitterKey) && (object = context.metaData.get("com.twitter.sdk.twitterKey")) instanceof String) {
            mTwitterKey = (String)object;
        }
        if (TextUtils.isEmpty((CharSequence)mTwitterSecret) && (object = context.metaData.get("com.twitter.sdk.twitterSecret")) instanceof String) {
            mTwitterSecret = (String)object;
        }
    }

    public static synchronized boolean isInitialized() {
        if (!sdkInitialized.booleanValue()) {
            LogUtils.e((Object)"sdkInitialized is false");
        }
        return sdkInitialized;
    }

    public static synchronized void setDebugModel(boolean bl) {
        BuildApkConfig.setDebugMode(bl);
    }

    public static synchronized void setToShareTgtByAuthorize(boolean bl) {
        toShareTgtByAuthorize = bl;
    }

    public static synchronized void setChannelId(String string) {
        mChannelId = string;
    }

    public static String getChannelId() {
        return mChannelId;
    }

    public static synchronized void setIsReleaseSignature(boolean bl) {
        BuildApkConfig.setIsReleaseSignature(bl);
    }

    public static boolean isReleaseSignature() {
        return BuildApkConfig.isReleaseSignature();
    }

    public static synchronized boolean getToShareTgtByAuthorizeState() {
        return toShareTgtByAuthorize;
    }

    public static synchronized void setAllowToLoginBySharedTgt(boolean bl) {
        allowToLoginByShareTgt = bl;
    }

    public static boolean getAllowToLoginBySharedTgtStatus() {
        return allowToLoginByShareTgt;
    }

    public static int getCallbackRequestCodeOffset() {
        return callbackRequestCodeOffset;
    }

    public static Context getApplicationContext() {
        if (applicationConext == null) {
            return CoreUtil.getContext();
        }
        return applicationConext;
    }

    public static String getUserApp_Id() {
        if (TextUtils.isEmpty((CharSequence)mUserApp_Id)) {
            Tudcsdk.loadDefaultsFromMetadata(CoreUtil.getContext());
        }
        return mUserApp_Id;
    }

    public static String getUserApp_Key() {
        if (TextUtils.isEmpty((CharSequence)mUserApp_Key)) {
            Tudcsdk.loadDefaultsFromMetadata(CoreUtil.getContext());
        }
        return mUserApp_Key;
    }

    public static String getmUserApp_Secret() {
        if (TextUtils.isEmpty((CharSequence)mUserApp_Secret)) {
            Tudcsdk.loadDefaultsFromMetadata(CoreUtil.getContext());
        }
        return mUserApp_Secret;
    }

    public static String getGoogleServerClientId() {
        return mGoogleServerClientId;
    }

    public static String getFaceBookAppId() {
        return mFaceBookAppId;
    }

    public static String getTwitterKey() {
        return mTwitterKey;
    }

    public static String getTwitterSecret() {
        return mTwitterSecret;
    }

    public static InitializeCallback getInitializeCallback() {
        return mInitializeCallback;
    }

    public static void setRuntimeEnvironment(int n2) {
        BuildApkConfig.setRuntimeEnvironment(n2);
    }

    public static int getRuntimeEnvironment() {
        return BuildApkConfig.getServerType();
    }

    static {
        callbackRequestCodeOffset = 44976;
        mUserApp_Id = "";
        mUserApp_Key = "";
        mUserApp_Secret = "";
        mGoogleServerClientId = "";
        mFaceBookAppId = "";
        mTwitterKey = "";
        mTwitterSecret = "";
        toShareTgtByAuthorize = false;
        allowToLoginByShareTgt = true;
        mChannelId = "";
        appFrontCount = 0;
        RUN_ENVIRONMENT_TEST = 0;
        RUN_ENVIRONMENT_PROD = 2;
        RUN_ENVIRONMENT_PRE_PROD = 3;
        RUN_ENVIRONMENT_MUTIDATA = 4;
    }

    public static interface InitializeCallback {
        public void onInitialized();

        public void onPermissionError(String[] var1);
    }
}

