/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.login.region.model;

import android.content.Context;
import com.afmobi.tudcsdk.login.region.model.Country;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RegionData {
    private static RegionData instance;
    private static JSONArray allCountryCCMccJson;

    public static RegionData getInstance() {
        if (instance == null) {
            instance = new RegionData();
        }
        return instance;
    }

    public String[] getCountry_cc_FromMcc(String string2, Context stringArray) {
        if (allCountryCCMccJson == null) {
            this.readAssertCountryList((Context)stringArray);
        }
        stringArray = new String[]{"", ""};
        try {
            if (allCountryCCMccJson != null) {
                int n2 = allCountryCCMccJson.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = allCountryCCMccJson.getJSONObject(i2);
                    if (!jSONObject.getString("mcc").equals(string2)) continue;
                    stringArray[0] = jSONObject.getString("cc");
                    stringArray[1] = jSONObject.getString("country");
                    return stringArray;
                }
            }
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
        }
        return stringArray;
    }

    public String getCountryFromCode(String string2, Context object) {
        if (allCountryCCMccJson == null) {
            this.readAssertCountryList((Context)object);
        }
        try {
            if (allCountryCCMccJson != null) {
                int n2 = allCountryCCMccJson.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = allCountryCCMccJson.getJSONObject(i2);
                    if (!jSONObject.getString("cc").equals(string2)) continue;
                    return jSONObject.getString("country");
                }
            }
        }
        catch (JSONException jSONException) {
            object = jSONException;
            jSONException.printStackTrace();
        }
        return "";
    }

    public String[] getCountryAndDefaultRegionFromMcc(String string2, Context stringArray) {
        if (allCountryCCMccJson == null) {
            this.readAssertCountryList((Context)stringArray);
        }
        stringArray = new String[]{"", "", ""};
        try {
            if (allCountryCCMccJson != null) {
                int n2 = allCountryCCMccJson.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = allCountryCCMccJson.getJSONObject(i2);
                    if (!jSONObject.getString("mcc").equals(string2)) continue;
                    stringArray[0] = jSONObject.getString("country");
                    return stringArray;
                }
            }
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
        }
        return stringArray;
    }

    public JSONArray readAssertCountryList(Context object) {
        if (allCountryCCMccJson == null) {
            object = object.getAssets();
            String string2 = "";
            try {
                object = object.open("sdk_country_cc_mcc.json");
                string2 = this.getStringFromInputStream((InputStream)object);
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
            try {
                object = new JSONObject(string2);
                object = object.getJSONObject("contents");
                allCountryCCMccJson = object.getJSONArray("list");
            }
            catch (JSONException jSONException) {
                object = jSONException;
                jSONException.printStackTrace();
            }
        }
        return allCountryCCMccJson;
    }

    public ArrayList getCountryList_toArrayList(Context context) {
        ArrayList<Country> arrayList = new ArrayList<Country>();
        if (allCountryCCMccJson == null) {
            this.readAssertCountryList(context);
        }
        if (allCountryCCMccJson != null) {
            int n2 = allCountryCCMccJson.length();
            try {
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = allCountryCCMccJson.getJSONObject(i2);
                    Country country = new Country();
                    country.setCountryAbbreviation(jSONObject.getString("abbreviation"));
                    country.setCountry(jSONObject.getString("country"));
                    country.setCode(jSONObject.getString("cc"));
                    country.setMCC(jSONObject.getString("mcc"));
                    arrayList.add(country);
                }
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                jSONException.printStackTrace();
            }
        }
        return arrayList;
    }

    public HashMap getCountryCodeHash(Context context) {
        HashMap<String, Country> hashMap = new HashMap<String, Country>();
        if (allCountryCCMccJson == null) {
            this.readAssertCountryList(context);
        }
        if (allCountryCCMccJson != null) {
            int n2 = allCountryCCMccJson.length();
            try {
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = allCountryCCMccJson.getJSONObject(i2);
                    Country country = new Country();
                    country.setCountryAbbreviation(jSONObject.getString("abbreviation"));
                    country.setCountry(jSONObject.getString("country"));
                    country.setCode(jSONObject.getString("cc"));
                    country.setMCC(jSONObject.getString("mcc"));
                    hashMap.put(jSONObject.getString("mcc"), country);
                }
            }
            catch (JSONException jSONException) {
                JSONException jSONException2 = jSONException;
                jSONException.printStackTrace();
            }
        }
        return hashMap;
    }

    public String getCcFromCountry(String string2, Context object) {
        if (allCountryCCMccJson == null) {
            this.readAssertCountryList((Context)object);
        }
        object = "";
        try {
            if (allCountryCCMccJson != null) {
                int n2 = allCountryCCMccJson.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = allCountryCCMccJson.getJSONObject(i2);
                    if (!jSONObject.getString("country").equals(string2)) continue;
                    object = jSONObject.getString("cc");
                }
            }
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getStringFromInputStream(InputStream object) {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            while ((object = bufferedReader.readLine()) != null) {
                stringBuilder.append((String)object);
            }
        }
        catch (IOException iOException) {
            if (bufferedReader == null) return stringBuilder.toString();
            try {
                bufferedReader.close();
                return stringBuilder.toString();
            }
            catch (IOException iOException2) {
                return stringBuilder.toString();
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return stringBuilder.toString();
        }
    }
}

