/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class AdvertisingIdClientUtil {
    public static AdInfo getAdvertisingIdInfo(Context context) throws Exception {
        Object object;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot be called from the main thread");
        }
        try {
            object = context.getPackageManager();
            object.getPackageInfo("com.android.vending", 0);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw exception;
        }
        object = new AdvertisingConnection();
        Object object2 = new Intent("com.google.android.gms.ads.identifier.service.START");
        object2.setPackage("com.google.android.gms");
        if (context.bindService((Intent)object2, (ServiceConnection)object, 1)) {
            try {
                object2 = new AdvertisingInterface(((AdvertisingConnection)object).getBinder());
                object2 = new AdInfo(((AdvertisingInterface)object2).getId(), ((AdvertisingInterface)object2).isLimitAdTrackingEnabled(true));
                return object2;
            }
            catch (Exception exception) {
                object2 = exception;
                throw exception;
            }
            finally {
                context.unbindService((ServiceConnection)object);
            }
        }
        throw new IOException("Google Play connection failed");
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        public AdvertisingInterface(IBinder iBinder) {
            this.binder = iBinder;
        }

        public final IBinder asBinder() {
            return this.binder;
        }

        public final String getId() throws RemoteException {
            String string;
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            try {
                parcel.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, parcel, parcel2, 0);
                parcel2.readException();
                string = parcel2.readString();
            }
            finally {
                parcel2.recycle();
                parcel.recycle();
            }
            return string;
        }

        public final boolean isLimitAdTrackingEnabled(boolean bl) throws RemoteException {
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            try {
                parcel.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                parcel.writeInt(bl ? 1 : 0);
                this.binder.transact(2, parcel, parcel2, 0);
                parcel2.readException();
                bl = 0 != parcel2.readInt();
            }
            finally {
                parcel2.recycle();
                parcel.recycle();
            }
            return bl;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue queue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this.queue.put(iBinder);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }

        public final IBinder getBinder() throws InterruptedException {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return (IBinder)this.queue.take();
        }
    }

    public static final class AdInfo {
        private final String advertisingId;
        private final boolean limitAdTrackingEnabled;

        AdInfo(String string, boolean bl) {
            this.advertisingId = string;
            this.limitAdTrackingEnabled = bl;
        }

        public final String getId() {
            return this.advertisingId;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }
    }
}

