/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.afmobi.tudcsdk.utils.LogUtils;

public class NetWorkUtil {
    private static final String TAG = NetWorkUtil.class.getSimpleName();
    public static final int CHINA_MOBILE = 1;
    public static final int CHINA_UNICOM = 2;
    public static final int CHINA_TELECOM = 3;
    public static final int SIM_OK = 0;
    public static final int SIM_NO = -1;
    public static final int SIM_UNKNOW = -2;
    public static boolean proxy = false;
    public static final String CONN_TYPE_WIFI = "wifi";
    public static final String CONN_TYPE_GPRS = "gprs";
    public static final String CONN_TYPE_NONE = "none";

    public static boolean isAvailable(Context context) {
        boolean bl = false;
        if (NetWorkUtil.getNetworkType(context) >= 0) {
            bl = true;
        }
        return bl;
    }

    public static int getNetworkType(Context context) {
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) != null && (context = context.getActiveNetworkInfo()) != null && context.isConnectedOrConnecting()) {
            return context.getType();
        }
        return -9;
    }

    public static String getNetworkInfo(Context context) {
        NetworkInfo.State state;
        String string = null;
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            string = null;
        } else if ((context = context.getActiveNetworkInfo()) != null && ((state = context.getState()) == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            string = context.getTypeName() + " " + context.getSubtypeName() + context.getExtraInfo();
        }
        return string;
    }

    public static String getNetConnType(Context context) {
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            LogUtils.w(TAG, "Networkcan not get Context.CONNECTIVITY_SERVICE");
            return CONN_TYPE_NONE;
        }
        NetworkInfo networkInfo = context.getNetworkInfo(1);
        if (networkInfo != null) {
            if (NetworkInfo.State.CONNECTED == (networkInfo = networkInfo.getState())) {
                return CONN_TYPE_WIFI;
            }
        } else {
            LogUtils.w(TAG, "Networkcan not get ConnectivityManager.TYPE_WIFI");
        }
        networkInfo = context.getNetworkInfo(0);
        if (networkInfo != null) {
            if (NetworkInfo.State.CONNECTED == (networkInfo = networkInfo.getState())) {
                return CONN_TYPE_GPRS;
            }
        } else {
            LogUtils.w(TAG, "Networkcan not get ConnectivityManager.TYPE_MOBILE");
        }
        return CONN_TYPE_NONE;
    }

    public static WifiInfo getWifiInfo(Context context) {
        if ((context = (WifiManager)context.getSystemService(CONN_TYPE_WIFI)) == null) {
            return null;
        }
        if ((context = context.getConnectionInfo()) == null) {
            return null;
        }
        if (context.getBSSID() == null) {
            return null;
        }
        String string = context.getSSID();
        int n2 = WifiManager.calculateSignalLevel((int)context.getRssi(), (int)5);
        int n3 = context.getLinkSpeed();
        LogUtils.i(TAG, "Network--ssid===" + string + "====signalLevel=====" + n2 + "===speed====" + n3);
        return context;
    }

    public static String getNetType(Context context) {
        NetworkInfo.State state = null;
        NetworkInfo.State state2 = null;
        String string = "";
        NetworkInfo networkInfo = (context = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1);
        if (networkInfo != null) {
            state = networkInfo.getState();
        }
        if ((networkInfo = context.getNetworkInfo(0)) != null) {
            state2 = networkInfo.getState();
        }
        if (state != null && state2 != null && NetworkInfo.State.CONNECTED != state && NetworkInfo.State.CONNECTED == state2) {
            string = "mobile";
            LogUtils.i(TAG, "MOBILE NET IS OK");
        } else if (state != null && state2 != null && NetworkInfo.State.CONNECTED != state && NetworkInfo.State.CONNECTED != state2) {
            string = "nonet";
            LogUtils.i(TAG, "MOBILE NET AND WIFI IS ERROR");
        } else if (state != null && NetworkInfo.State.CONNECTED == state) {
            string = CONN_TYPE_WIFI;
            LogUtils.i(TAG, "WIFI NET IS OK");
        }
        return string;
    }
}

