/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.afmobi.tudcsdk.internal.bean.DeviceInfo;
import com.afmobi.tudcsdk.utils.LogUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OsInfoUtil {
    public static DeviceInfo buildOsInfo(Context context) {
        DeviceInfo deviceInfo = new DeviceInfo();
        if (context != null) {
            String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            deviceInfo.setAndroidID(string);
            deviceInfo.setImei(OsInfoUtil.getRightIMEI(com.transsion.core.deviceinfo.DeviceInfo.getIMEI()));
            string = com.transsion.core.deviceinfo.DeviceInfo.getIMSI();
            deviceInfo.setImsi(string);
            if (string != null && string.length() >= 5) {
                deviceInfo.setMcc(string.substring(0, 3));
                deviceInfo.setMnc(string.substring(3, 5));
            }
            deviceInfo.setIp(OsInfoUtil.getLocalIpAddress());
            deviceInfo.setUa(Build.MODEL);
            string = OsInfoUtil.getVersionName(context);
            deviceInfo.setCver(string);
            deviceInfo.setOsVersion("Android;" + Build.VERSION.RELEASE);
            string = Build.BRAND;
            deviceInfo.setBrand(string);
            string = new DisplayMetrics();
            ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics((DisplayMetrics)string);
            deviceInfo.setWidthPixels(((DisplayMetrics)string).widthPixels);
            deviceInfo.setHeightPixels(((DisplayMetrics)string).heightPixels);
        }
        return deviceInfo;
    }

    private static String getLocalIpAddress() {
        block6: {
            try {
                block5: {
                    Object object = NetworkInterface.getNetworkInterfaces();
                    while (object.hasMoreElements()) {
                        Object object2 = object.nextElement();
                        object2 = ((NetworkInterface)object2).getInetAddresses();
                        while (object2.hasMoreElements()) {
                            InetAddress inetAddress = (InetAddress)object2.nextElement();
                            if (inetAddress.isLoopbackAddress()) continue;
                            object = inetAddress.getHostAddress().toString();
                            if (OsInfoUtil.verifi((String)object)) {
                                return object;
                            }
                            break block5;
                        }
                    }
                    break block6;
                }
                return "0.0.0.0";
            }
            catch (SocketException socketException) {
                LogUtils.e("WifiPreference IpAddress", socketException.toString());
            }
        }
        return "0.0.0.0";
    }

    private static boolean verifi(String object) {
        if (object == null) {
            return false;
        }
        Object object2 = "\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b";
        object2 = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        object = ((Pattern)object2).matcher((CharSequence)object);
        return ((Matcher)object).find();
    }

    private static String getVersionName(Context context) {
        String string = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            context = packageManager.getPackageInfo(context.getPackageName(), 0);
            string = context.versionName;
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = "";
            }
        }
        catch (Exception exception) {
            LogUtils.e("VersionInfo", "Exception " + exception.getMessage());
        }
        return string;
    }

    private static String getRightIMEI(String string) {
        if (!"".equals(string) && string != null && !"null".equals(string)) {
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!Character.isLetter(string.charAt(i2))) continue;
                String string2 = string;
                string = string2.replace(string2.charAt(i2), '0');
            }
            if (n2 < 15) {
                for (n2 = 0; n2 < 15 && (string = string + "9").length() != 15; ++n2) {
                }
            } else if (n2 > 15) {
                string = string.substring(0, 15);
            }
        }
        return string;
    }
}

