/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Looper;
import android.support.v4.content.PermissionChecker;
import android.text.TextUtils;
import android.util.Log;
import com.afmobi.tudcsdk.Tudcsdk;
import com.afmobi.tudcsdk.TudcsdkException;
import com.afmobi.tudcsdk.utils.PermissionUtils;
import java.util.ArrayList;
import java.util.Collection;

public final class ValidateUtil {
    private static final String TAG = ValidateUtil.class.getName();
    private static final String NO_INTERNET_PERMISSION_REASON = "No internet permissions granted for the app, please add <uses-permission android:name=\"android.permission.INTERNET\" /> to your AndroidManifest.xml.";
    private static final String NO_WRITE_EXTERNAL_PERMISSION_REASON = "No write external permissions granted for the app, please add <uses-permission android:name=\"android.permission.WRITE_EXTERNAL_STORAGE\" /> to your AndroidManifest.xml.";
    private static final String NO_READ_PHONE_STATE_PERMISSION_REASON = "No read phone state permissions granted for the app, please add <uses-permission android:name=\"android.permission.READ_PHONE_STATE\" /> to your AndroidManifest.xml.";
    private static final String TUDC_ACTIVITY_NOT_FOUND_REASON = "TudcSdkActivity is not declared in the AndroidManifest.xml, please add com.afmobi.tudcsdk.login.TudcSdkActivity to your AndroidManifest.xml file.";
    private static final String CONTENT_PROVIDER_NOT_FOUND_REASON = "A ContentProvider for this app was not set up in the AndroidManifest.xml, please add %s as a provider to your AndroidManifest.xml file.";
    public static final long OUTTIME_CLICK_DURATION = 500L;
    private static long lastClickTimestamp = 0L;

    public static void notNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("Argument '" + string + "' cannot be null");
        }
    }

    public static void notEmpty(Collection collection, String string) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Container '" + string + "' cannot be empty");
        }
    }

    public static void containsNoNulls(Collection object, String string) {
        ValidateUtil.notNull(object, string);
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 != null) continue;
            throw new NullPointerException("Container '" + string + "' cannot contain null values");
        }
    }

    public static void containsNoNullOrEmpty(Collection object, String string) {
        ValidateUtil.notNull(object, string);
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (string2 == null) {
                throw new NullPointerException("Container '" + string + "' cannot contain null values");
            }
            if (string2.length() != 0) continue;
            throw new IllegalArgumentException("Container '" + string + "' cannot contain empty values");
        }
    }

    public static void notEmptyAndContainsNoNulls(Collection collection, String string) {
        ValidateUtil.containsNoNulls(collection, string);
        ValidateUtil.notEmpty(collection, string);
    }

    public static void runningOnUiThread() {
        if (!Looper.getMainLooper().equals(Looper.myLooper())) {
            throw new TudcsdkException("This method should be called from the UI thread");
        }
    }

    public static void notNullOrEmpty(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Argument '" + string2 + "' cannot be null or empty");
        }
    }

    public static void oneOf(Object object, String string, Object ... objectArray) {
        for (Object object2 : objectArray) {
            if (!(object2 != null ? object2.equals(object) : object == null)) continue;
            return;
        }
        throw new IllegalArgumentException("Argument '" + string + "' was not one of the allowed values");
    }

    public static boolean checkPermissions() {
        String[] stringArray = ValidateUtil.getNoGrantedPermissions(Tudcsdk.getApplicationContext());
        if ((stringArray = stringArray.toArray(new String[stringArray.size()])).length != 0) {
            if (null != Tudcsdk.getInitializeCallback()) {
                Tudcsdk.getInitializeCallback().onPermissionError(stringArray);
            }
            return true;
        }
        return false;
    }

    public static boolean hasExternalStoragePermissions() {
        ValidateUtil.notNull(Tudcsdk.getApplicationContext(), "context");
        return PermissionChecker.checkSelfPermission((Context)Tudcsdk.getApplicationContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    public static void hasReadPhoneStatePermissions(Context context, boolean bl) {
        ValidateUtil.notNull(context, "context");
        if (PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            if (bl) {
                throw new IllegalStateException(NO_READ_PHONE_STATE_PERMISSION_REASON);
            }
            Log.w((String)TAG, (String)NO_READ_PHONE_STATE_PERMISSION_REASON);
        }
    }

    public static boolean hasReadPhoneStatePermissions(Context context) {
        ValidateUtil.notNull(context, "context");
        return PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0;
    }

    public static boolean hasAcceddNetworkStatePersission(Context context) {
        ValidateUtil.notNull(context, "context");
        return PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") == 0;
    }

    public static ArrayList getNoGrantedPermissions(Context context) {
        ValidateUtil.notNull(context, "context");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < PermissionUtils.requestPermissions.length; ++i2) {
            String string = PermissionUtils.requestPermissions[i2];
            if (PermissionChecker.checkSelfPermission((Context)context, (String)string) == 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void hasContentProvider(Context context) {
        ValidateUtil.notNull(context, "context");
    }

    public static boolean isClickInLimit() {
        long l2 = System.currentTimeMillis();
        if (l2 - lastClickTimestamp > 500L) {
            lastClickTimestamp = l2;
            return false;
        }
        lastClickTimestamp = l2;
        return true;
    }

    public static boolean isTudcExist() {
        if (Tudcsdk.getApplicationContext().getPackageName().equals("com.transsion.tudc")) {
            return false;
        }
        if (!ValidateUtil.checkPackage("com.transsion.tudc")) {
            return false;
        }
        Intent intent = new Intent();
        intent.setAction("com.tudc.platform.PLATFORM_ACTION");
        return ValidateUtil.resolveIntent(intent);
    }

    public static boolean checkPackage(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        try {
            Tudcsdk.getApplicationContext().getPackageManager().getApplicationInfo(string, 8192);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private static boolean resolveIntent(Intent intent) {
        intent = Tudcsdk.getApplicationContext().getPackageManager().resolveActivity(intent, 0);
        return intent != null;
    }
}

