/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.internal;

import android.content.Intent;
import android.util.SparseArray;
import com.afmobi.tudcsdk.CallbackManager;
import com.afmobi.tudcsdk.Tudcsdk;
import com.afmobi.tudcsdk.utils.LogUtils;
import com.afmobi.tudcsdk.utils.ValidateUtil;

public final class CallbackManagerImpl
implements CallbackManager {
    private static SparseArray<Callback> staticCallbacks = new SparseArray();
    private final String TAG = CallbackManagerImpl.class.getSimpleName();
    private SparseArray<Callback> callbacks = new SparseArray();

    public static synchronized void registerStaticCallback(int n2, Callback callback) {
        ValidateUtil.notNull(callback, "callback");
        if (staticCallbacks.indexOfKey(n2) > 0) {
            return;
        }
        staticCallbacks.put(n2, (Object)callback);
    }

    private static synchronized Callback getStaticCallback(Integer n2) {
        return (Callback)staticCallbacks.get(n2.intValue());
    }

    private static boolean runStaticCallback(int n2, int n3, Intent intent) {
        Callback callback = CallbackManagerImpl.getStaticCallback(n2);
        if (callback != null) {
            return callback.onActivityResult(n3, intent);
        }
        return false;
    }

    public void registerCallback(int n2, Callback callback) {
        ValidateUtil.notNull(callback, "callback");
        this.callbacks.put(n2, (Object)callback);
    }

    @Override
    public boolean onActivityResult(int n2, int n3, Intent intent) {
        CallbackManagerImpl callbackManagerImpl = callback;
        LogUtils.d(callbackManagerImpl.TAG, "---requestCode=====" + n2 + "---------resultCode-------" + n3);
        Callback callback = (Callback)callbackManagerImpl.callbacks.get(n2);
        if (callback != null) {
            return callback.onActivityResult(n3, intent);
        }
        return CallbackManagerImpl.runStaticCallback(n2, n3, intent);
    }

    public static enum RequestCodeOffset {
        Login(0),
        Authorize(1),
        ShareTgtAuthorize(2),
        ChangeBindPHone(3),
        AuthorizeNotLoginToLogin(4),
        LoginByOldAccount(5);

        private final int offset;

        private RequestCodeOffset(int n3) {
            this.offset = n3;
        }

        public int toRequestCode() {
            return Tudcsdk.getCallbackRequestCodeOffset() + this.offset;
        }
    }

    public static interface Callback {
        public boolean onActivityResult(int var1, Intent var2);
    }
}

