/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Looper;
import android.support.v4.content.PermissionChecker;
import android.text.TextUtils;
import android.util.Log;
import com.afmobi.tudcsdk.Tudcsdk;
import com.afmobi.tudcsdk.TudcsdkException;
import com.afmobi.tudcsdk.utils.PermissionUtils;
import java.util.ArrayList;
import java.util.Collection;

public final class ValidateUtil {
    private static final String TAG = "com.afmobi.tudcsdk.utils.ValidateUtil";
    private static final String NO_INTERNET_PERMISSION_REASON = "No internet permissions granted for the app, please add <uses-permission android:name=\"android.permission.INTERNET\" /> to your AndroidManifest.xml.";
    private static final String NO_WRITE_EXTERNAL_PERMISSION_REASON = "No write external permissions granted for the app, please add <uses-permission android:name=\"android.permission.WRITE_EXTERNAL_STORAGE\" /> to your AndroidManifest.xml.";
    private static final String NO_READ_PHONE_STATE_PERMISSION_REASON = "No read phone state permissions granted for the app, please add <uses-permission android:name=\"android.permission.READ_PHONE_STATE\" /> to your AndroidManifest.xml.";
    private static final String TUDC_ACTIVITY_NOT_FOUND_REASON = "TudcSdkActivity is not declared in the AndroidManifest.xml, please add com.afmobi.tudcsdk.login.TudcSdkActivity to your AndroidManifest.xml file.";
    private static final String CONTENT_PROVIDER_NOT_FOUND_REASON = "A ContentProvider for this app was not set up in the AndroidManifest.xml, please add %s as a provider to your AndroidManifest.xml file.";
    public static final long OUTTIME_CLICK_DURATION = 500L;
    private static long lastClickTimestamp = 0L;

    public static void notNull(Object object, String string2) {
        if (object != null) {
            return;
        }
        throw new NullPointerException("Argument '" + string2 + "' cannot be null");
    }

    public static <T> void notEmpty(Collection<T> collection, String string2) {
        if (!collection.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException("Container '" + string2 + "' cannot be empty");
    }

    public static <T> void containsNoNulls(Collection<T> object, String string2) {
        Collection<T> collection = object;
        ValidateUtil.notNull(collection, string2);
        object = collection.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            throw new NullPointerException("Container '" + string2 + "' cannot contain null values");
        }
    }

    public static void containsNoNullOrEmpty(Collection<String> object, String string2) {
        Collection<String> collection = object;
        ValidateUtil.notNull(collection, string2);
        for (String string3 : collection) {
            if (string3 != null) {
                if (string3.length() != 0) continue;
                throw new IllegalArgumentException("Container '" + string2 + "' cannot contain empty values");
            }
            throw new NullPointerException("Container '" + string2 + "' cannot contain null values");
        }
    }

    public static <T> void notEmptyAndContainsNoNulls(Collection<T> collection, String string2) {
        ValidateUtil.containsNoNulls(collection, string2);
        ValidateUtil.notEmpty(collection, string2);
    }

    public static void runningOnUiThread() {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            return;
        }
        throw new TudcsdkException("This method should be called from the UI thread");
    }

    public static void notNullOrEmpty(String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        throw new IllegalArgumentException("Argument '" + string3 + "' cannot be null or empty");
    }

    public static void oneOf(Object object, String string2, Object ... objectArray) {
        for (Object object2 : objectArray) {
            if (!(object2 != null ? object2.equals(object) : object == null)) continue;
            return;
        }
        throw new IllegalArgumentException("Argument '" + string2 + "' was not one of the allowed values");
    }

    public static boolean checkPermissions() {
        ArrayList<String> arrayList = ValidateUtil.getNoGrantedPermissions(Tudcsdk.getApplicationContext());
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (stringArray.length != 0) {
            if (Tudcsdk.getInitializeCallback() != null) {
                Tudcsdk.getInitializeCallback().onPermissionError(stringArray);
            }
            return true;
        }
        return false;
    }

    public static boolean hasExternalStoragePermissions() {
        ValidateUtil.notNull(Tudcsdk.getApplicationContext(), "context");
        return PermissionChecker.checkSelfPermission((Context)Tudcsdk.getApplicationContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    public static void hasReadPhoneStatePermissions(Context context, boolean bl) {
        Context context2 = context;
        ValidateUtil.notNull(context2, "context");
        if (PermissionChecker.checkSelfPermission((Context)context2, (String)"android.permission.READ_PHONE_STATE") != 0) {
            if (!bl) {
                Log.w((String)TAG, (String)NO_READ_PHONE_STATE_PERMISSION_REASON);
            } else {
                throw new IllegalStateException(NO_READ_PHONE_STATE_PERMISSION_REASON);
            }
        }
    }

    public static boolean hasReadPhoneStatePermissions(Context context) {
        Context context2 = context;
        ValidateUtil.notNull(context2, "context");
        return PermissionChecker.checkSelfPermission((Context)context2, (String)"android.permission.READ_PHONE_STATE") == 0;
    }

    public static boolean hasAcceddNetworkStatePersission(Context context) {
        Context context2 = context;
        ValidateUtil.notNull(context2, "context");
        return PermissionChecker.checkSelfPermission((Context)context2, (String)"android.permission.ACCESS_NETWORK_STATE") == 0;
    }

    public static ArrayList<String> getNoGrantedPermissions(Context context) {
        ArrayList<String> arrayList;
        ValidateUtil.notNull(context, "context");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        int n2 = 0;
        while (true) {
            Object object = PermissionUtils.requestPermissions;
            if (n2 >= PermissionUtils.requestPermissions.length) break;
            if (PermissionChecker.checkSelfPermission((Context)context, (String)(object = object[n2])) != 0) {
                arrayList2.add((String)object);
            }
            ++n2;
        }
        return arrayList2;
    }

    public static void hasContentProvider(Context context) {
        ValidateUtil.notNull(context, "context");
    }

    public static boolean isClickInLimit() {
        long l2 = System.currentTimeMillis();
        if (l2 - lastClickTimestamp > 500L) {
            lastClickTimestamp = l2;
            return false;
        }
        lastClickTimestamp = l2;
        return true;
    }

    public static boolean isTudcExist() {
        if (Tudcsdk.getApplicationContext().getPackageName().equals("com.transsion.tudc")) {
            return false;
        }
        if (!ValidateUtil.checkPackage("com.transsion.tudc")) {
            return false;
        }
        Intent intent = new Intent();
        intent.setAction("com.tudc.platform.PLATFORM_ACTION");
        return ValidateUtil.resolveIntent(intent);
    }

    public static boolean checkPackage(String string2) {
        if (string2 != null && !"".equals(string2)) {
            try {
                Tudcsdk.getApplicationContext().getPackageManager().getApplicationInfo(string2, 8192);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean resolveIntent(Intent intent) {
        return Tudcsdk.getApplicationContext().getPackageManager().resolveActivity(intent, 0) != null;
    }
}

