/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.transsion.core.log.LogUtils;

public class NetWorkUtil {
    private static final String TAG = "NetWorkUtil";
    public static final int CHINA_MOBILE = 1;
    public static final int CHINA_UNICOM = 2;
    public static final int CHINA_TELECOM = 3;
    public static final int SIM_OK = 0;
    public static final int SIM_NO = -1;
    public static final int SIM_UNKNOW = -2;
    public static boolean proxy = false;
    public static final String CONN_TYPE_WIFI = "wifi";
    public static final String CONN_TYPE_GPRS = "gprs";
    public static final String CONN_TYPE_NONE = "none";

    public static boolean isAvailable(Context context) {
        boolean bl = false;
        if (NetWorkUtil.getNetworkType(context) >= 0) {
            bl = true;
        }
        return bl;
    }

    public static int getNetworkType(Context context) {
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) != null && (context = context.getActiveNetworkInfo()) != null && context.isConnectedOrConnecting()) {
            return context.getType();
        }
        return -9;
    }

    public static String getNetworkInfo(Context object) {
        NetworkInfo.State state;
        Context context = object;
        object = null;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            object = null;
        } else if ((connectivityManager = connectivityManager.getActiveNetworkInfo()) != null && ((state = connectivityManager.getState()) == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            object = connectivityManager.getTypeName() + " " + connectivityManager.getSubtypeName() + connectivityManager.getExtraInfo();
        }
        return object;
    }

    public static String getNetConnType(Context context) {
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            LogUtils.w((String)TAG, (Object[])new Object[]{"Networkcan not get Context.CONNECTIVITY_SERVICE"});
            return CONN_TYPE_NONE;
        }
        NetworkInfo networkInfo = context.getNetworkInfo(1);
        if (networkInfo != null) {
            if (NetworkInfo.State.CONNECTED == networkInfo.getState()) {
                return CONN_TYPE_WIFI;
            }
        } else {
            LogUtils.w((String)TAG, (Object[])new Object[]{"Networkcan not get ConnectivityManager.TYPE_WIFI"});
        }
        if ((context = context.getNetworkInfo(0)) != null) {
            if (NetworkInfo.State.CONNECTED == context.getState()) {
                return CONN_TYPE_GPRS;
            }
        } else {
            LogUtils.w((String)TAG, (Object[])new Object[]{"Networkcan not get ConnectivityManager.TYPE_MOBILE"});
        }
        return CONN_TYPE_NONE;
    }

    public static WifiInfo getWifiInfo(Context object) {
        if ((object = (WifiManager)object.getSystemService(CONN_TYPE_WIFI)) == null) {
            return null;
        }
        if ((object = object.getConnectionInfo()) == null) {
            return null;
        }
        if (object.getBSSID() == null) {
            return null;
        }
        Context context = object;
        object = context.getSSID();
        int n2 = WifiManager.calculateSignalLevel((int)context.getRssi(), (int)5);
        int n3 = context.getLinkSpeed();
        LogUtils.i((String)TAG, (Object[])new Object[]{"Network--ssid===" + (String)object + "====signalLevel=====" + n2 + "===speed====" + n3});
        return context;
    }

    public static String getNetType(Context context) {
        Context context2 = context;
        context = null;
        NetworkInfo.State state = null;
        String string2 = "";
        ConnectivityManager connectivityManager = (ConnectivityManager)context2.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        if (networkInfo != null) {
            context = networkInfo.getState();
        }
        if ((connectivityManager = connectivityManager.getNetworkInfo(0)) != null) {
            state = connectivityManager.getState();
        }
        if (context != null && state != null && (connectivityManager = NetworkInfo.State.CONNECTED) != context && connectivityManager == state) {
            string2 = "mobile";
            LogUtils.i((String)TAG, (Object[])new Object[]{"MOBILE NET IS OK"});
        } else if (context != null && state != null && (connectivityManager = NetworkInfo.State.CONNECTED) != context && connectivityManager != state) {
            string2 = "nonet";
            LogUtils.i((String)TAG, (Object[])new Object[]{"MOBILE NET AND WIFI IS ERROR"});
        } else if (context != null && NetworkInfo.State.CONNECTED == context) {
            string2 = CONN_TYPE_WIFI;
            LogUtils.i((String)TAG, (Object[])new Object[]{"WIFI NET IS OK"});
        }
        return string2;
    }
}

