/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.login;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.afmobi.tudcsdk.Tudcsdk;
import com.afmobi.tudcsdk.internal.CallbackManagerImpl;
import com.afmobi.tudcsdk.login.AuthorizeLoginFragment;
import com.afmobi.tudcsdk.login.BasePrsenterFragment;
import com.afmobi.tudcsdk.login.TudcSdkActivity;
import com.afmobi.tudcsdk.login.presenter.PlatformLoginPresenter;
import com.afmobi.tudcsdk.login.view.IPlatformLoginView;
import com.afmobi.tudcsdk.login.widget.AfCircularProgressView;
import com.afmobi.tudcsdk.utils.LogUtils;
import com.afmobi.tudcsdk.utils.ToastUtil;
import com.wxuier.tudc_auth.R;

@SuppressLint(value={"ValidFragment"})
public class TudcPlatformLoginFragment
extends BasePrsenterFragment<IPlatformLoginView, PlatformLoginPresenter>
implements IPlatformLoginView {
    public static int STARTMODE_HIACCOUNT = 1001;
    public static int STARTMODE_TUDC = 1002;
    public static int STARTMODE_AUTHORIZE = 1003;
    public static int STARTMODE_GETST = 1004;
    public static int STARTMODE_SHAREDTAG_AUTHORIZE = 1005;
    AfCircularProgressView mAfProgressBar;
    private final String TAG = TudcPlatformLoginFragment.class.getSimpleName();
    private int mCurrentStartMode = STARTMODE_HIACCOUNT;
    private String mTargetPackage = "";
    private String mThirdAppId = "";

    public TudcPlatformLoginFragment() {
    }

    public TudcPlatformLoginFragment(int n) {
        this.mCurrentStartMode = n;
    }

    public TudcPlatformLoginFragment(int n, String string2) {
        this.mCurrentStartMode = n;
        this.mTargetPackage = string2;
    }

    public TudcPlatformLoginFragment(String string2, int n) {
        this.mCurrentStartMode = n;
        this.mThirdAppId = string2;
    }

    public static TudcPlatformLoginFragment instantiate(int n) {
        return new TudcPlatformLoginFragment(n);
    }

    public static TudcPlatformLoginFragment instantiate(int n, String string2) {
        return new TudcPlatformLoginFragment(n, string2);
    }

    public static TudcPlatformLoginFragment instantiate(String string2, int n) {
        return new TudcPlatformLoginFragment(string2, n);
    }

    @Override
    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        layoutInflater = layoutInflater.inflate(R.layout.fragment_tudc_platform_login, null);
        this.mAfProgressBar = (AfCircularProgressView)layoutInflater.findViewById(R.id.waiting);
        int n = this.mCurrentStartMode;
        if (STARTMODE_HIACCOUNT == n) {
            ((PlatformLoginPresenter)this.presenter).toGetHiAccount(this);
        } else if (STARTMODE_TUDC == n) {
            Intent intent = new Intent("com.tudc.platform.PLATFORM_ACTION");
            intent.setPackage("com.transsion.tudc");
            intent.putExtra("third_appid", Tudcsdk.getUserApp_Id());
            this.startActivityForResult(intent, CallbackManagerImpl.RequestCodeOffset.Authorize.toRequestCode());
        } else if (STARTMODE_AUTHORIZE == n) {
            ((PlatformLoginPresenter)this.presenter).toGetUserSt();
        } else if (STARTMODE_GETST == n) {
            ((PlatformLoginPresenter)this.presenter).toGetUserSt();
        } else if (STARTMODE_SHAREDTAG_AUTHORIZE == n) {
            Intent intent = new Intent("com.tudc.platform.PLATFORM_ACTION");
            intent.setPackage(this.mTargetPackage);
            this.startActivityForResult(intent, CallbackManagerImpl.RequestCodeOffset.ShareTgtAuthorize.toRequestCode());
        }
        return layoutInflater;
    }

    @Override
    public void onResume() {
        TudcPlatformLoginFragment tudcPlatformLoginFragment = this;
        super.onResume();
        AfCircularProgressView afCircularProgressView = tudcPlatformLoginFragment.mAfProgressBar;
        if (afCircularProgressView != null && afCircularProgressView.getVisibility() != 0) {
            this.mAfProgressBar.setVisibility(0);
        }
    }

    public void onPause() {
        TudcPlatformLoginFragment tudcPlatformLoginFragment = this;
        super.onPause();
        AfCircularProgressView afCircularProgressView = tudcPlatformLoginFragment.mAfProgressBar;
        if (afCircularProgressView != null && afCircularProgressView.getVisibility() == 0) {
            this.mAfProgressBar.setVisibility(8);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        TudcPlatformLoginFragment tudcPlatformLoginFragment = this;
        super.onActivityResult(n, n2, intent);
        LogUtils.i((String)tudcPlatformLoginFragment.TAG, (String)"");
        ((PlatformLoginPresenter)tudcPlatformLoginFragment.presenter).onActivityResult(n, n2, intent);
        if (n == CallbackManagerImpl.RequestCodeOffset.Authorize.toRequestCode()) {
            if (n2 == 0) {
                n = 0;
                if (intent != null) {
                    n = intent.getIntExtra("cancel_code", 0);
                }
                if (this.getActivity() != null) {
                    ((TudcSdkActivity)this.getActivity()).loginCompleted(0, n);
                }
            } else if (n2 == -1 && intent != null) {
                Intent intent2 = intent;
                String string2 = intent2.getStringExtra("loginresult");
                String string3 = intent2.getStringExtra("login_errmsg");
                if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
                    LogUtils.i((String)this.TAG, (String)"------st--NULL---ERRMSG--MSG----");
                    string3 = "st===null";
                }
                if (this.getActivity() != null) {
                    ((TudcSdkActivity)this.getActivity()).loginCompleted(-1, string2, string3);
                }
            }
        } else if (CallbackManagerImpl.RequestCodeOffset.ShareTgtAuthorize.toRequestCode() == n) {
            if (n2 == 0) {
                n = 0;
                if (intent != null) {
                    n = intent.getIntExtra("cancel_code", 0);
                }
                if (this.getActivity() != null) {
                    ((TudcSdkActivity)this.getActivity()).loginCompleted(0, n);
                }
            } else if (n2 == -1 && intent != null) {
                Intent intent3 = intent;
                String string4 = intent3.getStringExtra("loginresult");
                String string5 = intent3.getStringExtra("login_errmsg");
                if (TextUtils.isEmpty((CharSequence)string4) && TextUtils.isEmpty((CharSequence)string5)) {
                    string5 = "st===null";
                } else {
                    ((PlatformLoginPresenter)this.presenter).cloneTgtByPackageName(this.mTargetPackage);
                }
                if (this.getActivity() != null) {
                    ((TudcSdkActivity)this.getActivity()).loginCompleted(-1, string4, string5);
                }
            }
        } else if (n == CallbackManagerImpl.RequestCodeOffset.AuthorizeNotLoginToLogin.toRequestCode()) {
            if (n2 == -1) {
                if (intent != null) {
                    this.mThirdAppId = intent.getStringExtra("third_appid");
                    ((PlatformLoginPresenter)this.presenter).toGetUserSt();
                }
            } else if (n2 == 0) {
                ((TudcSdkActivity)this.getActivity()).loginCompleted(0, null, "");
            }
        }
    }

    @Override
    protected PlatformLoginPresenter createPresenter() {
        return new PlatformLoginPresenter();
    }

    @Override
    public boolean onBackPressed() {
        if (this.getActivity() != null) {
            ((TudcSdkActivity)this.getActivity()).loginCompleted(0, null, "", "", "");
        }
        return false;
    }

    @Override
    public void onLoginSuccess(String string2) {
        if (this.getActivity() != null) {
            ((TudcSdkActivity)this.getActivity()).loginCompleted(-1, string2, "", "", "");
        } else {
            LogUtils.i((String)this.TAG, (String)"--------getActivity===NULL--------------");
        }
    }

    @Override
    public void onLoginFail(int n, String string2) {
        if (this.getActivity() != null) {
            if (n == 4096 && TextUtils.isEmpty((CharSequence)string2)) {
                string2 = Tudcsdk.getApplicationContext().getResources().getString(R.string.network_unavailable);
            }
            ((TudcSdkActivity)this.getActivity()).loginCompleted(-1, null, "", "", string2);
        } else {
            LogUtils.i((String)this.TAG, (String)"--------getActivity===NULL--------------");
        }
    }

    @Override
    public void onTudcGetUserStSuccess(String string2, String string3, String string4) {
        if (this.getActivity() != null && STARTMODE_AUTHORIZE == this.mCurrentStartMode) {
            ((TudcSdkActivity)this.getActivity()).replaceFragment(AuthorizeLoginFragment.newInstance(string2, string3, string4, this.mThirdAppId));
        }
    }

    @Override
    public void onTudcGetUserStError(int n, String string2) {
        if (-2 != n && 110005 != n && 199003 != n) {
            ToastUtil.showToast((Context)Tudcsdk.getApplicationContext(), (String)string2);
            if (this.getActivity() != null) {
                if (n == 4096 && TextUtils.isEmpty((CharSequence)string2)) {
                    string2 = Tudcsdk.getApplicationContext().getResources().getString(R.string.network_unavailable);
                }
                ((TudcSdkActivity)this.getActivity()).loginCompleted(-1, null, string2);
            }
        } else if (STARTMODE_AUTHORIZE == this.mCurrentStartMode) {
            Intent intent = new Intent("com.tudc.platform.LOGIN_ACTION");
            intent.setPackage(Tudcsdk.getApplicationContext().getPackageName());
            intent.putExtra("third_appid", this.mThirdAppId);
            this.startActivityForResult(intent, CallbackManagerImpl.RequestCodeOffset.AuthorizeNotLoginToLogin.toRequestCode());
        }
    }
}

