/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Looper;
import android.text.TextUtils;
import com.afmobi.tudcsdk.Tudcsdk;
import com.afmobi.tudcsdk.TudcsdkException;
import com.afmobi.tudcsdk.TudcsdkNotInitializedException;
import com.rlk.misdk.account.AccountInfo;
import com.rlk.misdk.account.UserAccountStore;
import java.util.Collection;

public final class AuthUtil {
    private static final String TAG = "com.afmobi.tudcsdk.utils.AuthUtil";
    private static final String NO_INTERNET_PERMISSION_REASON = "No internet permissions granted for the app, please add <uses-permission android:name=\"android.permission.INTERNET\" /> to your AndroidManifest.xml.";
    private static final String NO_WRITE_EXTERNAL_PERMISSION_REASON = "No write external permissions granted for the app, please add <uses-permission android:name=\"android.permission.WRITE_EXTERNAL_STORAGE\" /> to your AndroidManifest.xml.";
    private static final String NO_READ_PHONE_STATE_PERMISSION_REASON = "No read phone state permissions granted for the app, please add <uses-permission android:name=\"android.permission.READ_PHONE_STATE\" /> to your AndroidManifest.xml.";
    private static final String TUDC_ACTIVITY_NOT_FOUND_REASON = "TudcSdkActivity is not declared in the AndroidManifest.xml, please add com.afmobi.tudcsdk.login.TudcSdkActivity to your AndroidManifest.xml file.";
    private static final String CONTENT_PROVIDER_NOT_FOUND_REASON = "A ContentProvider for this app was not set up in the AndroidManifest.xml, please add %s as a provider to your AndroidManifest.xml file.";
    public static final long OUTTIME_CLICK_DURATION = 500L;
    private static long lastClickTimestamp = 0L;

    public static void notNull(Object object, String string2) {
        if (object != null) {
            return;
        }
        throw new NullPointerException("Argument '" + string2 + "' cannot be null");
    }

    public static <T> void notEmpty(Collection<T> collection, String string2) {
        if (!collection.isEmpty()) {
            return;
        }
        throw new IllegalArgumentException("Container '" + string2 + "' cannot be empty");
    }

    public static <T> void containsNoNulls(Collection<T> object, String string2) {
        Collection<T> collection = object;
        AuthUtil.notNull(collection, string2);
        object = collection.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            throw new NullPointerException("Container '" + string2 + "' cannot contain null values");
        }
    }

    public static void containsNoNullOrEmpty(Collection<String> object, String string2) {
        Collection<String> collection = object;
        AuthUtil.notNull(collection, string2);
        for (String string3 : collection) {
            if (string3 != null) {
                if (string3.length() != 0) continue;
                throw new IllegalArgumentException("Container '" + string2 + "' cannot contain empty values");
            }
            throw new NullPointerException("Container '" + string2 + "' cannot contain null values");
        }
    }

    public static <T> void notEmptyAndContainsNoNulls(Collection<T> collection, String string2) {
        AuthUtil.containsNoNulls(collection, string2);
        AuthUtil.notEmpty(collection, string2);
    }

    public static void runningOnUiThread() {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            return;
        }
        throw new TudcsdkException("This method should be called from the UI thread");
    }

    public static void notNullOrEmpty(String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        throw new IllegalArgumentException("Argument '" + string3 + "' cannot be null or empty");
    }

    public static void oneOf(Object object, String string2, Object ... objectArray) {
        for (Object object2 : objectArray) {
            if (!(object2 != null ? object2.equals(object) : object == null)) continue;
            return;
        }
        throw new IllegalArgumentException("Argument '" + string2 + "' was not one of the allowed values");
    }

    public static void sdkInitialized() {
        if (Tudcsdk.isInitialized()) {
            return;
        }
        throw new TudcsdkNotInitializedException("The SDK has not been initialized, make sure to call TudcSdk.sdkInitialize() first.");
    }

    public static boolean isHiAccountExist() {
        if (!AuthUtil.checkPackage("com.rlk.mi")) {
            return false;
        }
        Intent intent = new Intent();
        intent.setAction("com.rlk.mi.ACCOUNT");
        if (AuthUtil.resolveIntent(intent)) {
            return AuthUtil.isLogined();
        }
        return false;
    }

    private static boolean isLogined() {
        return AuthUtil.getAccountInfo(Tudcsdk.getApplicationContext()) != null;
    }

    private static AccountInfo getAccountInfo(Context context) {
        return new UserAccountStore(context).getAccount();
    }

    public static boolean checkPackage(String string2) {
        if (string2 != null && !"".equals(string2)) {
            PackageManager packageManager;
            try {
                packageManager = Tudcsdk.getApplicationContext().getPackageManager();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
            packageManager.getApplicationInfo(string2, 8192);
            return true;
        }
        return false;
    }

    private static boolean resolveIntent(Intent intent) {
        return Tudcsdk.getApplicationContext().getPackageManager().resolveActivity(intent, 0) != null;
    }

    public static boolean isTudcExist() {
        if (Tudcsdk.getApplicationContext().getPackageName().equals("com.transsion.tudc")) {
            return false;
        }
        if (!AuthUtil.checkPackage("com.transsion.tudc")) {
            return false;
        }
        Intent intent = new Intent();
        intent.setAction("com.tudc.platform.PLATFORM_ACTION");
        return AuthUtil.resolveIntent(intent);
    }
}

