/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.tudcui;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.core.CoreUtil;
import com.transsion.core.log.LogUtils;
import com.transsion.tudcui.bean.Profile;
import com.transsion.tudcui.ext.ITaskCallback;
import com.transsion.tudcui.ext.ITudcStub;
import com.transsion.tudcui.ext.InternalProfile;
import com.transsion.tudcui.listeners.InitListener;
import com.transsion.tudcui.listeners.Listeners;
import com.transsion.tudcui.listeners.LoginListener;
import com.transsion.tudcui.listeners.LogoutListener;
import com.transsion.tudcui.listeners.ProfileSyncListener;

public class TUDC {
    private static ITudcStub iTudcStub;
    private static Listeners listeners;
    private static ITaskCallback mCallback;
    private static ServiceConnection conn;

    private TUDC() {
    }

    public static void init(Context context, String string) {
        LogUtils.i((Object)("TUDC init chanel:" + string));
        CoreUtil.init((Context)context);
        new LogUtils.Builder().setBorderSwitch(false).setLogHeadSwitch(true).setGlobalTag("TUDC_LIB");
    }

    public static void unInit() {
        try {
            iTudcStub.unregisterCallback(mCallback);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        CoreUtil.getContext().unbindService(conn);
    }

    private static boolean isAvailable(Context object, String string) {
        object = object.getPackageManager().getInstalledPackages(0);
        for (int i = 0; i < object.size(); ++i) {
            if (!((PackageInfo)object.get((int)i)).packageName.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static void bindService() {
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent();
        if (TUDC.isAvailable(CoreUtil.getContext(), "com.transsion.tudc")) {
            ComponentName componentName;
            ComponentName componentName2 = componentName;
            componentName = new ComponentName("com.transsion.tudc", "com.transsion.tudcui.ext.IRemoteService");
            intent2.setComponent(componentName2);
        } else {
            intent2.setComponent(new ComponentName(CoreUtil.getContext().getPackageName(), "com.transsion.tudcui.ext.IRemoteService"));
        }
        CoreUtil.getContext().bindService(intent2, conn, 1);
    }

    public static void login() {
        TUDC.login(false);
    }

    public static void login(final boolean bl) {
        if (iTudcStub == null) {
            TUDC.registerListener(new InitListener(){

                public void onfinish() {
                    3 v0 = this;
                    TUDC.login(v0.bl);
                    TUDC.unregisterListener(v0);
                }
            });
            TUDC.bindService();
        } else {
            LogUtils.i((Object)("TUDC login, isThird:" + bl));
            try {
                iTudcStub.login(bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public static void register() {
        TUDC.login();
    }

    public static void logout() {
        LogUtils.i((Object)"TUDC logout");
        try {
            iTudcStub.logout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public static Profile getProfile() {
        Profile profile;
        block5: {
            Profile profile2;
            Profile profile3 = null;
            InternalProfile internalProfile = iTudcStub.getProfile();
            profile = profile2;
            try {
                profile2 = new Profile(internalProfile);
                break block5;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            profile = profile3;
        }
        return profile;
    }

    public static boolean isLogin() {
        try {
            return iTudcStub.isLogin();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return false;
    }

    public static void syncProfile() {
        try {
            iTudcStub.syncProfile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public static void enterProfile() {
        try {
            iTudcStub.enterProfile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public static String getToken() {
        try {
            return iTudcStub.getToken();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return null;
    }

    public static long getOpenId() {
        try {
            return iTudcStub.getOpenId();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return 0L;
    }

    public static void registerListener(LoginListener loginListener) {
        listeners.addLoginListener(loginListener);
    }

    public static void unregisterListener(LoginListener loginListener) {
        listeners.removeLoginListener(loginListener);
    }

    public static void registerListener(LogoutListener logoutListener) {
        listeners.addLogoutListener(logoutListener);
    }

    public static void unregisterListener(LogoutListener logoutListener) {
        listeners.removeLogoutListener(logoutListener);
    }

    public static void registerListener(InitListener initListener) {
        listeners.addInitListener(initListener);
        if (iTudcStub != null) {
            initListener.onfinish();
        }
    }

    public static void unregisterListener(InitListener initListener) {
        listeners.removeInitListener(initListener);
    }

    public static void registerListener(ProfileSyncListener profileSyncListener) {
        listeners.addProfileSyncListener(profileSyncListener);
    }

    public static void unregisterListener(ProfileSyncListener profileSyncListener) {
        listeners.removeProfileSyncListener(profileSyncListener);
    }

    static {
        listeners = new Listeners();
        mCallback = new ITaskCallback.Stub(){

            public void actionPerformed(int n) {
                if (n == 1) {
                    listeners.loginSuccess(TUDC.getOpenId(), TUDC.getToken());
                }
                if (n == 2) {
                    listeners.loginFail(-1, "");
                }
                if (n == 3) {
                    listeners.logoutSuccess();
                }
                if (n == 4) {
                    listeners.logoutFail(-1, "");
                }
                if (n == 5) {
                    listeners.profileSyncSuccess();
                }
                if (n == 6) {
                    listeners.profileSyncFail(-1, "");
                }
            }
        };
        conn = new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                LogUtils.i((Object)"TUDC onServiceConnected");
                TUDC.iTudcStub = ITudcStub.Stub.asInterface((IBinder)iBinder);
                try {
                    iTudcStub.registerCallback(mCallback);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                listeners.initFinish();
            }

            public void onServiceDisconnected(ComponentName componentName) {
                TUDC.iTudcStub = null;
            }
        };
    }
}

