/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.login.thirdpart;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.widget.Toast;
import com.afmobi.tudcsdk.Tudcsdk;
import com.afmobi.tudcsdk.login.model.FaceBookModel;
import com.afmobi.tudcsdk.login.model.listener.Tudc3rdInnerListener;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.Profile;
import com.facebook.R;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.transsion.core.log.LogUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class FaceBookLogin {
    private Context context;
    private CallbackManager callbackManager;
    private FacebookListener facebookListener;
    private List<String> permissions = Collections.emptyList();
    private LoginManager loginManager;
    private FaceBookModel mFaceBookModel;
    Tudc3rdInnerListener.FaceBookLoginListener mTudcInnerFaceBookLoginListener;

    public FaceBookLogin(Context context, Tudc3rdInnerListener.FaceBookLoginListener faceBookLoginListener, FaceBookModel faceBookModel) {
        this.context = context;
        this.mTudcInnerFaceBookLoginListener = faceBookLoginListener;
        if (!FacebookSdk.isInitialized()) {
            FacebookSdk.sdkInitialize((Context)Tudcsdk.getApplicationContext());
        }
        FaceBookLogin faceBookLogin = this;
        faceBookLogin.mFaceBookModel = faceBookModel;
        faceBookLogin.permissions = Arrays.asList("email", "user_likes", "user_status", "user_birthday", "public_profile", "user_friends");
    }

    private LoginManager getLoginManager() {
        if (this.loginManager == null) {
            this.loginManager = LoginManager.getInstance();
        }
        return this.loginManager;
    }

    public void login(Activity activity, boolean bl) {
        if (!bl) {
            LogUtils.d((Object)"facebook \u4e09\u65b9\u767b\u5f55\u5f00\u59cb");
            this.callbackManager = CallbackManager.Factory.create();
            this.getLoginManager().registerCallback(this.callbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

                public void onSuccess(LoginResult object) {
                    1 v0 = string2;
                    LogUtils.d((Object)"facebook \u4e09\u65b9\u767b\u5f55\u6210\u529f");
                    AccessToken accessToken = object.getAccessToken();
                    String string2 = accessToken.getUserId();
                    object = accessToken.getToken();
                    v0.FaceBookLogin.this.mFaceBookModel.tudcLogin(string2, (String)object);
                }

                public void onCancel() {
                    LogUtils.e((Object)"facebook \u4e09\u65b9\u767b\u5f55\u53d6\u6d88");
                    FaceBookLogin.this.mTudcInnerFaceBookLoginListener.facebookLoginCancel();
                }

                public void onError(FacebookException facebookException) {
                    LogUtils.e((Object)("facebook \u4e09\u65b9\u767b\u5f55\u9519\u8bef\uff0cmsg:" + facebookException.getMessage()));
                    FaceBookLogin.this.mTudcInnerFaceBookLoginListener.facebookLoginFail(-1, facebookException.getMessage().toString());
                }
            });
        }
        this.getLoginManager().logInWithReadPermissions(activity, this.permissions);
    }

    public void logout(Activity activity) {
        FaceBookLogin faceBookLogin = this;
        String string2 = faceBookLogin.context.getResources().getString(R.string.com_facebook_loginview_log_out_action);
        String string3 = faceBookLogin.context.getResources().getString(R.string.com_facebook_loginview_cancel_action);
        Object object = Profile.getCurrentProfile();
        object = object != null && object.getName() != null ? String.format(this.context.getResources().getString(R.string.com_facebook_loginview_logged_in_as), object.getName()) : this.context.getResources().getString(R.string.com_facebook_loginview_logged_in_using_facebook);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setMessage((CharSequence)object).setCancelable(true).setPositiveButton((CharSequence)string2, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                FaceBookLogin.this.getLoginManager().logOut();
            }
        }).setNegativeButton((CharSequence)string3, null);
        builder.create().show();
    }

    public void logOutBeforeLogin() {
        this.getLoginManager().logOut();
    }

    public void checkIfHasAccountLogined(Activity activity) {
        FaceBookLogin faceBookLogin = this;
        String string2 = faceBookLogin.context.getResources().getString(R.string.com_facebook_loginview_log_out_action);
        String string3 = faceBookLogin.context.getResources().getString(R.string.com_facebook_loginview_cancel_action);
        Object object = Profile.getCurrentProfile();
        String string4 = "\u5df2\u5b58\u5728FaceBook\u8d26\u53f7\u6388\u6743TUDC\uff0c\u91cd\u65b0\u767b\u5f55\u9700\u5148\u9000\u51fa\u8be5\u8d26\u53f7\u3002\n";
        if (object != null && object.getName() != null) {
            object = string4 + String.format(activity.getResources().getString(R.string.com_facebook_loginview_logged_in_as), object.getName());
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
            builder.setMessage((CharSequence)object).setCancelable(true).setPositiveButton((CharSequence)string2, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    FaceBookLogin.this.getLoginManager().logOut();
                }
            }).setNegativeButton((CharSequence)string3, null);
            builder.create().show();
        } else {
            this.getLoginManager().logInWithReadPermissions(activity, this.permissions);
        }
    }

    public void getLoginInfo(AccessToken accessToken) {
        GraphRequest graphRequest = GraphRequest.newMeRequest((AccessToken)accessToken, (GraphRequest.GraphJSONObjectCallback)new GraphRequest.GraphJSONObjectCallback(){

            public void onCompleted(JSONObject jSONObject, GraphResponse graphResponse) {
                if (jSONObject != null) {
                    JSONObject jSONObject2 = jSONObject;
                    jSONObject2.optString("id");
                    jSONObject2.optString("name");
                    jSONObject2.optString("gender");
                    jSONObject2.optString("email");
                    jSONObject2.optJSONObject("picture").optJSONObject("data").optString("url");
                    jSONObject2.optString("locale");
                    Toast.makeText((Context)FaceBookLogin.this.context, (CharSequence)("" + jSONObject.toString()), (int)0).show();
                }
            }
        });
        Bundle bundle = new Bundle();
        bundle.putString("fields", "id,name,link,gender,birthdate,email,picture,locale,updated_time,timezone,age_range,first_name,last_name");
        graphRequest.setParameters(bundle);
        graphRequest.executeAsync();
    }

    public CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    public void setFacebookListener(FacebookListener facebookListener) {
        this.facebookListener = facebookListener;
    }

    public static interface FacebookListener {
        public void facebookLoginSuccess();

        public void facebookLoginCancel();

        public void facebookLoginFail();
    }
}

