/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk.login.widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.afmobi.tudcsdk.R;

public class AfCircularProgressView
extends View {
    private static final Interpolator ANGLE_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator SWEEP_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private int angleAnimatorDuration;
    private int sweepAnimatorDuration;
    private int minSweepAngle;
    private float mBorderWidth;
    private final RectF fBounds = new RectF();
    private ObjectAnimator mObjectAnimatorSweep;
    private ObjectAnimator mObjectAnimatorAngle;
    private boolean mModeAppearing = true;
    private Paint mPaint;
    private float mCurrentGlobalAngleOffset;
    private float mCurrentGlobalAngle;
    private float mCurrentSweepAngle;
    private boolean mRunning;
    private int[] mColors;
    private int mCurrentColorIndex;
    private int mNextColorIndex;
    private Property<AfCircularProgressView, Float> mAngleProperty = new Property<AfCircularProgressView, Float>(Float.class, "angle"){

        public Float get(AfCircularProgressView afCircularProgressView) {
            return Float.valueOf(afCircularProgressView.getCurrentGlobalAngle());
        }

        public void set(AfCircularProgressView afCircularProgressView, Float f) {
            afCircularProgressView.setCurrentGlobalAngle(f.floatValue());
        }
    };
    private Property<AfCircularProgressView, Float> mSweepProperty = new Property<AfCircularProgressView, Float>(Float.class, "arc"){

        public Float get(AfCircularProgressView afCircularProgressView) {
            return Float.valueOf(afCircularProgressView.getCurrentSweepAngle());
        }

        public void set(AfCircularProgressView afCircularProgressView, Float f) {
            afCircularProgressView.setCurrentSweepAngle(f.floatValue());
        }
    };

    public AfCircularProgressView(Context context) {
        this(context, null, 0);
    }

    public AfCircularProgressView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public AfCircularProgressView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.TudcsdkCircularProgressView, n, 0);
        this.mBorderWidth = context.getDimension(R.styleable.TudcsdkCircularProgressView_TudcsdkBorderWidth, this.getResources().getDimension(R.dimen.circular_default_border_width));
        this.angleAnimatorDuration = context.getInt(R.styleable.TudcsdkCircularProgressView_TudcsdkAngleAnimationDurationMillis, this.getResources().getInteger(R.integer.circular_default_angleAnimationDurationMillis));
        this.sweepAnimatorDuration = context.getInt(R.styleable.TudcsdkCircularProgressView_TudcsdkSweepAnimationDurationMillis, this.getResources().getInteger(R.integer.circular_default_sweepAnimationDuration));
        this.minSweepAngle = context.getInt(R.styleable.TudcsdkCircularProgressView_TudcsdkMinSweepAngle, this.getResources().getInteger(R.integer.circular_default_miniSweepAngle));
        int n2 = context.getResourceId(R.styleable.TudcsdkCircularProgressView_TudcsdkColorSequence, R.array.circular_default_color_sequence);
        if (this.isInEditMode()) {
            AfCircularProgressView afCircularProgressView = this;
            afCircularProgressView.mColors = new int[4];
            afCircularProgressView.mColors[0] = this.getResources().getColor(R.color.color_0266c8);
            afCircularProgressView.mColors[1] = this.getResources().getColor(R.color.color_00933b);
            afCircularProgressView.mColors[2] = this.getResources().getColor(R.color.color_f90101);
            afCircularProgressView.mColors[3] = this.getResources().getColor(R.color.color_f2b50f);
        } else {
            this.mColors = this.getResources().getIntArray(n2);
        }
        AfCircularProgressView afCircularProgressView = this;
        context.recycle();
        afCircularProgressView.mCurrentColorIndex = 0;
        afCircularProgressView.mNextColorIndex = 1;
        afCircularProgressView.mPaint = new Paint();
        afCircularProgressView.mPaint.setAntiAlias(true);
        afCircularProgressView.mPaint.setStyle(Paint.Style.STROKE);
        afCircularProgressView.mPaint.setStrokeCap(Paint.Cap.ROUND);
        afCircularProgressView.mPaint.setStrokeWidth(this.mBorderWidth);
        afCircularProgressView.mPaint.setColor(this.mColors[this.mCurrentColorIndex]);
        afCircularProgressView.setupAnimations();
    }

    private void innerStart() {
        if (this.mRunning) {
            return;
        }
        AfCircularProgressView afCircularProgressView = this;
        afCircularProgressView.mRunning = true;
        afCircularProgressView.mObjectAnimatorAngle.start();
        afCircularProgressView.mObjectAnimatorSweep.start();
        afCircularProgressView.invalidate();
    }

    private void innerStop() {
        if (!this.mRunning) {
            return;
        }
        AfCircularProgressView afCircularProgressView = this;
        afCircularProgressView.mRunning = false;
        afCircularProgressView.mObjectAnimatorAngle.cancel();
        afCircularProgressView.mObjectAnimatorSweep.cancel();
        afCircularProgressView.invalidate();
    }

    private boolean isRunning() {
        return this.mRunning;
    }

    private static int gradient(int n, int n2, float f) {
        int n3 = n;
        n = (n3 & 0xFF0000) >> 16;
        int n4 = (n3 & 0xFF00) >> 8;
        int n5 = n2;
        n2 = (n5 & 0xFF0000) >> 16;
        int n6 = (n5 & 0xFF00) >> 8;
        float f2 = (float)n2 * f;
        float f3 = 1.0f - f;
        int n7 = (int)((float)n * f3 + f2);
        float f4 = (float)n6 * f;
        int n8 = (int)((float)n4 * f3 + f4);
        f = (float)(n5 & 0xFF) * f;
        int n9 = (int)((float)(n3 & 0xFF) * f3 + f);
        return Color.argb((int)255, (int)n7, (int)n8, (int)n9);
    }

    private void toggleAppearingMode() {
        AfCircularProgressView afCircularProgressView = this;
        afCircularProgressView.mModeAppearing ^= true;
        if (afCircularProgressView.mModeAppearing) {
            int n;
            AfCircularProgressView afCircularProgressView2 = this;
            int n2 = afCircularProgressView2.mCurrentColorIndex + 1;
            AfCircularProgressView afCircularProgressView3 = this;
            afCircularProgressView3.mCurrentColorIndex = n2;
            int[] nArray = afCircularProgressView3.mColors;
            afCircularProgressView2.mCurrentColorIndex = n2 % afCircularProgressView3.mColors.length;
            this.mNextColorIndex = n = afCircularProgressView2.mNextColorIndex + 1;
            afCircularProgressView2.mNextColorIndex = n % nArray.length;
            afCircularProgressView2.mCurrentGlobalAngleOffset = (afCircularProgressView2.mCurrentGlobalAngleOffset + (float)(this.minSweepAngle * 2)) % 360.0f;
        }
    }

    private void setupAnimations() {
        AfCircularProgressView afCircularProgressView = this;
        afCircularProgressView.mObjectAnimatorAngle = ObjectAnimator.ofFloat((Object)((Object)afCircularProgressView), afCircularProgressView.mAngleProperty, (float[])new float[]{360.0f});
        afCircularProgressView.mObjectAnimatorAngle.setInterpolator((TimeInterpolator)ANGLE_INTERPOLATOR);
        afCircularProgressView.mObjectAnimatorAngle.setDuration((long)this.angleAnimatorDuration);
        afCircularProgressView.mObjectAnimatorAngle.setRepeatMode(1);
        afCircularProgressView.mObjectAnimatorAngle.setRepeatCount(-1);
        afCircularProgressView.mObjectAnimatorSweep = ObjectAnimator.ofFloat((Object)((Object)afCircularProgressView), afCircularProgressView.mSweepProperty, (float[])new float[]{360.0f - (float)(this.minSweepAngle * 2)});
        afCircularProgressView.mObjectAnimatorSweep.setInterpolator((TimeInterpolator)SWEEP_INTERPOLATOR);
        afCircularProgressView.mObjectAnimatorSweep.setDuration((long)this.sweepAnimatorDuration);
        afCircularProgressView.mObjectAnimatorSweep.setRepeatMode(1);
        afCircularProgressView.mObjectAnimatorSweep.setRepeatCount(-1);
        afCircularProgressView.mObjectAnimatorSweep.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
                AfCircularProgressView.this.toggleAppearingMode();
            }
        });
    }

    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (n == 0) {
            this.innerStart();
        } else {
            this.innerStop();
        }
    }

    protected void onAttachedToWindow() {
        AfCircularProgressView afCircularProgressView = this;
        afCircularProgressView.innerStart();
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        AfCircularProgressView afCircularProgressView = this;
        afCircularProgressView.innerStop();
        super.onDetachedFromWindow();
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        AfCircularProgressView afCircularProgressView = this;
        super.onSizeChanged(n, n2, n3, n4);
        RectF rectF = afCircularProgressView.fBounds;
        float f = this.mBorderWidth;
        rectF.left = f / 2.0f + 0.5f;
        rectF.right = (float)n - f / 2.0f - 0.5f;
        rectF.top = f / 2.0f + 0.5f;
        afCircularProgressView.fBounds.bottom = (float)n2 - f / 2.0f - 0.5f;
    }

    public void draw(Canvas canvas) {
        AfCircularProgressView afCircularProgressView = this;
        super.draw(canvas);
        float f = afCircularProgressView.mCurrentGlobalAngle - this.mCurrentGlobalAngleOffset;
        float f2 = afCircularProgressView.mCurrentSweepAngle;
        if (afCircularProgressView.mModeAppearing) {
            AfCircularProgressView afCircularProgressView2 = this;
            int[] nArray = this.mColors;
            afCircularProgressView2.mPaint.setColor(AfCircularProgressView.gradient(this.mColors[this.mCurrentColorIndex], nArray[this.mNextColorIndex], f2 / (float)(360 - this.minSweepAngle * 2)));
            f2 += (float)afCircularProgressView2.minSweepAngle;
        } else {
            f += f2;
            f2 = 360.0f - f2 - (float)this.minSweepAngle;
        }
        canvas.drawArc(this.fBounds, f, f2, false, this.mPaint);
    }

    public void setCurrentGlobalAngle(float f) {
        this.mCurrentGlobalAngle = f;
        this.invalidate();
    }

    public float getCurrentGlobalAngle() {
        return this.mCurrentGlobalAngle;
    }

    public void setCurrentSweepAngle(float f) {
        this.mCurrentSweepAngle = f;
        this.invalidate();
    }

    public float getCurrentSweepAngle() {
        return this.mCurrentSweepAngle;
    }
}

