/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.tudcui.bean;

import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.log.LogUtils;
import com.transsion.json.Tson;
import com.transsion.tudcui.bean.Profile;
import net.grandcentrix.tray.AppPreferences;

public class Account {
    private static final String TAG_TOKEN = "TOKEN";
    private static final String TAG_OPENID = "OPENID";
    private static final String TAG_PROFILE = "PROFILE";
    private static final String TAG_ACCOUNT_TYPE = "ACCOUNT_TYPE";
    private static volatile Account instance;
    private String token = "";
    private long openId = 0L;
    private int accountType = -1;
    private AppPreferences appPreferences;

    private Account() {
    }

    public static synchronized Account getInstance() {
        if (instance == null) {
            instance = new Account();
        }
        return instance;
    }

    private String getProfileJson() {
        return this.getDefaultSharePreferences().getString(TAG_PROFILE, "");
    }

    private AppPreferences getDefaultSharePreferences() {
        if (this.appPreferences == null) {
            this.appPreferences = new AppPreferences(CoreUtil.getContext());
        }
        return this.appPreferences;
    }

    public void save(String string2, long l) {
        Account account = this;
        this.token = string2;
        account.openId = l;
        account.getDefaultSharePreferences().put(TAG_TOKEN, string2);
        account.getDefaultSharePreferences().put(TAG_OPENID, l);
    }

    public boolean isLogin() {
        if (this.isOSAccount()) {
            return true;
        }
        return this.getToken().length() > 0 && this.getOpenId() > 0L;
    }

    public boolean isLogin2() {
        if (this.getDefaultSharePreferences().getInt(TAG_ACCOUNT_TYPE, -1) == 4) {
            return true;
        }
        Account account = this;
        account.token = account.getDefaultSharePreferences().getString(TAG_TOKEN, "");
        account.openId = account.getDefaultSharePreferences().getLong(TAG_OPENID, 0L);
        return account.token.length() > 0 && this.openId > 0L;
    }

    public void setAccountType(int n) {
        this.accountType = n;
        this.getDefaultSharePreferences().put(TAG_ACCOUNT_TYPE, n);
    }

    public int getAccountType() {
        if (this.accountType == -1) {
            this.accountType = this.getDefaultSharePreferences().getInt(TAG_ACCOUNT_TYPE, -1);
        }
        return this.accountType;
    }

    public boolean isOSAccount() {
        return this.getAccountType() == 4;
    }

    public Profile getProfile() {
        String string2;
        Account account;
        block4: {
            Profile profile;
            Account account2 = account;
            account = profile;
            profile = new Profile();
            string2 = account2.getProfileJson();
            if (!TextUtils.isEmpty((CharSequence)string2)) break block4;
            return account;
        }
        try {
            account = (Profile)Tson.fromJson((String)string2, Profile.class);
        }
        catch (Exception exception) {
            LogUtils.d((Object)("TUDCInternal getProfile \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0cerror\uff1a" + exception.getMessage()));
        }
        return account;
    }

    public void logout() {
        Account account = this;
        LogUtils.i((Object)"TUDCInternal logout");
        account.isOSAccount();
        account.clear();
    }

    public void clear() {
        this.token = "";
        this.openId = 0L;
        this.accountType = -1;
        AppPreferences appPreferences = this.getDefaultSharePreferences();
        appPreferences.remove(TAG_TOKEN);
        appPreferences.remove(TAG_OPENID);
        appPreferences.remove(TAG_PROFILE);
        appPreferences.remove(TAG_ACCOUNT_TYPE);
    }

    public String getToken() {
        String string2 = this.token;
        if (string2 == null || string2.isEmpty()) {
            this.token = this.getDefaultSharePreferences().getString(TAG_TOKEN, "");
        }
        return this.token;
    }

    public long getOpenId() {
        if (this.openId == 0L) {
            this.openId = this.getDefaultSharePreferences().getLong(TAG_OPENID, 0L);
        }
        return this.openId;
    }

    public void saveProfile(Profile profile) {
        if (profile == null) {
            return;
        }
        Account account = string2;
        String string2 = Tson.toJson((Object)profile);
        account.getDefaultSharePreferences().put(TAG_PROFILE, string2);
    }
}

