/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptDialog;

public class InputDialog {
    private Context mContext;
    private PromptDialog.Builder mBuilder;
    private EditText mEditText;

    public InputDialog(Context context) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
    }

    public InputDialog setTitle(CharSequence title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public InputDialog setTitle(int title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public InputDialog setGetInputPositiveButton(CharSequence text, final OnPositiveButtonListener listener) {
        this.mBuilder.setPositiveButton(text, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onClick(InputDialog.this.mEditText.getText().toString());
                }
            }
        });
        return this;
    }

    public InputDialog setGetInputPositiveButton(int textId, OnPositiveButtonListener listener) {
        return this.setGetInputPositiveButton(this.mContext.getText(textId), listener);
    }

    public InputDialog setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setPositiveButton(text, listener);
        return this;
    }

    public InputDialog setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setPositiveButton(this.mContext.getText(textId), listener);
    }

    public InputDialog setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(text, listener);
        return this;
    }

    public InputDialog setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setNegativeButton(this.mContext.getText(textId), listener);
    }

    public InputDialog setInput(OnInputListener listener) {
        return this.setInput(null, null, listener);
    }

    public InputDialog setInput(CharSequence text, CharSequence textHint, OnInputListener listener) {
        View inputView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_input_dialog_layout, null);
        this.mEditText = (EditText)inputView.findViewById(R.id.input_edit_text);
        this.mEditText.setText(text);
        this.mEditText.setHint(textHint);
        if (listener != null) {
            listener.onInput(this.mEditText);
        }
        this.mBuilder.setView(inputView);
        return this;
    }

    public PromptDialog create() {
        PromptDialog dialog = this.mBuilder.create();
        dialog.getWindow().setSoftInputMode(16);
        return dialog;
    }

    public PromptDialog show() {
        PromptDialog dialog = this.create();
        dialog.show();
        return dialog;
    }

    public static interface OnPositiveButtonListener {
        public void onClick(String var1);
    }

    public static interface OnInputListener {
        public void onInput(EditText var1);
    }
}

