/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.CursorAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptParams;
import java.lang.ref.WeakReference;

public final class PromptController {
    private static final int LIST_ITEM_LAYOUT = R.layout.os_prompt_dialog_list_item;
    private static final int LIST_ITEM_SINGLE_CHOICE_LAYOUT = R.layout.os_prompt_dialog_list_singlechoice_item;
    private static final int LIST_ITEM_MULTI_CHOICE_LAYOUT = R.layout.os_prompt_dialog_list_multichoice_item;
    private static final int LIST_ITEM_ID = R.id.text_list_item;
    private final Context mContext;
    private final DialogInterface mDialogInterface;
    private final Window mWindow;
    private final LayoutInflater mInflater;
    private Handler mHandler;
    private LinearLayout mContainer;
    private LinearLayout mTitleView;
    private ScrollView mScrollMessageView;
    private FrameLayout mFrameContainer;
    private ListView mListView;
    public int mCheckedItem = -1;
    public boolean[] mCheckedItems;
    private boolean mIsButtonVertical = false;
    private boolean mIsAlert;
    private boolean mHasPositiveButton;
    private Button mButtonPositive;
    private CharSequence mButtonPositiveText;
    private Message mButtonPositiveMessage;
    private boolean mHasNegativeButton;
    private Button mButtonNegative;
    private CharSequence mButtonNegativeText;
    private Message mButtonNegativeMessage;
    private boolean mHasNeutralButton;
    private Button mButtonNeutral;
    private CharSequence mButtonNeutralText;
    private Message mButtonNeutralMessage;
    private final View.OnClickListener mButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            Object m = v == PromptController.this.mButtonPositive && PromptController.this.mButtonPositiveMessage != null ? Message.obtain((Message)PromptController.this.mButtonPositiveMessage) : (v == PromptController.this.mButtonNegative && PromptController.this.mButtonNegativeMessage != null ? Message.obtain((Message)PromptController.this.mButtonNegativeMessage) : (v == PromptController.this.mButtonNeutral && PromptController.this.mButtonNeutralMessage != null ? Message.obtain((Message)PromptController.this.mButtonNeutralMessage) : null));
            if (m != null) {
                m.sendToTarget();
            }
            PromptController.this.mHandler.obtainMessage(1, (Object)PromptController.this.mDialogInterface).sendToTarget();
        }
    };

    public PromptController(Context context, DialogInterface di, Window window) {
        this.mContext = context;
        this.mDialogInterface = di;
        this.mWindow = window;
        this.mHandler = new ButtonHandler(di);
        this.mInflater = LayoutInflater.from((Context)context);
        window.requestFeature(1);
        window.setGravity(80);
        this.mContainer = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_container, null);
    }

    public void installContent() {
        this.mWindow.setContentView((View)this.mContainer);
        this.setupView();
    }

    public void setTitleView(CharSequence title) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_title, (ViewGroup)this.mContainer, false);
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setText(title);
        }
    }

    public void setMessageView(CharSequence message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mScrollMessageView = (ScrollView)this.mInflater.inflate(R.layout.os_prompt_dialog_message, (ViewGroup)this.mContainer, false);
            TextView messageView = (TextView)this.mScrollMessageView.findViewById(R.id.text_message);
            this.addScrollChangeListener();
            messageView.setText(message);
        }
    }

    public void setView(int resId, View view) {
        if (resId != 0 || view != null) {
            this.mFrameContainer = (FrameLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_view, (ViewGroup)this.mContainer, false);
            if (resId != 0) {
                this.mFrameContainer.addView(this.mInflater.inflate(resId, (ViewGroup)this.mFrameContainer, false));
            } else {
                this.mFrameContainer.addView(view);
            }
        }
    }

    public void setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener, Message msg) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (msg == null && listener != null) {
            msg = this.mHandler.obtainMessage(whichButton, (Object)listener);
        }
        switch (whichButton) {
            case -1: {
                this.mButtonPositiveText = text;
                this.mButtonPositiveMessage = msg;
                this.mHasPositiveButton = true;
                break;
            }
            case -2: {
                this.mButtonNegativeText = text;
                this.mButtonNegativeMessage = msg;
                this.mHasNegativeButton = true;
                break;
            }
            case -3: {
                this.mButtonNeutralText = text;
                this.mButtonNeutralMessage = msg;
                this.mHasNeutralButton = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
        }
    }

    public void setList(CharSequence[] items, DialogInterface.OnClickListener listener) {
        ArrayAdapter adapter = new ArrayAdapter(this.mContext, LIST_ITEM_LAYOUT, LIST_ITEM_ID, (Object[])items);
        this.setList((ListAdapter)adapter, listener);
    }

    public void setList(ListAdapter adapter, final DialogInterface.OnClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null) {
                    listener.onClick(PromptController.this.mDialogInterface, position);
                    PromptController.this.mDialogInterface.dismiss();
                }
            }
        });
    }

    public void setList(Cursor cursor, String labelColumn, DialogInterface.OnClickListener listener) {
        SimpleCursorAdapter adapter = new SimpleCursorAdapter(this.mContext, LIST_ITEM_LAYOUT, cursor, new String[]{labelColumn}, new int[]{LIST_ITEM_ID}, 2);
        this.setList((ListAdapter)adapter, listener);
    }

    public void setSingleChoiceList(CharSequence[] items, DialogInterface.OnClickListener listener) {
        CheckedItemAdapter adapter = new CheckedItemAdapter(this.mContext, LIST_ITEM_SINGLE_CHOICE_LAYOUT, LIST_ITEM_ID, items);
        this.setSingleChoiceList((ListAdapter)adapter, listener);
    }

    public void setSingleChoiceList(ListAdapter adapter, final DialogInterface.OnClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null) {
                    listener.onClick(PromptController.this.mDialogInterface, position);
                }
            }
        });
        this.mListView.setChoiceMode(1);
    }

    public void setSingleChoiceList(Cursor cursor, String labelColumn, DialogInterface.OnClickListener listener) {
        SimpleCursorAdapter adapter = new SimpleCursorAdapter(this.mContext, LIST_ITEM_SINGLE_CHOICE_LAYOUT, cursor, new String[]{labelColumn}, new int[]{LIST_ITEM_ID}, 2);
        this.setSingleChoiceList((ListAdapter)adapter, listener);
    }

    public void setMultiChoiceList(CharSequence[] items, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
        this.dealCheckItems(items, checkedItems);
        ArrayAdapter<CharSequence> adapter = new ArrayAdapter<CharSequence>(this.mContext, LIST_ITEM_MULTI_CHOICE_LAYOUT, LIST_ITEM_ID, items){

            public View getView(int position, View convertView, ViewGroup parent) {
                boolean isItemChecked;
                View view = super.getView(position, convertView, parent);
                if (PromptController.this.mCheckedItems != null && PromptController.this.mListView != null && (isItemChecked = PromptController.this.mCheckedItems[position])) {
                    PromptController.this.mListView.setItemChecked(position, true);
                }
                return view;
            }
        };
        this.setMultiChoiceList((ListAdapter)adapter, listener);
    }

    private void dealCheckItems(CharSequence[] items, boolean[] checkedItems) {
        if (checkedItems == null) {
            return;
        }
        if (items.length == checkedItems.length) {
            this.mCheckedItems = checkedItems;
        } else {
            this.mCheckedItems = new boolean[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.mCheckedItems[i] = i < checkedItems.length && checkedItems[i];
            }
        }
    }

    public void setMultiChoiceList(Cursor cursor, final String labelColumn, final String isCheckedColumn, DialogInterface.OnMultiChoiceClickListener listener) {
        CursorAdapter adapter = new CursorAdapter(this.mContext, cursor, false){
            private final int mLabelIndex;
            private final int mIsCheckedIndex;
            {
                super(x0, x1, x2);
                Cursor cursor = this.getCursor();
                this.mLabelIndex = cursor.getColumnIndexOrThrow(labelColumn);
                this.mIsCheckedIndex = cursor.getColumnIndexOrThrow(isCheckedColumn);
            }

            public void bindView(View view, Context context, Cursor cursor) {
                CheckedTextView text = (CheckedTextView)view.findViewById(LIST_ITEM_ID);
                text.setText((CharSequence)cursor.getString(this.mLabelIndex));
                if (PromptController.this.mListView != null) {
                    PromptController.this.mListView.setItemChecked(cursor.getPosition(), cursor.getInt(this.mIsCheckedIndex) == 1);
                }
            }

            public View newView(Context context, Cursor cursor, ViewGroup parent) {
                return PromptController.this.mInflater.inflate(LIST_ITEM_MULTI_CHOICE_LAYOUT, parent, false);
            }
        };
        this.setMultiChoiceList((ListAdapter)adapter, listener);
    }

    private void setMultiChoiceList(ListAdapter adapter, final DialogInterface.OnMultiChoiceClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null && PromptController.this.mListView != null) {
                    if (PromptController.this.mCheckedItems != null) {
                        PromptController.this.mCheckedItems[position] = PromptController.this.mListView.isItemChecked(position);
                    }
                    listener.onClick(PromptController.this.mDialogInterface, position, PromptController.this.mListView.isItemChecked(position));
                }
            }
        });
        this.mListView.setChoiceMode(2);
    }

    private ListView generateListView(ListAdapter adapter, AdapterView.OnItemClickListener l) {
        ListView listView = (ListView)this.mInflater.inflate(R.layout.os_prompt_dialog_list, (ViewGroup)this.mContainer, false);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(l);
        listView.setDivider(null);
        return listView;
    }

    public void onPrepareListView(PromptParams.OnPrepareListViewListener listener) {
        if (this.mListView != null) {
            listener.onPrepareListView(this.mListView);
        }
    }

    public void setCheckedItem(int checkedItem) {
        this.mCheckedItem = checkedItem;
        if (this.mListView != null) {
            this.mListView.setItemChecked(checkedItem, true);
            this.mListView.setSelection(checkedItem);
        }
    }

    private void setupView() {
        boolean hasListView;
        this.mContainer.removeAllViews();
        boolean hasTitle = this.mTitleView != null;
        boolean hasMessage = this.mScrollMessageView != null;
        boolean hasCustomView = this.mFrameContainer != null;
        boolean bl = hasListView = this.mListView != null;
        if (hasTitle) {
            this.mContainer.addView((View)this.mTitleView);
        }
        if (hasMessage) {
            if (hasTitle) {
                // empty if block
            }
            this.mContainer.addView((View)this.mScrollMessageView);
        }
        if (hasListView && !hasMessage) {
            this.mContainer.addView((View)this.mListView);
            if (hasTitle) {
                // empty if block
            }
        }
        if (hasCustomView) {
            if (hasMessage) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mScrollMessageView.getLayoutParams();
                lp.height = -2;
                lp.weight = 0.0f;
                this.mScrollMessageView.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (hasListView) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mFrameContainer.getLayoutParams();
                lp.height = -2;
                lp.weight = 0.0f;
                this.mFrameContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
            this.mContainer.addView((View)this.mFrameContainer);
        }
        this.setupButtons(hasCustomView);
    }

    private void setupButtons(boolean hasCustomView) {
        if (!(this.mHasPositiveButton || this.mHasNegativeButton || this.mHasNeutralButton)) {
            return;
        }
        if (hasCustomView && PromptController.canTextInput((View)this.mFrameContainer)) {
            this.mWindow.setGravity(17);
            this.mWindow.setWindowAnimations(R.style.OsInputDialogAnimStyle);
            this.mIsButtonVertical = false;
        } else {
            this.mWindow.setFlags(131072, 131072);
        }
        View buttonsView = this.mInflater.inflate(this.mIsButtonVertical ? R.layout.os_prompt_dialog_buttons_vertical : R.layout.os_prompt_dialog_buttons_horizontal, (ViewGroup)this.mContainer, false);
        this.mButtonPositive = (Button)buttonsView.findViewById(R.id.btn_positive);
        if (this.mHasPositiveButton) {
            this.mButtonPositive.setText(this.mButtonPositiveText);
            this.mButtonPositive.setOnClickListener(this.mButtonListener);
            if (this.mIsAlert) {
                this.mButtonPositive.setTextColor(this.mContext.getColor(R.color.os_dialog_positive_btn_alert_color));
            }
        } else {
            this.mButtonPositive.setVisibility(8);
            if (!this.mIsButtonVertical) {
                // empty if block
            }
        }
        this.mButtonNegative = (Button)buttonsView.findViewById(R.id.btn_negative);
        if (this.mHasNegativeButton) {
            this.mButtonNegative.setText(this.mButtonNegativeText);
            this.mButtonNegative.setOnClickListener(this.mButtonListener);
        } else {
            this.mButtonNegative.setVisibility(8);
        }
        this.mButtonNeutral = (Button)buttonsView.findViewById(R.id.btn_neutral);
        if (this.mHasNeutralButton) {
            this.mButtonNeutral.setText(this.mButtonNeutralText);
            this.mButtonNeutral.setOnClickListener(this.mButtonListener);
        } else {
            this.mButtonNeutral.setVisibility(8);
            if (!this.mIsButtonVertical) {
                // empty if block
            }
        }
        this.mContainer.addView(buttonsView);
    }

    static boolean canTextInput(View v) {
        if (v.onCheckIsTextEditor()) {
            return true;
        }
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)v;
        int i = vg.getChildCount();
        while (i > 0) {
            if (!PromptController.canTextInput(v = vg.getChildAt(--i))) continue;
            return true;
        }
        return false;
    }

    public Button getButton(int whichButton) {
        switch (whichButton) {
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: {
                return this.mButtonNeutral;
            }
        }
        return null;
    }

    public ListView getListView() {
        return this.mListView;
    }

    public void setIsAlert(boolean isAlert) {
        this.mIsAlert = isAlert;
    }

    public void setTitle(CharSequence title) {
        if (this.mTitleView != null) {
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setText(title);
        } else {
            this.setTitleView(title);
        }
    }

    public void setMessage(CharSequence message) {
        if (this.mScrollMessageView != null) {
            TextView messageView = (TextView)this.mScrollMessageView.findViewById(R.id.text_message);
            this.addScrollChangeListener();
            messageView.setText(message);
        } else {
            this.setMessageView(message);
        }
    }

    private void addScrollChangeListener() {
        this.mScrollMessageView.setOnScrollChangeListener(new View.OnScrollChangeListener(){

            public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                if (scrollY > 0) {
                    if (PromptController.this.mScrollMessageView.getBackground() == null) {
                        PromptController.this.mScrollMessageView.setBackgroundResource(R.drawable.os_dialog_split_top_line);
                    }
                } else {
                    PromptController.this.mScrollMessageView.setBackground(null);
                }
            }
        });
    }

    private static class CheckedItemAdapter
    extends ArrayAdapter<CharSequence> {
        public CheckedItemAdapter(Context context, int resource, int textViewResourceId, CharSequence[] objects) {
            super(context, resource, textViewResourceId, (Object[])objects);
        }

        public boolean hasStableIds() {
            return true;
        }

        public long getItemId(int position) {
            return position;
        }
    }

    private static final class ButtonHandler
    extends Handler {
        private static final int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        ButtonHandler(DialogInterface dialog) {
            this.mDialog = new WeakReference<DialogInterface>(dialog);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case -3: 
                case -2: 
                case -1: {
                    ((DialogInterface.OnClickListener)msg.obj).onClick((DialogInterface)this.mDialog.get(), msg.what);
                    break;
                }
                case 1: {
                    ((DialogInterface)msg.obj).dismiss();
                }
            }
        }
    }
}

