/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.adapter.SelectDialogAdapter;
import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.widgetslib.entity.SelectDialogEntity;
import java.util.List;

public class SelectDialog {
    private Context mContext;
    private PromptDialog.Builder mBuilder;
    private PromptDialog mDialog;
    private CharSequence mBtnPositiveText;
    private boolean mIsCount = false;
    private boolean mIsAll = false;
    private SelectDialogAdapter mAdapter;

    public SelectDialog(Context context) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
    }

    public SelectDialog setTitle(CharSequence title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public SelectDialog setTitle(int title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public SelectDialog setMessage(CharSequence message) {
        this.mBuilder.setMessage(message);
        return this;
    }

    public SelectDialog setMessage(int message) {
        this.mBuilder.setMessage(message);
        return this;
    }

    public SelectDialog setSelectItems(List<SelectDialogEntity> list, boolean isAll, boolean isCount) {
        this.mIsCount = isCount;
        this.mIsAll = isAll;
        this.mBuilder.setView(this.setListView(list, isAll));
        return this;
    }

    private View setListView(List<SelectDialogEntity> list, boolean isAll) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_select_dialog_layout, null);
        ListView selectListView = (ListView)view.findViewById(R.id.select_dialog_list);
        this.mAdapter = new SelectDialogAdapter(this.mContext, list, isAll);
        selectListView.setAdapter((ListAdapter)this.mAdapter);
        selectListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SelectDialog.this.mAdapter.setCheckedItem(position);
                Button btnPositive = SelectDialog.this.mDialog.getButton(-1);
                if (SelectDialog.this.mIsCount && btnPositive.getVisibility() == 0) {
                    int count = SelectDialog.this.mAdapter.getCheckCount();
                    btnPositive.setText((CharSequence)(SelectDialog.this.mBtnPositiveText + "(" + count + ")"));
                }
            }
        });
        return view;
    }

    public SelectDialog setPositiveButton(CharSequence text, OnSelectButtonListener listener) {
        this.mBtnPositiveText = text;
        this.setPositiveButton(listener);
        return this;
    }

    public SelectDialog setPositiveButton(int textId, OnSelectButtonListener listener) {
        this.mBtnPositiveText = this.mContext.getText(textId);
        this.setPositiveButton(listener);
        return this;
    }

    private void setPositiveButton(final OnSelectButtonListener listener) {
        this.mBuilder.setPositiveButton(this.mBtnPositiveText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onClick(SelectDialog.this.mAdapter.getCheckedList());
                }
            }
        });
    }

    public SelectDialog setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(text, listener);
        return this;
    }

    public SelectDialog setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(textId, listener);
        return this;
    }

    public PromptDialog create(boolean isSystem) {
        this.mDialog = this.mBuilder.create();
        if (isSystem) {
            this.mDialog.getWindow().setType(2003);
        }
        if (this.mIsCount && this.mIsAll) {
            this.mDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(DialogInterface dialog) {
                    Button btnPositive = SelectDialog.this.mDialog.getButton(-1);
                    btnPositive.setText((CharSequence)(SelectDialog.this.mBtnPositiveText + "(" + SelectDialog.this.mAdapter.getCount() + ")"));
                }
            });
        }
        return this.mDialog;
    }

    public PromptDialog show(boolean isSystem) {
        this.create(isSystem);
        this.mDialog.show();
        this.mDialog.getWindow().setGravity(17);
        return this.mDialog;
    }

    public PromptDialog show() {
        return this.show(false);
    }

    public static interface OnSelectButtonListener {
        public void onClick(List<Boolean> var1);
    }
}

