/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.util;

import android.app.Activity;
import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.transsion.widgetslib.R;

public class SnackBarHelper {
    private Context mContext;
    private Snackbar mSnackBar;
    private ActionOnClickListener mOnClickListener;
    private Snackbar.SnackbarLayout mSnackBarLayout;
    private CoordinatorLayout mCoordinatorLayout;

    public SnackBarHelper(Context context, int activityLayoutId) {
        this.mContext = context;
        ViewGroup activityLayout = (ViewGroup)((Activity)context).findViewById(activityLayoutId);
        View snackBarView = ((Activity)context).getLayoutInflater().inflate(R.layout.os_snackbar_layout, null);
        this.mCoordinatorLayout = (CoordinatorLayout)snackBarView.findViewById(R.id.snackbar_coordinator);
        activityLayout.addView(snackBarView);
    }

    public Snackbar showCustomSnackbar(String message, String actionStr, int messageColor, int actionColor, int imageLayoutId, int duration) {
        this.mSnackBar = Snackbar.make((View)this.mCoordinatorLayout, (CharSequence)message, (int)duration);
        this.mSnackBarLayout = (Snackbar.SnackbarLayout)this.mSnackBar.getView();
        TextView actionText = (TextView)this.mSnackBarLayout.findViewById(R.id.snackbar_action);
        actionText.setBackgroundResource(R.drawable.os_btn_bg_no_stroke_dark);
        actionText.setAllCaps(true);
        if (messageColor != 0 && actionColor != 0) {
            this.setSnackBarColor(messageColor, (View)this.mSnackBarLayout, actionColor);
        }
        if (imageLayoutId != 0) {
            this.customSnackBarView(imageLayoutId);
        }
        this.mSnackBarLayout.setBackgroundResource(R.drawable.os_snackbar_background);
        this.mSnackBar.show();
        if (actionStr != null) {
            this.setUnDo(actionStr);
        }
        return this.mSnackBar;
    }

    public Snackbar showSnackBar(String message, int duration) {
        return this.showSnackBar(message, null, 0, duration);
    }

    public Snackbar showSnackBar(String message, String actionStr, int actionColor, int duration) {
        this.mSnackBar = Snackbar.make((View)this.mCoordinatorLayout, (CharSequence)message, (int)duration);
        this.mSnackBarLayout = (Snackbar.SnackbarLayout)this.mSnackBar.getView();
        TextView actionText = (TextView)this.mSnackBarLayout.findViewById(R.id.snackbar_action);
        TextView snackbar_text = (TextView)this.mSnackBarLayout.findViewById(R.id.snackbar_text);
        actionText.setBackgroundResource(R.drawable.os_btn_bg_no_stroke_dark);
        actionText.setAllCaps(true);
        actionText.setTextSize(14.0f);
        snackbar_text.setLineSpacing(0.0f, 1.3f);
        if (actionColor != 0) {
            actionText.setTextColor(actionColor);
        } else {
            actionText.setTextColor(this.mContext.getColor(R.color.os_btn_text_dark));
        }
        this.mSnackBarLayout.setBackgroundResource(R.drawable.os_snackbar_background);
        this.mSnackBar.show();
        if (actionStr != null) {
            this.setUnDo(actionStr);
        }
        return this.mSnackBar;
    }

    private void customSnackBarView(int layoutId) {
        View customView = LayoutInflater.from((Context)this.mContext).inflate(layoutId, null);
        LinearLayout.LayoutParams p = new LinearLayout.LayoutParams(-2, -2);
        p.gravity = 16;
        this.mSnackBarLayout.addView(customView, 0, (ViewGroup.LayoutParams)p);
    }

    private void setSnackBarColor(int color2, View view, int rightColor) {
        ((TextView)view.findViewById(R.id.snackbar_text)).setTextColor(color2);
        ((TextView)view.findViewById(R.id.snackbar_action)).setTextColor(rightColor);
    }

    private void setUnDo(String rightStr) {
        if (!TextUtils.isEmpty((CharSequence)rightStr)) {
            this.mSnackBar.setAction((CharSequence)rightStr, new View.OnClickListener(){

                public void onClick(View v) {
                    if (SnackBarHelper.this.mOnClickListener != null) {
                        SnackBarHelper.this.mOnClickListener.onClick();
                    }
                }
            });
        }
    }

    public void setActionOnClickListener(ActionOnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    public static interface ActionOnClickListener {
        public void onClick();
    }
}

