/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.transsion.widgetslib.R;
import java.util.ArrayList;
import java.util.Locale;

public class ViewPagerTabs
extends HorizontalScrollView {
    private static final int SCROLL_STATE_IDLE = 0;
    private static final int MIN_BALANCED_TAB_COUNT = 2;
    private static final int MAX_BALANCED_TAB_COUNT = 4;
    private static final float MIN_BALANCED_TAB_WIDTH_RATE = 0.35f;
    private static final String TAG = "ViewPagerTabs";
    private static final int MULTIPLE_DEFAULT_TAB_COLOR = -1;
    private static final int DEFAULT_UNREAD_INDICATOR_RADIUS = 3;
    private static final int DEFAULT_UNREAD_INDICATOR_COLOR = -65536;
    private HorizontalTabChild mTabChild;
    private Context mContext;
    private int mTitlePadding;
    private int mBalancedTitlePadding;
    private int mSelectTitleSize;
    private int mUnSelectTitleSize;
    private int mSelectTitleColor;
    private int mUnSelectTitleColor;
    private int mTabHeight;
    private int mMovingLineHeight;
    private boolean mIsRtl;
    private float mTextZoomOutScale;
    private ArrayList<Float> mZoomInTitlesWidth;
    private OnItemClickListener mItemClickListener;
    private int[] mCurLeftAndRight = new int[2];
    private int[] mNextLeftAndRight = new int[2];
    private int[] mSelectedTitleColors;
    private boolean mEnableMultipleSelectedTabColors;
    private boolean mIsTabBalanced;
    private int mItemsNumber = -1;
    private int[] mUnreadPosition = new int[0];
    private int mUnreadIndicatorRadius;
    private Paint mUnreadIndicatorPaint;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public ViewPagerTabs(Context context) {
        this(context, null);
    }

    public ViewPagerTabs(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init(attrs);
        this.mIsRtl = this.isRtl();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, this.mTabHeight);
        this.addView((View)this.mTabChild, (ViewGroup.LayoutParams)layoutParams);
        this.setFillViewport(true);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsRtl = this.isRtl();
        this.onPageScrollStateChanged(0);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mTabChild.mCurPosition = ss.mSavedCurPosition;
        this.onPageScrollStateChanged(0);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.mSavedCurPosition = this.mTabChild.mCurPosition;
        return ss;
    }

    private void init(AttributeSet attrs) {
        Resources resources = this.getResources();
        Resources.Theme theme = this.mContext.getTheme();
        this.mSelectTitleColor = resources.getColor(R.color.os_viewpager_tab_select_title_color, theme);
        this.mUnSelectTitleColor = resources.getColor(R.color.os_viewpager_tab_unselect_title_color, theme);
        this.mTitlePadding = resources.getDimensionPixelOffset(R.dimen.os_viewpager_tab_text_padding);
        this.mBalancedTitlePadding = resources.getDimensionPixelOffset(R.dimen.os_viewpager_average_tab_text_padding);
        this.mSelectTitleSize = resources.getDimensionPixelOffset(R.dimen.os_viewpager_tab_title_select_size);
        this.mUnSelectTitleSize = resources.getDimensionPixelOffset(R.dimen.os_viewpager_tab_title_unselect_size);
        this.mTabHeight = resources.getDimensionPixelOffset(R.dimen.os_viewpager_tab_height);
        this.mMovingLineHeight = resources.getDimensionPixelOffset(R.dimen.os_viewpager_tab_moving_line_height);
        TypedArray array = this.mContext.obtainStyledAttributes(attrs, R.styleable.ViewPagerTabs);
        this.mSelectTitleColor = array.getColor(R.styleable.ViewPagerTabs_osTabSelectTitleColor, this.mSelectTitleColor);
        this.mUnSelectTitleColor = array.getColor(R.styleable.ViewPagerTabs_osTabUnSelectTitleColor, this.mUnSelectTitleColor);
        this.mTabHeight = array.getDimensionPixelOffset(R.styleable.ViewPagerTabs_osTabHeight, this.mTabHeight);
        array.recycle();
        this.mTabChild = new HorizontalTabChild(this.mContext);
        float density = resources.getDisplayMetrics().density;
        this.mUnreadIndicatorRadius = (int)(3.0f * density);
        this.mUnreadIndicatorPaint = new Paint();
        this.mUnreadIndicatorPaint.setAntiAlias(true);
        this.mUnreadIndicatorPaint.setColor(-65536);
    }

    public int getDefaultViewPagerItemIndex() {
        return this.getRtlPosition(this.mTabChild.mCurPosition);
    }

    public void setItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public void setSelectTextColor(int color2) {
        this.mSelectTitleColor = color2;
        if (this.mTabChild != null) {
            this.mTabChild.mMovingLine.setColor(color2);
        }
    }

    public void setUnSelectTextColor(int color2) {
        this.mUnSelectTitleColor = color2;
    }

    public void setSelectedTabColors(int[] colors) {
        if (colors == null || colors.length == 0) {
            return;
        }
        int len = colors.length;
        if (this.mItemsNumber != -1 && len != this.mItemsNumber) {
            len = this.mItemsNumber;
        }
        if (this.mSelectedTitleColors == null) {
            this.mSelectedTitleColors = new int[len];
        }
        for (int i = 0; i < len; ++i) {
            this.mSelectedTitleColors[i] = i <= colors.length - 1 ? colors[i] : -1;
        }
        this.mEnableMultipleSelectedTabColors = true;
        this.mTabChild.mMovingLine.setColor(this.chooseSelectColor(this.mTabChild.mCurPosition));
        this.mTabChild.invalidate();
    }

    public void setTabHeight(int height) {
        if (this.mTabChild == null) {
            return;
        }
        this.mTabHeight = (int)TypedValue.applyDimension((int)1, (float)height, (DisplayMetrics)this.getResources().getDisplayMetrics());
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mTabChild.getLayoutParams();
        if (lp != null) {
            lp.height = this.mTabHeight;
            this.mTabChild.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, this.mTabHeight);
            this.mTabChild.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setTabs(CharSequence[] titles) {
        if (titles == null || titles.length == 0) {
            return;
        }
        this.mItemsNumber = titles.length;
        if (this.mSelectedTitleColors != null && this.mSelectedTitleColors.length != this.mItemsNumber) {
            int[] tmp = new int[this.mItemsNumber];
            for (int i = 0; i < this.mItemsNumber; ++i) {
                tmp[i] = i <= this.mSelectedTitleColors.length - 1 ? this.mSelectedTitleColors[i] : -1;
            }
            this.mSelectedTitleColors = tmp;
        }
        this.addTabs(titles);
        this.setHorizontalScrollBarEnabled(false);
    }

    public void setTabBalanced(boolean balanced) {
        this.mIsTabBalanced = balanced;
    }

    private void checkTabCount(int len) {
        if (len < 2 || len > 4) {
            this.mIsTabBalanced = false;
        }
    }

    private LinearLayout.LayoutParams chooseLayoutParams(int len) {
        if (len <= 0) {
            return null;
        }
        LinearLayout.LayoutParams layoutParams = null;
        if (len == 2 || !this.mIsTabBalanced) {
            layoutParams = new LinearLayout.LayoutParams(-2, -1);
        } else if (this.mIsTabBalanced) {
            layoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
        }
        return layoutParams;
    }

    private void breakTitleText(TextView textView, float maxTextWidth) {
        if (textView == null) {
            return;
        }
        String text = (String)textView.getText();
        if (text == null) {
            return;
        }
        TextPaint paint = textView.getPaint();
        if (paint.measureText(text) > maxTextWidth) {
            int subIndex = paint.breakText((CharSequence)text, 0, text.length(), true, maxTextWidth, null);
            try {
                if (subIndex > 0) {
                    textView.setText((CharSequence)(text.substring(0, subIndex - 1) + ".."));
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                Log.w((String)TAG, (String)("OS ViewPagerTabs # breakTitleText() Catch Exception e = " + e));
            }
        }
    }

    private void addTabs(CharSequence[] titles) {
        this.mTabChild.removeAllViews();
        int len = titles.length;
        boolean isMinTabCount = len == 2;
        this.checkTabCount(len);
        if (this.mZoomInTitlesWidth != null) {
            this.mZoomInTitlesWidth.clear();
        } else {
            this.mZoomInTitlesWidth = new ArrayList(len);
        }
        LinearLayout.LayoutParams layoutParams = this.chooseLayoutParams(len);
        if (layoutParams != null) {
            TextView textView = null;
            this.mTextZoomOutScale = 1.0f * (float)this.mUnSelectTitleSize / (float)this.mSelectTitleSize;
            for (int i = 0; i < len; ++i) {
                int maxTextWidth;
                textView = new TextView(this.mContext);
                if (null == titles[i]) {
                    titles[i] = "";
                }
                textView.setText((CharSequence)titles[i].toString().trim());
                textView.setTextSize(0, (float)this.mSelectTitleSize);
                textView.setTextColor(this.mUnSelectTitleColor);
                textView.setSingleLine(true);
                textView.setGravity(17);
                textView.setScaleX(this.mTextZoomOutScale);
                textView.setScaleY(this.mTextZoomOutScale);
                int n = maxTextWidth = isMinTabCount ? (int)((float)this.mTabChild.getMeasuredWidth() * 0.35f) : this.mTabChild.getMeasuredWidth() / len;
                if (this.mIsTabBalanced) {
                    this.breakTitleText(textView, maxTextWidth - this.mBalancedTitlePadding * 2);
                }
                float textWidth = this.measureText(textView);
                this.mZoomInTitlesWidth.add(Float.valueOf(textWidth));
                if (this.mIsTabBalanced) {
                    textView.setWidth(maxTextWidth);
                    textView.setPadding(this.mBalancedTitlePadding, 0, this.mBalancedTitlePadding, 0);
                } else {
                    textView.setWidth((int)((float)(this.mTitlePadding * 2) + textWidth));
                    textView.setPadding(this.mTitlePadding, 0, this.mTitlePadding, 0);
                }
                Typeface typeface = Typeface.create((String)"sans-serif-medium", (int)0);
                textView.setTypeface(typeface);
                final int finalI = i;
                textView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (ViewPagerTabs.this.mItemClickListener != null) {
                            ViewPagerTabs.this.mItemClickListener.OnItemClick(ViewPagerTabs.this.getRtlPosition(finalI));
                        }
                    }
                });
                if (i == this.mTabChild.mCurPosition) {
                    textView.setScaleX(1.0f);
                    textView.setScaleY(1.0f);
                    textView.setTextColor(this.chooseSelectColor(i));
                }
                if (isMinTabCount && this.mIsTabBalanced) {
                    layoutParams = new LinearLayout.LayoutParams(-2, -1);
                    if (i == 0) {
                        layoutParams.setMarginStart(this.mTabChild.getMeasuredWidth() / (len + 1) / 2);
                    }
                }
                this.mTabChild.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    private int chooseSelectColor(int index) {
        if (this.mEnableMultipleSelectedTabColors && this.mSelectedTitleColors[index] != -1) {
            return this.mSelectedTitleColors[index];
        }
        return this.mSelectTitleColor;
    }

    private float measureText(TextView textView) {
        float textWidth = textView.getPaint().measureText((String)textView.getText());
        return textWidth;
    }

    private int getRtlPosition(int position) {
        return this.mIsRtl ? this.mTabChild.getChildCount() - 1 - position : position;
    }

    private boolean isRtl() {
        Locale locale = Locale.getDefault();
        return TextUtils.getLayoutDirectionFromLocale((Locale)locale) == 1;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mZoomInTitlesWidth != null) {
            this.mZoomInTitlesWidth.clear();
            this.mZoomInTitlesWidth = null;
        }
        if (this.mTabChild != null) {
            this.mTabChild.removeAllViews();
            this.mTabChild = null;
        }
        if (this.mItemClickListener != null) {
            this.mItemClickListener = null;
        }
        if (this.mTabChild != null) {
            this.mTabChild.removeAllViews();
        }
        this.removeAllViews();
        this.mContext = null;
        this.mCurLeftAndRight = null;
        this.mNextLeftAndRight = null;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
        position = this.getRtlPosition(position);
        int tabCount = this.mTabChild.getChildCount();
        if (tabCount == 0 || position < 0 || position >= tabCount) {
            return;
        }
        this.mTabChild.onPageScrolled(position, positionOffset);
    }

    public void onPageSelected(int position) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(position);
        }
        position = this.getRtlPosition(position);
        int tabCount = this.mTabChild.getChildCount();
        if (tabCount == 0 || position < 0 || position >= tabCount) {
            return;
        }
        View curView = this.mTabChild.getChildAt(position);
        int scrollPos = curView.getLeft() - (this.getWidth() - curView.getWidth()) / 2;
        this.smoothScrollTo(scrollPos, 0);
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
        if (state == 0) {
            for (int i = 0; i < this.mTabChild.getChildCount(); ++i) {
                TextView tab;
                if (i != this.mTabChild.mCurPosition) {
                    tab = (TextView)this.mTabChild.getChildAt(i);
                    tab.setScaleY(this.mTextZoomOutScale);
                    tab.setScaleX(this.mTextZoomOutScale);
                    tab.setTextColor(this.mUnSelectTitleColor);
                    continue;
                }
                tab = (TextView)this.mTabChild.getChildAt(i);
                tab.setScaleY(1.0f);
                tab.setScaleX(1.0f);
                tab.setTextColor(this.chooseSelectColor(i));
            }
        }
    }

    public void setViewPager(final ViewPager viewPager) {
        this.mViewPager = viewPager;
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ViewPagerTabs.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                if (ViewPagerTabs.this.mViewPager != null) {
                    viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new InternalViewPagerListener());
                    ViewPagerTabs.this.setTabs();
                    viewPager.setCurrentItem(ViewPagerTabs.this.getDefaultViewPagerItemIndex(), false);
                }
            }
        });
    }

    public void setViewPager(final ViewPager viewPager, final int defaultIndex) {
        this.mViewPager = viewPager;
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ViewPagerTabs.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                if (ViewPagerTabs.this.mViewPager != null) {
                    viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new InternalViewPagerListener());
                    ViewPagerTabs.this.setTabs();
                    viewPager.setCurrentItem(ViewPagerTabs.this.getRtlPosition(defaultIndex), false);
                    ViewPagerTabs.this.mTabChild.mCurPosition = defaultIndex;
                    ViewPagerTabs.this.mTabChild.mMovingLine.setColor(ViewPagerTabs.this.chooseSelectColor(ViewPagerTabs.this.mTabChild.mCurPosition));
                    ViewPagerTabs.this.mTabChild.invalidate();
                    ViewPagerTabs.this.onPageScrollStateChanged(0);
                }
            }
        });
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public void setUnreadTip(int ... position) {
        if (position == null || position.length == 0) {
            return;
        }
        this.mUnreadPosition = position;
        if (this.mTabChild != null) {
            this.mTabChild.invalidate();
        }
    }

    private void setTabs() {
        this.mItemsNumber = this.mViewPager.getAdapter().getCount();
        if (this.mSelectedTitleColors != null && this.mSelectedTitleColors.length != this.mItemsNumber) {
            int[] tmp = new int[this.mItemsNumber];
            for (int i = 0; i < this.mItemsNumber; ++i) {
                tmp[i] = i <= this.mSelectedTitleColors.length - 1 ? this.mSelectedTitleColors[i] : -1;
            }
            this.mSelectedTitleColors = tmp;
        }
        this.addTabs();
        this.setHorizontalScrollBarEnabled(false);
    }

    private void addTabs() {
        this.mTabChild.removeAllViews();
        PagerAdapter adapter = this.mViewPager.getAdapter();
        int len = adapter.getCount();
        boolean isMinTabCount = len == 2;
        this.checkTabCount(len);
        if (this.mZoomInTitlesWidth != null) {
            this.mZoomInTitlesWidth.clear();
        } else {
            this.mZoomInTitlesWidth = new ArrayList(len);
        }
        LinearLayout.LayoutParams layoutParams = this.chooseLayoutParams(len);
        if (layoutParams != null) {
            TextView textView = null;
            this.mTextZoomOutScale = 1.0f * (float)this.mUnSelectTitleSize / (float)this.mSelectTitleSize;
            for (int i = 0; i < len; ++i) {
                int maxTextWidth;
                textView = new TextView(this.mContext);
                CharSequence title = adapter.getPageTitle(i);
                if (null == title) {
                    title = "";
                }
                textView.setText((CharSequence)title.toString().trim());
                textView.setTextSize(0, (float)this.mSelectTitleSize);
                textView.setTextColor(this.mUnSelectTitleColor);
                textView.setSingleLine(true);
                textView.setGravity(17);
                textView.setScaleX(this.mTextZoomOutScale);
                textView.setScaleY(this.mTextZoomOutScale);
                int n = maxTextWidth = isMinTabCount ? (int)((float)this.mTabChild.getMeasuredWidth() * 0.35f) : this.mTabChild.getMeasuredWidth() / len;
                if (this.mIsTabBalanced) {
                    this.breakTitleText(textView, maxTextWidth - this.mBalancedTitlePadding * 2);
                }
                float textWidth = this.measureText(textView);
                this.mZoomInTitlesWidth.add(Float.valueOf(textWidth));
                if (this.mIsTabBalanced) {
                    textView.setWidth(maxTextWidth);
                    textView.setPadding(this.mBalancedTitlePadding, 0, this.mBalancedTitlePadding, 0);
                } else {
                    textView.setWidth((int)((float)(this.mTitlePadding * 2) + textWidth));
                    textView.setPadding(this.mTitlePadding, 0, this.mTitlePadding, 0);
                }
                Typeface typeface = Typeface.create((String)"sans-serif-medium", (int)0);
                textView.setTypeface(typeface);
                final int finalI = i;
                textView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ViewPagerTabs.this.mViewPager.setCurrentItem(ViewPagerTabs.this.getRtlPosition(finalI));
                    }
                });
                if (i == this.mTabChild.mCurPosition) {
                    textView.setScaleX(1.0f);
                    textView.setScaleY(1.0f);
                    textView.setTextColor(this.chooseSelectColor(i));
                }
                if (isMinTabCount && this.mIsTabBalanced) {
                    layoutParams = new LinearLayout.LayoutParams(-2, -1);
                    if (i == 0) {
                        layoutParams.setMarginStart(this.mTabChild.getMeasuredWidth() / (len + 1) / 2);
                    }
                }
                this.mTabChild.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    private void onTabPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.onPageScrolled(position, positionOffset, positionOffsetPixels);
    }

    private void onTabPageSelected(int position) {
        this.onPageSelected(position);
    }

    private void onTabPageScrollStateChanged(int state) {
        this.onPageScrollStateChanged(state);
    }

    public void setTitleTabEnable(int position, boolean enabled) {
        if (this.mTabChild != null) {
            int count = this.mTabChild.getChildCount();
            if (position >= 0 && position < count) {
                this.mTabChild.getChildAt(position).setEnabled(enabled);
            }
        }
    }

    private class InternalViewPagerListener
    implements ViewPager.OnPageChangeListener {
        private InternalViewPagerListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            ViewPagerTabs.this.onTabPageScrolled(position, positionOffset, positionOffsetPixels);
        }

        public void onPageSelected(int position) {
            ViewPagerTabs.this.onTabPageSelected(position);
        }

        public void onPageScrollStateChanged(int state) {
            ViewPagerTabs.this.onTabPageScrollStateChanged(state);
        }
    }

    private class HorizontalTabChild
    extends LinearLayout {
        private int mCurPosition;
        private float mCurOffset;
        private LinearInterpolator mLinearInterpolator;
        private ArgbEvaluator mArgbEvaluator;
        private Paint mMovingLine;
        private boolean mFirstExec;

        public HorizontalTabChild(Context context) {
            super(context);
            this.mFirstExec = true;
            this.mMovingLine = new Paint(1);
            this.mMovingLine.setColor(ViewPagerTabs.this.mSelectTitleColor);
            this.mMovingLine.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
            this.mMovingLine.setStyle(Paint.Style.STROKE);
            this.mMovingLine.setStrokeWidth((float)ViewPagerTabs.this.mMovingLineHeight);
            this.mMovingLine.setStrokeCap(Paint.Cap.ROUND);
            this.mMovingLine.setDither(true);
            this.mLinearInterpolator = new LinearInterpolator();
            this.mArgbEvaluator = new ArgbEvaluator();
            this.setWillNotDraw(false);
        }

        void onPageScrolled(int position, float positionOffset) {
            this.mCurPosition = position;
            this.mCurOffset = positionOffset;
            this.invalidate();
        }

        private void calculateTextLeftAndRight(TextView textView, int textWidth, int[] arr) {
            if (textView == null || arr == null) {
                return;
            }
            if (arr.length != 2) {
                throw new IllegalArgumentException("Wrong arguments, array's length must be 2!");
            }
            int curHalfWeightWidth = textView.getWidth() - textView.getPaddingLeft() - textView.getPaddingRight() - textWidth;
            arr[0] = textView.getLeft() + textView.getPaddingLeft() + curHalfWeightWidth / 2;
            arr[1] = textView.getRight() - textView.getPaddingRight() - curHalfWeightWidth / 2;
        }

        protected void onDraw(Canvas canvas) {
            int childCount;
            super.onDraw(canvas);
            if (this.mFirstExec && ViewPagerTabs.this.mIsRtl) {
                ViewPagerTabs.this.fullScroll(66);
                this.mFirstExec = false;
            }
            if ((childCount = this.getChildCount()) > 0) {
                boolean hasNextTab;
                TextView curTextView = (TextView)this.getChildAt(this.mCurPosition);
                int unSelectedColor = ViewPagerTabs.this.chooseSelectColor(this.mCurPosition);
                this.calculateTextLeftAndRight(curTextView, (int)((Float)ViewPagerTabs.this.mZoomInTitlesWidth.get(this.mCurPosition)).floatValue(), ViewPagerTabs.this.mCurLeftAndRight);
                boolean bl = ViewPagerTabs.this.mIsRtl ? this.mCurPosition > 0 : (hasNextTab = this.mCurPosition < childCount - 1);
                if (this.mCurOffset > 0.0f && hasNextTab) {
                    float offset = this.mLinearInterpolator.getInterpolation(this.mCurOffset);
                    TextView nextTextView = (TextView)this.getChildAt(this.mCurPosition + (ViewPagerTabs.this.mIsRtl ? -1 : 1));
                    this.calculateTextLeftAndRight(nextTextView, (int)((Float)ViewPagerTabs.this.mZoomInTitlesWidth.get(this.mCurPosition + (ViewPagerTabs.this.mIsRtl ? -1 : 1))).floatValue(), ViewPagerTabs.this.mNextLeftAndRight);
                    ((ViewPagerTabs)ViewPagerTabs.this).mCurLeftAndRight[0] = (int)(offset * (float)ViewPagerTabs.this.mNextLeftAndRight[0] + (1.0f - offset) * (float)ViewPagerTabs.this.mCurLeftAndRight[0]);
                    ((ViewPagerTabs)ViewPagerTabs.this).mCurLeftAndRight[1] = (int)(offset * (float)ViewPagerTabs.this.mNextLeftAndRight[1] + (1.0f - offset) * (float)ViewPagerTabs.this.mCurLeftAndRight[1]);
                    float nextSize = offset * (float)ViewPagerTabs.this.mUnSelectTitleSize + 1.0f * (float)ViewPagerTabs.this.mSelectTitleSize * (1.0f - offset);
                    float curScale = nextSize / (1.0f * (float)ViewPagerTabs.this.mSelectTitleSize);
                    float nextScale = ((float)ViewPagerTabs.this.mSelectTitleSize - nextSize + (float)ViewPagerTabs.this.mUnSelectTitleSize) / (1.0f * (float)ViewPagerTabs.this.mSelectTitleSize);
                    curTextView.setScaleX(curScale);
                    curTextView.setScaleY(curScale);
                    nextTextView.setScaleX(nextScale);
                    nextTextView.setScaleY(nextScale);
                    unSelectedColor = (Integer)this.mArgbEvaluator.evaluate(offset, (Object)ViewPagerTabs.this.chooseSelectColor(this.mCurPosition), (Object)ViewPagerTabs.this.mUnSelectTitleColor);
                    int selected = (Integer)this.mArgbEvaluator.evaluate(offset, (Object)ViewPagerTabs.this.mUnSelectTitleColor, (Object)ViewPagerTabs.this.chooseSelectColor(this.mCurPosition + (ViewPagerTabs.this.mIsRtl ? -1 : 1)));
                    nextTextView.setTextColor(selected);
                    if (ViewPagerTabs.this.mEnableMultipleSelectedTabColors) {
                        this.mMovingLine.setColor(((Integer)this.mArgbEvaluator.evaluate(offset, (Object)ViewPagerTabs.this.chooseSelectColor(this.mCurPosition), (Object)ViewPagerTabs.this.chooseSelectColor(this.mCurPosition + (ViewPagerTabs.this.mIsRtl ? -1 : 1)))).intValue());
                    }
                }
                curTextView.setTextColor(unSelectedColor);
                int startYMovingLine = this.getBottom() - ViewPagerTabs.this.mMovingLineHeight / 2;
                canvas.drawLine((float)ViewPagerTabs.this.mCurLeftAndRight[0], (float)startYMovingLine, (float)ViewPagerTabs.this.mCurLeftAndRight[1], (float)startYMovingLine, this.mMovingLine);
            }
            for (int pos : ViewPagerTabs.this.mUnreadPosition) {
                if (pos < 0 || pos >= childCount) continue;
                TextView child = (TextView)this.getChildAt(pos);
                int left = child.getLeft();
                int right = child.getRight();
                float unRedPointTextWidth = child.getPaint().measureText(child.getText().toString());
                float redPointTextWidth = (float)ViewPagerTabs.this.mUnSelectTitleSize * unRedPointTextWidth / (float)ViewPagerTabs.this.mSelectTitleSize;
                float cx = (int)((double)((float)((left + right) / 2) + redPointTextWidth / 2.0f) + 1.5 * (double)ViewPagerTabs.this.mUnreadIndicatorRadius);
                float cy = this.getHeight() / 2 - ViewPagerTabs.this.mUnreadIndicatorRadius;
                canvas.drawCircle(cx, cy, (float)ViewPagerTabs.this.mUnreadIndicatorRadius, ViewPagerTabs.this.mUnreadIndicatorPaint);
            }
        }
    }

    public static interface OnItemClickListener {
        public void OnItemClick(int var1);
    }

    static class SavedState
    extends View.BaseSavedState {
        public int mSavedCurPosition;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.mSavedCurPosition = parcel.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mSavedCurPosition);
        }
    }
}

