/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v7.view.menu.MenuBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.transsion.widgetslib.R;
import java.util.ArrayList;
import java.util.List;

public class FootOperationBar
extends FrameLayout {
    private static final float ONE_BUTTON_WIDTH = 0.3f;
    private static final float TWO_BUTTON_WIDTH = 0.7f;
    private static final float THREE_BUTTON_WIDTH = 0.8f;
    private static final int ANIM_TIME = 120;
    private int mScreenWidth;
    private LinearLayout mContainer;
    private OnFootOptBarClickListener mItemClickListener;
    private List<String> mPopupItems;
    private ListPopupWindow mPopup;
    private View mMoreView;
    private boolean mShow = false;
    private boolean mAnim = false;
    private boolean mInitShow = false;
    private boolean[] mMenuEnables;

    public FootOperationBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        this.setBackgroundResource(R.drawable.os_foot_opt_bar_background);
        this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_min_height));
        LayoutInflater.from((Context)context).inflate(R.layout.os_foot_opt_bar_root, (ViewGroup)this);
        this.mContainer = (LinearLayout)this.findViewById(R.id.os_foot_opt_bar_container);
        this.mPopupItems = new ArrayList<String>();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FootOperationBar);
        if (ta.hasValue(R.styleable.FootOperationBar_foot_opt_menu)) {
            this.inflateMenu(ta.getResourceId(R.styleable.FootOperationBar_foot_opt_menu, 0));
        }
        this.mInitShow = ta.getBoolean(R.styleable.FootOperationBar_foot_init_show, false);
        ta.recycle();
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                FootOperationBar.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                FootOperationBar.this.offsetTopAndBottom(FootOperationBar.this.getMeasuredHeight());
                FootOperationBar.this.setVisibility(8);
                if (FootOperationBar.this.mInitShow) {
                    FootOperationBar.this.openFootOperationBar();
                }
                return true;
            }
        });
    }

    public void inflateMenu(int menuResId) {
        MenuInflater inflater = new MenuInflater(this.getContext());
        MenuBuilder menu = new MenuBuilder(this.getContext());
        inflater.inflate(menuResId, (Menu)menu);
        this.setMenu(menu);
    }

    private void setMenu(MenuBuilder menu) {
        this.mContainer.removeAllViews();
        this.mPopupItems.clear();
        this.mPopup = null;
        int count = menu.size();
        this.setContainerWidth(count);
        if (count <= 6) {
            this.addItemView(menu, count);
        } else {
            this.addItemView(menu, 4);
            this.mMoreView = this.addMenuItem(R.drawable.os_foot_bar_anim_selector_more, R.string.os_foot_opt_bar_more);
            this.mMoreView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FootOperationBar.this.mMoreView.setSelected(true);
                    FootOperationBar.this.mPopup.show();
                }
            });
            this.mContainer.addView(this.mMoreView);
            this.setPopupItems(menu, count);
        }
    }

    private void addItemView(MenuBuilder menu, int count) {
        int i = 0;
        while (i < count) {
            MenuItem item = menu.getItem(i);
            View itemView = this.addMenuItem(item.getIcon(), item.getTitle().toString());
            final int index = i++;
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FootOperationBar.this.mItemClickListener != null) {
                        FootOperationBar.this.mItemClickListener.onItemClick(index);
                    }
                }
            });
            this.mContainer.addView(itemView);
        }
    }

    private void setPopupItems(MenuBuilder menu, int count) {
        this.mMenuEnables = new boolean[count];
        for (int i = 4; i < count; ++i) {
            MenuItem item = menu.getItem(i);
            this.mPopupItems.add(item.getTitle().toString());
            this.mMenuEnables[i - 4] = true;
        }
        this.setFootPopupWindow();
    }

    private void setContainerWidth(int count) {
        int width;
        switch (count) {
            case 1: {
                width = (int)((float)this.mScreenWidth * 0.3f);
                break;
            }
            case 2: {
                width = (int)((float)this.mScreenWidth * 0.7f);
                break;
            }
            case 3: {
                width = (int)((float)this.mScreenWidth * 0.8f);
                break;
            }
            default: {
                width = -1;
            }
        }
        ViewGroup.LayoutParams lp = this.mContainer.getLayoutParams();
        lp.width = width;
        this.mContainer.setLayoutParams(lp);
    }

    private View addMenuItem(Drawable img, String title) {
        View itemRoot = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.os_foot_opt_bar_item, (ViewGroup)this.mContainer, false);
        ImageView icon = (ImageView)itemRoot.findViewById(R.id.os_foot_opt_bar_item_icon);
        TextView text = (TextView)itemRoot.findViewById(R.id.os_foot_opt_bar_item_text);
        if (img != null) {
            icon.setImageDrawable(img);
        }
        if (!TextUtils.isEmpty((CharSequence)title)) {
            text.setText((CharSequence)title);
        }
        return itemRoot;
    }

    private View addMenuItem(int imgId, int title) {
        View itemRoot = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.os_foot_opt_bar_item, (ViewGroup)this.mContainer, false);
        ImageView icon = (ImageView)itemRoot.findViewById(R.id.os_foot_opt_bar_item_icon);
        TextView text = (TextView)itemRoot.findViewById(R.id.os_foot_opt_bar_item_text);
        if (imgId != 0) {
            icon.setImageResource(imgId);
        }
        if (title != 0) {
            text.setText((CharSequence)this.getResources().getString(title));
        }
        return itemRoot;
    }

    public void changeFootItem(int position, int resId, String title) {
        View itemView = this.mContainer.getChildAt(position);
        ImageView icon = (ImageView)itemView.findViewById(R.id.os_foot_opt_bar_item_icon);
        TextView text = (TextView)itemView.findViewById(R.id.os_foot_opt_bar_item_text);
        icon.setImageResource(resId);
        text.setText((CharSequence)title);
    }

    public void changeFootItem(int position, int resId, int strId) {
        this.changeFootItem(position, resId, this.getResources().getString(strId));
    }

    public void changeItems(int[] resId, int[] titleId) {
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
        this.mContainer.removeAllViews();
        this.mPopupItems.clear();
        this.mPopup = null;
        int count = resId.length;
        this.setContainerWidth(count);
        if (count < 6) {
            this.addItemView(resId, titleId, count);
        } else {
            this.addItemView(resId, titleId, 4);
            this.mMoreView = this.addMenuItem(R.drawable.os_foot_bar_anim_selector_more, R.string.os_foot_opt_bar_more);
            this.mMoreView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FootOperationBar.this.mMoreView.setSelected(true);
                    FootOperationBar.this.mPopup.show();
                }
            });
            this.mContainer.addView(this.mMoreView);
            this.setPopupItems(titleId, count);
        }
    }

    private void addItemView(int[] resId, int[] titleId, int count) {
        int i = 0;
        while (i < count) {
            View itemView = this.addMenuItem(resId[i], titleId[i]);
            final int index = i++;
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FootOperationBar.this.mItemClickListener != null) {
                        FootOperationBar.this.mItemClickListener.onItemClick(index);
                    }
                }
            });
            this.mContainer.addView(itemView);
        }
    }

    private void setPopupItems(int[] titleId, int count) {
        this.mMenuEnables = new boolean[count - 4];
        for (int i = 4; i < count; ++i) {
            this.mPopupItems.add(this.getResources().getString(titleId[i]));
            this.mMenuEnables[i - 4] = true;
        }
        this.setFootPopupWindow();
    }

    public void changeItemsEnable(boolean[] enables) {
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
        int count = enables.length < this.getItemCount() ? enables.length : this.getItemCount();
        for (int i = 0; i < count; ++i) {
            this.changeItemEnable(i, enables[i]);
        }
    }

    public void changeItemEnable(int position, boolean enable) {
        if (this.mPopup == null) {
            this.viewEnable(this.mContainer.getChildAt(position), enable);
        } else if (position < 4) {
            this.viewEnable(this.mContainer.getChildAt(position), enable);
        } else {
            this.mMenuEnables[position - 4] = enable;
        }
    }

    public void enableMore(boolean enAble) {
        if (this.mMoreView != null) {
            this.viewEnable(this.mMoreView, enAble);
            if (!enAble && this.mPopup != null && this.mPopup.isShowing()) {
                this.mPopup.dismiss();
            }
        }
    }

    private void viewEnable(View view, boolean enAble) {
        view.setEnabled(enAble);
        view.setAlpha(enAble ? 1.0f : 0.3f);
    }

    private void setFootPopupWindow() {
        FootPopupAdapter adapter = new FootPopupAdapter();
        this.mPopup = new ListPopupWindow(this.getContext(), null, 0, R.style.OsFootOptPopupStyle);
        this.mPopup.setAdapter((ListAdapter)adapter);
        this.mPopup.setContentWidth(this.measureMaxWidth((ListAdapter)adapter, this.mScreenWidth / 2));
        this.mPopup.setAnchorView(this.mMoreView);
        this.mPopup.setModal(true);
        this.mPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                FootOperationBar.this.mMoreView.setSelected(false);
            }
        });
    }

    private int measureMaxWidth(ListAdapter adapter, int maxAllowedWidth) {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            itemView = adapter.getView(i, itemView, null);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            if (itemWidth >= maxAllowedWidth) {
                return maxAllowedWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    private void openAnimator() {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{this.getHeight(), 0.0f});
        oa.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        oa.setDuration(120L);
        oa.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                FootOperationBar.this.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                FootOperationBar.this.mAnim = false;
            }
        });
        oa.start();
    }

    private void closeAnimator() {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{0.0f, this.getHeight()});
        oa.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        oa.setDuration(120L);
        oa.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FootOperationBar.this.setVisibility(8);
                FootOperationBar.this.mAnim = false;
                if (FootOperationBar.this.mMoreView != null) {
                    FootOperationBar.this.mMoreView.setEnabled(true);
                }
            }
        });
        oa.start();
    }

    public void openFootOperationBar() {
        if (!this.mAnim && !this.mShow) {
            this.mAnim = true;
            this.mShow = true;
            this.openAnimator();
        }
    }

    public void closeFootOperationBar() {
        if (!this.mAnim && this.mShow) {
            if (this.mPopup != null && this.mPopup.isShowing()) {
                this.mPopup.dismiss();
            }
            if (this.mMoreView != null) {
                this.mMoreView.setEnabled(false);
            }
            this.mAnim = true;
            this.mShow = false;
            this.closeAnimator();
        }
    }

    public void toggleFootOperationBar() {
        if (this.mShow) {
            this.closeFootOperationBar();
        } else {
            this.openFootOperationBar();
        }
    }

    public void initShow(boolean initShow) {
        this.mInitShow = initShow;
    }

    public int getItemCount() {
        return this.mPopupItems.size() > 0 ? this.mContainer.getChildCount() + this.mPopupItems.size() - 1 : this.mContainer.getChildCount();
    }

    public void updateFootBarView() {
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        if (this.mContainer.getChildCount() < 4) {
            this.setContainerWidth(this.mContainer.getChildCount());
        }
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateFootBarView();
    }

    public void setOnFootOptBarClickListener(OnFootOptBarClickListener l) {
        this.mItemClickListener = l;
    }

    private class FootPopupAdapter
    extends BaseAdapter {
        private FootPopupAdapter() {
        }

        public int getCount() {
            return FootOperationBar.this.mPopupItems.size();
        }

        public Object getItem(int position) {
            return FootOperationBar.this.mPopupItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)FootOperationBar.this.getContext()).inflate(R.layout.os_foot_opt_bar_popup_item, parent, false);
                holder = new ViewHolder();
                holder.title = (TextView)convertView.findViewById(R.id.os_foot_opt_bar_popup_item_text);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.title.setText((CharSequence)FootOperationBar.this.mPopupItems.get(position));
            FootOperationBar.this.viewEnable(convertView, FootOperationBar.this.mMenuEnables[position]);
            final int index = position + 4;
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FootOperationBar.this.mItemClickListener != null) {
                        FootOperationBar.this.mItemClickListener.onItemClick(index);
                    }
                    FootOperationBar.this.mPopup.dismiss();
                }
            });
            return convertView;
        }

        private class ViewHolder {
            private TextView title;

            private ViewHolder() {
            }
        }
    }

    public static interface OnFootOptBarClickListener {
        public void onItemClick(int var1);
    }
}

