/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Filterable;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.transsion.widgetslib.R;
import java.util.List;

public class SearchBar
extends FrameLayout {
    private static final int ANIM_TIME = 360;
    private static final int LEFT_MARGIN = 16;
    private ImageView mBackView;
    private ImageView mSearchIcon;
    private TextView mClickView;
    private AutoCompleteTextView mSearchView;
    private int mWidth0;
    private int mWidth1;
    private int mMoveWidth;
    private OnItemClickListener mItemClickListener;
    private OnStateChangeListener mStateChangeListener;
    private ImageView mDeleteAll;
    private boolean mOnSearch;
    private TextWatcher textWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (count >= 0 && s.toString().trim().length() > 0) {
                SearchBar.this.mDeleteAll.setVisibility(0);
            } else {
                SearchBar.this.mDeleteAll.setVisibility(8);
            }
        }

        public void afterTextChanged(Editable editable) {
        }
    };

    public SearchBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.os_search_bar_layout, (ViewGroup)this);
        this.initView();
        this.initEvent();
        this.preDraw();
    }

    private void initView() {
        this.mClickView = (TextView)this.findViewById(R.id.text_click);
        this.mSearchView = (AutoCompleteTextView)this.findViewById(R.id.text_search);
        this.mBackView = (ImageView)this.findViewById(R.id.img_btn_back);
        this.mSearchIcon = (ImageView)this.findViewById(R.id.img_search_icon);
        this.mSearchIcon.setAlpha(0.5f);
        this.mDeleteAll = (ImageView)this.findViewById(R.id.img_delete_all);
    }

    private void initEvent() {
        this.mClickView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchBar.this.startSearch();
            }
        });
        this.mBackView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchBar.this.endSearch();
            }
        });
        this.mSearchView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!SearchBar.this.mSearchView.isPopupShowing() && SearchBar.this.mSearchView.getText().length() != 0) {
                    SearchBar.this.mSearchView.showDropDown();
                }
            }
        });
        this.mSearchView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (SearchBar.this.mItemClickListener != null) {
                    SearchBar.this.mItemClickListener.onItemClick(parent, view, position, id2);
                }
            }
        });
        this.mDeleteAll.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isEmpty = TextUtils.isEmpty((CharSequence)SearchBar.this.mSearchView.getText());
                if (!isEmpty || SearchBar.this.mSearchView.length() > 0) {
                    SearchBar.this.mSearchView.setText(null);
                }
            }
        });
        this.mSearchView.addTextChangedListener(this.textWatcher);
    }

    private void preDraw() {
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                SearchBar.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                SearchBar.this.mBackView.offsetLeftAndRight(-SearchBar.this.mBackView.getMeasuredWidth());
                SearchBar.this.mBackView.setVisibility(8);
                SearchBar.this.mWidth0 = SearchBar.this.mClickView.getMeasuredWidth();
                int leftMargin = SearchBar.this.applyDp(16);
                SearchBar.this.mMoveWidth = SearchBar.this.mBackView.getMeasuredWidth() - leftMargin;
                SearchBar.this.mWidth1 = SearchBar.this.mWidth0 - SearchBar.this.mMoveWidth;
                return true;
            }
        });
    }

    private void backEnterAnim() {
        boolean isRTL = this.getLayoutDirection() == 1;
        int backMove = isRTL ? this.mBackView.getWidth() : -this.mBackView.getWidth();
        ObjectAnimator backAnimator = ObjectAnimator.ofFloat((Object)this.mBackView, (String)"translationX", (float[])new float[]{backMove, 0.0f});
        WidthWrapper wrapper = new WidthWrapper((View)this.mSearchView);
        ObjectAnimator wrapperAnimator = ObjectAnimator.ofInt((Object)wrapper, (String)"width", (int[])new int[]{this.mWidth0, this.mWidth1});
        int moveWidth = isRTL ? -this.mMoveWidth : this.mMoveWidth;
        ObjectAnimator textMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchView, (String)"translationX", (float[])new float[]{0.0f, moveWidth});
        ObjectAnimator iconMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchIcon, (String)"translationX", (float[])new float[]{0.0f, moveWidth});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(360L);
        set.playTogether(new Animator[]{backAnimator, wrapperAnimator, textMoveAnimator, iconMoveAnimator});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                SearchBar.this.mBackView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                SearchBar.this.mSearchView.requestFocus();
                InputMethodManager imm = (InputMethodManager)SearchBar.this.getContext().getSystemService(InputMethodManager.class);
                if (imm != null) {
                    imm.showSoftInput((View)SearchBar.this.mSearchView, 0);
                }
                if (!TextUtils.isEmpty((CharSequence)SearchBar.this.mSearchView.getText()) || SearchBar.this.mSearchView.getText().length() > 0) {
                    SearchBar.this.mDeleteAll.setVisibility(0);
                } else {
                    SearchBar.this.mDeleteAll.setVisibility(8);
                }
                SearchBar.this.mBackView.setClickable(true);
            }
        });
        set.start();
    }

    private void backExitAnim() {
        boolean isRTL = this.getLayoutDirection() == 1;
        int backMove = isRTL ? this.mBackView.getWidth() : -this.mBackView.getWidth();
        ObjectAnimator backAnimator = ObjectAnimator.ofFloat((Object)this.mBackView, (String)"translationX", (float[])new float[]{0.0f, backMove});
        WidthWrapper wrapper = new WidthWrapper((View)this.mSearchView);
        ObjectAnimator wrapperAnimator = ObjectAnimator.ofInt((Object)wrapper, (String)"width", (int[])new int[]{this.mWidth1, this.mWidth0});
        int moveWidth = isRTL ? -this.mMoveWidth : this.mMoveWidth;
        ObjectAnimator textMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchView, (String)"translationX", (float[])new float[]{moveWidth, 0.0f});
        ObjectAnimator iconMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchIcon, (String)"translationX", (float[])new float[]{moveWidth, 0.0f});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(360L);
        set.playTogether(new Animator[]{backAnimator, wrapperAnimator, textMoveAnimator, iconMoveAnimator});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                InputMethodManager imm = (InputMethodManager)SearchBar.this.getContext().getSystemService(InputMethodManager.class);
                if (imm != null) {
                    imm.hideSoftInputFromWindow(SearchBar.this.getWindowToken(), 0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                SearchBar.this.mBackView.setBackgroundResource(R.drawable.os_control_background_48dp);
                SearchBar.this.mBackView.setVisibility(8);
                SearchBar.this.mSearchView.setVisibility(8);
                SearchBar.this.mClickView.setVisibility(0);
            }
        });
        set.start();
    }

    public void startSearch() {
        this.mOnSearch = true;
        this.mClickView.setVisibility(8);
        this.mSearchView.setVisibility(0);
        this.mSearchIcon.setAlpha(1.0f);
        this.backEnterAnim();
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onSearchStart();
        }
    }

    public void endSearch() {
        this.mOnSearch = false;
        this.mDeleteAll.setVisibility(8);
        this.mSearchView.setText(null);
        this.mBackView.setBackground(null);
        this.mBackView.setClickable(false);
        this.mSearchIcon.setAlpha(0.5f);
        this.backExitAnim();
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onSearchEnd();
        }
    }

    public boolean isOnSearch() {
        return this.mOnSearch;
    }

    public void setHint(CharSequence hint) {
        this.mClickView.setText(hint);
        this.mSearchView.setHint(hint);
    }

    public void setHint(int hintId) {
        this.setHint(this.getResources().getString(hintId));
    }

    public void setSearchSource(Context context, List<String> source) {
        ArrayAdapter adapter = new ArrayAdapter(context, R.layout.os_search_source_item_layout, R.id.search_item_text, source);
        this.mSearchView.setAdapter((ListAdapter)adapter);
    }

    public <T extends ListAdapter & Filterable> void setAdapter(T adapter) {
        this.mSearchView.setAdapter(adapter);
    }

    private int applyDp(int valueDp) {
        return (int)TypedValue.applyDimension((int)1, (float)valueDp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setOnStateChangeListener(OnStateChangeListener l) {
        this.mStateChangeListener = l;
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    public static interface OnItemClickListener {
        public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static interface OnStateChangeListener {
        public void onSearchStart();

        public void onSearchEnd();
    }

    private class WidthWrapper {
        private View view;

        public WidthWrapper(View view) {
            this.view = view;
        }

        public int getWidth() {
            return this.view.getLayoutParams().width;
        }

        public void setWidth(int width) {
            this.view.getLayoutParams().width = width;
            this.view.requestLayout();
        }
    }
}

