/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.shadow;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.widget.shadow.BackOutInterpolator;
import com.transsion.widgetslib.widget.shadow.FloatingOvalButton;
import java.util.ArrayList;

public class ExpandActionButton
extends FrameLayout {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private static final int COLLAPSE_SIZE = 88;
    private static final int EXPAND_SIZE = 265;
    private static final int PADDING = 7;
    private boolean mIsExpand;
    private final int mCollapseSize;
    private final int mExpandSize;
    private FloatingOvalButton mMainBtn;
    private FloatingOvalButton[] mItemBtns = new FloatingOvalButton[3];
    private int mOrientation;
    private boolean mExpandable = true;
    private int mCount;
    private boolean mIsAnim;
    private OnMainButtonClickListener mMainClickListener;
    private OnItemButtonClickListener mItemClickListener;

    public ExpandActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.os_expand_action_btn_layout, (ViewGroup)this);
        this.mMainBtn = (FloatingOvalButton)this.findViewById(R.id.float_main);
        this.mItemBtns[0] = (FloatingOvalButton)this.findViewById(R.id.float_item0);
        this.mItemBtns[1] = (FloatingOvalButton)this.findViewById(R.id.float_item1);
        this.mItemBtns[2] = (FloatingOvalButton)this.findViewById(R.id.float_item2);
        int padding = this.applyDp(7.0f);
        this.setPadding(padding, padding, padding, padding);
        this.mCollapseSize = this.applyDp(88.0f);
        this.mExpandSize = this.applyDp(265.0f);
        Configuration config = context.getResources().getConfiguration();
        if (config.orientation == 2) {
            this.mOrientation = 1;
        } else if (config.orientation == 1) {
            this.mOrientation = 0;
        }
    }

    public void setMainButtonIconAndColor(int resId, int color2) {
        this.mMainBtn.setImageResource(resId);
        this.mMainBtn.setImageBackgroundShadowColor(color2);
        this.mMainBtn.setClickable(true);
        this.mMainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ExpandActionButton.this.mExpandable) {
                    if (!ExpandActionButton.this.mIsExpand) {
                        ExpandActionButton.this.expandItemButtons();
                    } else {
                        ExpandActionButton.this.collapseItemButtons();
                    }
                } else if (ExpandActionButton.this.mMainClickListener != null) {
                    ExpandActionButton.this.mMainClickListener.onMainClick(v);
                }
            }
        });
        this.setExpandable(true);
    }

    private void startExpandAnim() {
        ArrayList<ObjectAnimator> animList = new ArrayList<ObjectAnimator>();
        String name = this.mOrientation == 0 ? "translationY" : "translationX";
        boolean isRtl = this.getLayoutDirection() == 1;
        for (int i = 0; i < this.mCount; ++i) {
            int move = this.applyDp(64.0f) + i * this.applyDp(56.0f);
            move = isRtl && this.mOrientation == 1 ? move : -move;
            ObjectAnimator moveAnim = ObjectAnimator.ofFloat((Object)((Object)this.mItemBtns[i]), (String)name, (float[])new float[]{0.0f, move});
            ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)((Object)this.mItemBtns[i]), (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            animList.add(moveAnim);
            animList.add(alphaAnim);
        }
        ObjectAnimator rotateAnim = ObjectAnimator.ofFloat((Object)this.mMainBtn.getImage(), (String)"rotation", (float[])new float[]{0.0f, isRtl ? -135.0f : 135.0f});
        animList.add(rotateAnim);
        AnimatorSet set = new AnimatorSet();
        set.setDuration(360L);
        set.setInterpolator((TimeInterpolator)new BackOutInterpolator());
        set.playTogether(animList);
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                ExpandActionButton.this.setItemsVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                ExpandActionButton.this.mIsAnim = false;
                ExpandActionButton.this.mIsExpand = true;
                if (!ExpandActionButton.this.mExpandable) {
                    ExpandActionButton.this.collapseItemButtons();
                }
            }
        });
        set.start();
    }

    private void startCollapseAnim() {
        ArrayList<ObjectAnimator> animList = new ArrayList<ObjectAnimator>();
        String name = this.mOrientation == 0 ? "translationY" : "translationX";
        boolean isRtl = this.getLayoutDirection() == 1;
        for (int i = 0; i < this.mCount; ++i) {
            int move = this.applyDp(64.0f) + i * this.applyDp(56.0f);
            move = isRtl && this.mOrientation == 1 ? move : -move;
            ObjectAnimator moveAnim = ObjectAnimator.ofFloat((Object)((Object)this.mItemBtns[i]), (String)name, (float[])new float[]{move, 0.0f});
            moveAnim.setDuration(238L);
            ObjectAnimator alphaAnim = ObjectAnimator.ofFloat((Object)((Object)this.mItemBtns[i]), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            alphaAnim.setDuration(238L);
            animList.add(moveAnim);
            animList.add(alphaAnim);
        }
        ObjectAnimator rotateAnim = ObjectAnimator.ofFloat((Object)this.mMainBtn.getImage(), (String)"rotation", (float[])new float[]{isRtl ? -135.0f : 135.0f, 0.0f});
        rotateAnim.setInterpolator((TimeInterpolator)new BackOutInterpolator());
        rotateAnim.setDuration(360L);
        animList.add(rotateAnim);
        AnimatorSet set = new AnimatorSet();
        set.playTogether(animList);
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ExpandActionButton.this.setItemsVisibility(8);
                ExpandActionButton.this.mIsAnim = false;
                ExpandActionButton.this.mIsExpand = false;
                if (!ExpandActionButton.this.mExpandable) {
                    ExpandActionButton.this.setCollapseSize();
                }
            }
        });
        set.start();
    }

    private void setCollapseSize() {
        this.getLayoutParams().width = this.mCollapseSize;
        this.getLayoutParams().height = this.mCollapseSize;
        this.requestLayout();
    }

    private void setExpandSize() {
        if (this.mOrientation == 0) {
            this.getLayoutParams().height = this.mExpandSize;
            this.getLayoutParams().width = this.mCollapseSize;
            this.requestLayout();
        } else if (this.mOrientation == 1) {
            this.getLayoutParams().width = this.mExpandSize;
            this.getLayoutParams().height = this.mCollapseSize;
            this.requestLayout();
        }
    }

    public void setItemsIconAndColor(int[] icons, int[] colors) {
        if (icons.length != colors.length) {
            return;
        }
        this.mCount = icons.length > 3 ? 3 : icons.length;
        for (int i = 0; i < this.mCount; ++i) {
            this.setItemButton(icons[i], colors[i], i);
        }
    }

    private void setItemButton(int resId, int color2, int position) {
        final int pos = position;
        FloatingOvalButton itemBtn = this.mItemBtns[pos];
        itemBtn.setImageResource(resId);
        itemBtn.setImageBackgroundShadowColor(color2);
        itemBtn.setClickable(true);
        itemBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ExpandActionButton.this.mItemClickListener != null) {
                    ExpandActionButton.this.mItemClickListener.onItemClick(pos);
                }
            }
        });
    }

    public void setExpandOrientation(int orientation) {
        this.mOrientation = orientation;
        this.setExpandSize();
    }

    public void setExpandable(boolean expandable) {
        this.mExpandable = expandable;
        if (this.mExpandable) {
            this.setExpandSize();
        } else if (this.mIsExpand) {
            this.collapseItemButtons();
        } else if (!this.mIsAnim) {
            this.setCollapseSize();
        }
    }

    public boolean isExpanded() {
        return this.mIsExpand;
    }

    public void expandItemButtons() {
        if (this.mIsAnim) {
            return;
        }
        this.mIsAnim = true;
        this.startExpandAnim();
    }

    public void collapseItemButtons() {
        if (this.mIsAnim) {
            return;
        }
        this.mIsAnim = true;
        this.startCollapseAnim();
    }

    public void collapseItemButtonsNoAnim() {
        if (!this.mIsExpand) {
            return;
        }
        for (int i = 0; i < this.mCount; ++i) {
            if (this.mOrientation == 0) {
                this.mItemBtns[i].setTranslationY(0.0f);
                continue;
            }
            this.mItemBtns[i].setTranslationX(0.0f);
        }
        this.mMainBtn.getImage().setRotation(0.0f);
        this.setItemsVisibility(8);
        this.mIsExpand = false;
        if (!this.mExpandable) {
            this.setCollapseSize();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mExpandable) {
            for (int i = 0; i < this.mCount; ++i) {
                int diff = (this.mMainBtn.getWidth() - this.mItemBtns[i].getWidth()) / 2;
                int l = this.mMainBtn.getLeft() + diff;
                int t = this.mMainBtn.getTop() + diff;
                this.mItemBtns[i].layout(l, t, l + this.mItemBtns[i].getWidth(), bottom + this.mItemBtns[i].getHeight());
            }
        } else {
            this.setItemsVisibility(8);
        }
    }

    private void setItemsVisibility(int visibility) {
        for (int i = 0; i < this.mCount; ++i) {
            this.mItemBtns[i].setVisibility(visibility);
        }
    }

    private int applyDp(float valueDp) {
        return (int)TypedValue.applyDimension((int)1, (float)valueDp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        this.collapseItemButtonsNoAnim();
        if (newConfig.orientation == 2) {
            this.setExpandOrientation(1);
        } else if (newConfig.orientation == 1) {
            this.setExpandOrientation(0);
        }
    }

    public void setOnMainButtonClickListener(OnMainButtonClickListener l) {
        this.mMainClickListener = l;
    }

    public void setOnItemButtonClickListener(OnItemButtonClickListener l) {
        this.mItemClickListener = l;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superSaveState = super.onSaveInstanceState();
        SaveState ss = new SaveState(superSaveState);
        ss.expandable = this.mExpandable;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SaveState ss = (SaveState)state;
        super.onRestoreInstanceState((Parcelable)ss);
        this.mExpandable = ss.expandable;
        this.setExpandable(this.mExpandable);
    }

    static class SaveState
    extends View.BaseSavedState {
        boolean expandable;
        public static final Parcelable.Creator<SaveState> CREATOR = new Parcelable.Creator<SaveState>(){

            public SaveState createFromParcel(Parcel source) {
                return new SaveState(source);
            }

            public SaveState[] newArray(int size) {
                return new SaveState[size];
            }
        };

        private SaveState(Parcel source) {
            super(source);
            this.expandable = source.readByte() == 0;
        }

        SaveState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(!this.expandable ? 1 : 0));
        }
    }

    public static interface OnItemButtonClickListener {
        public void onItemClick(int var1);
    }

    public static interface OnMainButtonClickListener {
        public void onMainClick(View var1);
    }
}

