/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.shadow;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.widget.shadow.ShadowLayout;

public class FloatingOvalButton
extends FrameLayout {
    private static final float IMAGE_SRC_SIZE = 24.0f;
    private static final float IMAGE_BACKGROUND_SIZE = 40.0f;
    private ShadowLayout mShadowLayout;
    private ImageView mImgView;

    public FloatingOvalButton(Context context) {
        this(context, null);
    }

    public FloatingOvalButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mShadowLayout = new ShadowLayout(context, attrs);
        this.mImgView = new ImageView(context, attrs);
        this.mShadowLayout.addView((View)this.mImgView);
        this.addView((View)this.mShadowLayout);
        float imageBackgroundSize = this.applyDp(40.0f);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FloatingOvalButton);
        float imageWidth = ta.getDimension(R.styleable.FloatingOvalButton_float_image_width, imageBackgroundSize);
        float imageHeight = ta.getDimension(R.styleable.FloatingOvalButton_float_image_height, imageBackgroundSize);
        Drawable imageDrawable = ta.getDrawable(R.styleable.FloatingOvalButton_float_image_src);
        int backgroundShadowColor = ta.getColor(R.styleable.FloatingOvalButton_float_image_background_shadow_color, 0);
        int backgroundColor = ta.getColor(R.styleable.FloatingOvalButton_float_image_background_color, -1);
        int shadowColor = ta.getColor(R.styleable.FloatingOvalButton_float_image_shadow_color, -2138535800);
        ta.recycle();
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mImgView.getLayoutParams();
        lp.width = (int)imageWidth;
        lp.height = (int)imageHeight;
        this.mImgView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mImgView.setImageDrawable(imageDrawable);
        if (backgroundShadowColor == 0) {
            this.setImageBackgroundColor(backgroundColor);
            this.setShadowColor(shadowColor);
        } else {
            this.setImageBackgroundShadowColor(backgroundShadowColor);
        }
        this.setImagePadding(24.0f);
    }

    public ImageView getImage() {
        return this.mImgView;
    }

    public ShadowLayout getShadowLayout() {
        return this.mShadowLayout;
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mImgView.setImageDrawable(drawable2);
    }

    public void setImageResource(int resId) {
        this.mImgView.setImageResource(resId);
    }

    public void setImageBackgroundShadowColor(int color2) {
        this.setImageBackgroundColor(color2);
        this.setShadowColor(0x80FFFFFF & color2);
    }

    public void setImageBackgroundColor(int color2) {
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new OvalShape());
        shapeDrawable.setTint(color2);
        RippleDrawable rippleDrawable = new RippleDrawable(ColorStateList.valueOf((int)0x1A000000), (Drawable)shapeDrawable, null);
        this.mImgView.setBackground((Drawable)rippleDrawable);
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowLayout.setShadowColor(shadowColor);
    }

    public void setImageSize(float width, float height) {
        int imageWidth = this.applyDp(width);
        int imageHeight = this.applyDp(height);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mImgView.getLayoutParams();
        lp.width = imageWidth;
        lp.height = imageHeight;
        this.mImgView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.setImagePadding(24.0f);
    }

    public void setImagePadding(float size) {
        float imageSrcSize = this.applyDp(size);
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mImgView.getLayoutParams();
        int paddingLeftRight = (int)(((float)lp.width - imageSrcSize) / 2.0f);
        int paddingTopBottom = (int)(((float)lp.height - imageSrcSize) / 2.0f);
        this.mImgView.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
    }

    public void setVisibility(int visibility) {
        switch (visibility) {
            case 0: {
                this.mShadowLayout.setVisibility(0);
                this.mImgView.setVisibility(0);
                break;
            }
            case 4: {
                this.mShadowLayout.setVisibility(4);
                this.mImgView.setVisibility(4);
                break;
            }
            case 8: {
                this.mShadowLayout.setVisibility(8);
                this.mImgView.setVisibility(8);
            }
        }
        super.setVisibility(visibility);
    }

    private int applyDp(float valueDp) {
        return (int)TypedValue.applyDimension((int)1, (float)valueDp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

