/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.shadow;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import com.transsion.widgetslib.R;

public class ShadowLayout
extends FrameLayout {
    private static final float DEFAULT_SHADOW_RADIUS = 6.0f;
    private static final float DEFAULT_SHADOW_DISTANCE = 3.0f;
    private static final float DEFAULT_SHADOW_ANGLE = 90.0f;
    public static final int DEFAULT_SHADOW_COLOR = -2138535800;
    private static final int MAX_ALPHA = 255;
    private static final float MAX_ANGLE = 360.0f;
    private static final float MIN_RADIUS = 0.1f;
    private static final float MIN_ANGLE = 0.0f;
    private final Paint mPaint = new Paint(1){
        {
            this.setDither(true);
            this.setFilterBitmap(true);
        }
    };
    private Bitmap mBitmap;
    private final Canvas mCanvas = new Canvas();
    private final Rect mBounds = new Rect();
    private boolean mInvalidateShadow = true;
    private boolean mIsShadowed;
    private int mShadowColor;
    private int mShadowAlpha;
    private float mShadowRadius;
    private float mShadowDistance;
    private float mShadowAngle;
    private float mShadowDx;
    private float mShadowDy;

    public ShadowLayout(Context context) {
        this(context, null);
    }

    public ShadowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShadowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.setLayerType(2, this.mPaint);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShadowLayout);
        try {
            this.setIsShadowed(typedArray.getBoolean(R.styleable.ShadowLayout_os_shadowed, true));
            float defaultRadius = TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.setShadowRadius(typedArray.getDimension(R.styleable.ShadowLayout_os_shadow_radius, defaultRadius));
            float defaultDistance = TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.setShadowDistance(typedArray.getDimension(R.styleable.ShadowLayout_os_shadow_distance, defaultDistance));
            this.setShadowAngle(typedArray.getInteger(R.styleable.ShadowLayout_os_shadow_angle, 90));
            this.setShadowColor(typedArray.getColor(R.styleable.ShadowLayout_os_shadow_color, -2138535800));
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }

    public boolean isShadowed() {
        return this.mIsShadowed;
    }

    public void setIsShadowed(boolean isShadowed) {
        this.mIsShadowed = isShadowed;
        this.postInvalidate();
    }

    public float getShadowDistance() {
        return this.mShadowDistance;
    }

    public void setShadowDistance(float shadowDistance) {
        this.mShadowDistance = shadowDistance;
        this.resetShadow();
    }

    public float getShadowAngle() {
        return this.mShadowAngle;
    }

    public void setShadowAngle(float shadowAngle) {
        this.mShadowAngle = Math.max(0.0f, Math.min(shadowAngle, 360.0f));
        this.resetShadow();
    }

    public float getShadowRadius() {
        return this.mShadowRadius;
    }

    public void setShadowRadius(float shadowRadius) {
        this.mShadowRadius = Math.max(0.1f, shadowRadius);
        if (this.isInEditMode()) {
            return;
        }
        this.mPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(this.mShadowRadius, BlurMaskFilter.Blur.NORMAL));
        this.resetShadow();
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        this.mShadowAlpha = Color.alpha((int)shadowColor);
        this.resetShadow();
    }

    public float getShadowDx() {
        return this.mShadowDx;
    }

    public float getShadowDy() {
        return this.mShadowDy;
    }

    private void resetShadow() {
        this.mShadowDx = (float)((double)this.mShadowDistance * Math.cos((double)(this.mShadowAngle / 180.0f) * Math.PI));
        this.mShadowDy = (float)((double)this.mShadowDistance * Math.sin((double)(this.mShadowAngle / 180.0f) * Math.PI));
        int padding = (int)(this.mShadowDistance + this.mShadowRadius);
        this.setPadding(padding, padding, padding, padding);
        this.requestLayout();
    }

    private int adjustShadowAlpha(boolean adjust) {
        return Color.argb((int)(adjust ? 255 : this.mShadowAlpha), (int)Color.red((int)this.mShadowColor), (int)Color.green((int)this.mShadowColor), (int)Color.blue((int)this.mShadowColor));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mBounds.set(0, 0, View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    public void requestLayout() {
        this.mInvalidateShadow = true;
        super.requestLayout();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mIsShadowed) {
            if (this.mInvalidateShadow) {
                if (this.mBounds.width() != 0 && this.mBounds.height() != 0) {
                    this.mBitmap = Bitmap.createBitmap((int)this.mBounds.width(), (int)this.mBounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    this.mCanvas.setBitmap(this.mBitmap);
                    this.mInvalidateShadow = false;
                    super.dispatchDraw(this.mCanvas);
                    Bitmap extractedAlpha = this.mBitmap.extractAlpha();
                    this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    this.mPaint.setColor(this.adjustShadowAlpha(false));
                    this.mCanvas.drawBitmap(extractedAlpha, this.mShadowDx, this.mShadowDy, this.mPaint);
                    extractedAlpha.recycle();
                } else {
                    this.mBitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
            }
            this.mPaint.setColor(this.adjustShadowAlpha(true));
            if (this.mCanvas != null && this.mBitmap != null && !this.mBitmap.isRecycled()) {
                canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mPaint);
            }
        }
        super.dispatchDraw(canvas);
    }
}

