/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.ScribeConstants;
import com.twitter.sdk.android.tweetui.TimelineCursor;
import com.twitter.sdk.android.tweetui.TimelineResult;
import com.twitter.sdk.android.tweetui.TweetUi;
import java.util.List;

abstract class BaseTimeline {
    protected final TweetUi tweetUi;

    BaseTimeline(TweetUi tweetUi) {
        if (tweetUi == null) {
            throw new IllegalArgumentException("TweetUi instance must not be null");
        }
        this.tweetUi = tweetUi;
        this.scribeImpression();
    }

    abstract String getTimelineType();

    private void scribeImpression() {
        this.tweetUi.scribe(ScribeConstants.getSyndicatedSdkTimelineNamespace(this.getTimelineType()), ScribeConstants.getTfwClientTimelineNamespace(this.getTimelineType()));
    }

    static Long decrementMaxId(Long maxId) {
        return maxId == null ? null : Long.valueOf(maxId - 1L);
    }

    void addRequest(Callback<TwitterApiClient> cb) {
        this.tweetUi.getGuestAuthQueue().addClientRequest(cb);
    }

    static class TweetsCallback
    extends Callback<List<Tweet>> {
        protected final Callback<TimelineResult<Tweet>> cb;

        TweetsCallback(Callback<TimelineResult<Tweet>> cb) {
            this.cb = cb;
        }

        public void success(Result<List<Tweet>> result) {
            List tweets = (List)result.data;
            TimelineResult timelineResult = new TimelineResult(new TimelineCursor(tweets), tweets);
            if (this.cb != null) {
                this.cb.success(timelineResult, result.response);
            }
        }

        public void failure(TwitterException exception) {
            if (this.cb != null) {
                this.cb.failure(exception);
            }
        }
    }
}

