/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.IntentUtils;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.internal.UserUtils;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.TweetBuilder;
import com.twitter.sdk.android.core.models.User;
import com.twitter.sdk.android.core.models.VideoInfo;
import com.twitter.sdk.android.tweetui.ColorUtils;
import com.twitter.sdk.android.tweetui.FormattedTweetText;
import com.twitter.sdk.android.tweetui.GalleryActivity;
import com.twitter.sdk.android.tweetui.LinkClickListener;
import com.twitter.sdk.android.tweetui.PlayerActivity;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.ResetTweetCallback;
import com.twitter.sdk.android.tweetui.TweetActionBarView;
import com.twitter.sdk.android.tweetui.TweetDateUtils;
import com.twitter.sdk.android.tweetui.TweetLinkClickListener;
import com.twitter.sdk.android.tweetui.TweetMediaClickListener;
import com.twitter.sdk.android.tweetui.TweetScribeClient;
import com.twitter.sdk.android.tweetui.TweetScribeClientImpl;
import com.twitter.sdk.android.tweetui.TweetTextLinkifier;
import com.twitter.sdk.android.tweetui.TweetUi;
import com.twitter.sdk.android.tweetui.TweetUtils;
import com.twitter.sdk.android.tweetui.Utils;
import com.twitter.sdk.android.tweetui.VideoScribeClient;
import com.twitter.sdk.android.tweetui.VideoScribeClientImpl;
import com.twitter.sdk.android.tweetui.internal.MediaBadgeView;
import com.twitter.sdk.android.tweetui.internal.SpanClickHandler;
import com.twitter.sdk.android.tweetui.internal.TweetMediaUtils;
import com.twitter.sdk.android.tweetui.internal.TweetMediaView;
import io.fabric.sdk.android.Fabric;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public abstract class BaseTweetView
extends LinearLayout {
    private static final String TAG = "TweetUi";
    private static final int DEFAULT_STYLE = R.style.tw__TweetLightStyle;
    private static final String EMPTY_STRING = "";
    static final double DEFAULT_ASPECT_RATIO = 1.7777777777777777;
    static final double SECONDARY_TEXT_COLOR_LIGHT_OPACITY = 0.4;
    static final double SECONDARY_TEXT_COLOR_DARK_OPACITY = 0.35;
    static final double MEDIA_BG_LIGHT_OPACITY = 0.08;
    static final double MEDIA_BG_DARK_OPACITY = 0.12;
    static final long INVALID_ID = -1L;
    final DependencyProvider dependencyProvider;
    private LinkClickListener linkClickListener;
    TweetLinkClickListener tweetLinkClickListener;
    TweetMediaClickListener tweetMediaClickListener;
    private Uri permalinkUri;
    Tweet tweet;
    int styleResId;
    RelativeLayout containerView;
    ImageView avatarView;
    TextView fullNameView;
    TextView screenNameView;
    ImageView verifiedCheckView;
    FrameLayout mediaContainerView;
    TweetMediaView mediaView;
    TextView contentView;
    TextView timestampView;
    ImageView twitterLogoView;
    TextView retweetedByView;
    TweetActionBarView tweetActionBarView;
    MediaBadgeView mediaBadgeView;
    View bottomSeparator;
    int containerBgColor;
    int primaryTextColor;
    int secondaryTextColor;
    int actionColor;
    int actionHighlightColor;
    int mediaBgColor;
    int photoErrorResId;
    int birdLogoResId;
    int retweetIconResId;
    boolean tweetActionsEnabled;
    ColorDrawable mediaBg;

    BaseTweetView(Context context, Tweet tweet) {
        this(context, tweet, DEFAULT_STYLE);
    }

    BaseTweetView(Context context, Tweet tweet, int styleResId) {
        this(context, tweet, styleResId, new DependencyProvider());
    }

    BaseTweetView(Context context, Tweet tweet, int styleResId, DependencyProvider dependencyProvider) {
        super(context, null);
        this.dependencyProvider = dependencyProvider;
        this.initAttributes(styleResId);
        this.inflateView(context);
        this.findSubviews();
        this.applyStyles();
        if (!this.isTweetUiEnabled()) {
            return;
        }
        this.initTweetActions();
        this.setTweet(tweet);
    }

    public BaseTweetView(Context context, AttributeSet attrs) {
        this(context, attrs, new DependencyProvider());
    }

    BaseTweetView(Context context, AttributeSet attrs, DependencyProvider dependencyProvider) {
        super(context, attrs);
        this.dependencyProvider = dependencyProvider;
        this.initXmlAttributes(context, attrs);
        this.inflateView(context);
    }

    public BaseTweetView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, new DependencyProvider());
    }

    @TargetApi(value=11)
    BaseTweetView(Context context, AttributeSet attrs, int defStyle, DependencyProvider dependencyProvider) {
        super(context, attrs, defStyle);
        this.dependencyProvider = dependencyProvider;
        this.initXmlAttributes(context, attrs);
        this.inflateView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(int styleResId) {
        this.styleResId = styleResId;
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(styleResId, R.styleable.tw__TweetView);
        try {
            this.setStyleAttributes(a);
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initXmlAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.tw__TweetView, 0, 0);
        try {
            this.setXmlDataAttributes(a);
            this.setStyleAttributes(a);
        }
        finally {
            a.recycle();
        }
    }

    private void setXmlDataAttributes(TypedArray a) {
        long tweetId = Utils.numberOrDefault(a.getString(R.styleable.tw__TweetView_tw__tweet_id), -1L);
        if (tweetId <= 0L) {
            throw new IllegalArgumentException("Invalid tw__tweet_id");
        }
        this.setPermalinkUri(null, tweetId);
        this.tweet = new TweetBuilder().setId(tweetId).build();
    }

    private void setStyleAttributes(TypedArray a) {
        this.containerBgColor = a.getColor(R.styleable.tw__TweetView_tw__container_bg_color, this.getResources().getColor(R.color.tw__tweet_light_container_bg_color));
        this.primaryTextColor = a.getColor(R.styleable.tw__TweetView_tw__primary_text_color, this.getResources().getColor(R.color.tw__tweet_light_primary_text_color));
        this.actionColor = a.getColor(R.styleable.tw__TweetView_tw__action_color, this.getResources().getColor(R.color.tw__tweet_action_color));
        this.actionHighlightColor = a.getColor(R.styleable.tw__TweetView_tw__action_highlight_color, this.getResources().getColor(R.color.tw__tweet_action_light_highlight_color));
        this.tweetActionsEnabled = a.getBoolean(R.styleable.tw__TweetView_tw__tweet_actions_enabled, false);
        boolean isLightBg = ColorUtils.isLightColor(this.containerBgColor);
        if (isLightBg) {
            this.photoErrorResId = R.drawable.tw__ic_tweet_photo_error_light;
            this.birdLogoResId = R.drawable.tw__ic_logo_blue;
            this.retweetIconResId = R.drawable.tw__ic_retweet_light;
        } else {
            this.photoErrorResId = R.drawable.tw__ic_tweet_photo_error_dark;
            this.birdLogoResId = R.drawable.tw__ic_logo_white;
            this.retweetIconResId = R.drawable.tw__ic_retweet_dark;
        }
        this.secondaryTextColor = ColorUtils.calculateOpacityTransform(isLightBg ? 0.4 : 0.35, isLightBg ? -1 : -16777216, this.primaryTextColor);
        this.mediaBgColor = ColorUtils.calculateOpacityTransform(isLightBg ? 0.08 : 0.12, isLightBg ? -16777216 : -1, this.containerBgColor);
        this.mediaBg = new ColorDrawable(this.mediaBgColor);
    }

    private void inflateView(Context context) {
        LayoutInflater localInflater = LayoutInflater.from((Context)context);
        View v = localInflater.inflate(this.getLayout(), null, false);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        v.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView(v);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (!this.isTweetUiEnabled()) {
            return;
        }
        this.findSubviews();
        this.applyStyles();
        this.initTweetActions();
        this.loadTweet();
    }

    private void initTweetActions() {
        this.setTweetActionsEnabled(this.tweetActionsEnabled);
        this.tweetActionBarView.setOnActionCallback(new ResetTweetCallback(this, this.dependencyProvider.getTweetUi().getTweetRepository(), null));
    }

    boolean isTweetUiEnabled() {
        if (this.isInEditMode()) {
            return false;
        }
        try {
            this.dependencyProvider.getTweetUi();
        }
        catch (IllegalStateException e) {
            Fabric.getLogger().e(TAG, e.getMessage());
            this.setEnabled(false);
            return false;
        }
        return true;
    }

    void findSubviews() {
        this.containerView = (RelativeLayout)this.findViewById(R.id.tw__tweet_view);
        this.avatarView = (ImageView)this.findViewById(R.id.tw__tweet_author_avatar);
        this.fullNameView = (TextView)this.findViewById(R.id.tw__tweet_author_full_name);
        this.screenNameView = (TextView)this.findViewById(R.id.tw__tweet_author_screen_name);
        this.verifiedCheckView = (ImageView)this.findViewById(R.id.tw__tweet_author_verified);
        this.mediaContainerView = (FrameLayout)this.findViewById(R.id.tw__tweet_media_container);
        this.mediaView = (TweetMediaView)this.findViewById(R.id.tw__tweet_media);
        this.contentView = (TextView)this.findViewById(R.id.tw__tweet_text);
        this.timestampView = (TextView)this.findViewById(R.id.tw__tweet_timestamp);
        this.twitterLogoView = (ImageView)this.findViewById(R.id.tw__twitter_logo);
        this.retweetedByView = (TextView)this.findViewById(R.id.tw__tweet_retweeted_by);
        this.tweetActionBarView = (TweetActionBarView)this.findViewById(R.id.tw__tweet_action_bar);
        this.mediaBadgeView = (MediaBadgeView)this.findViewById(R.id.tw__tweet_media_badge);
        this.bottomSeparator = this.findViewById(R.id.bottom_separator);
    }

    abstract int getLayout();

    abstract String getViewTypeName();

    public long getTweetId() {
        if (this.tweet == null) {
            return -1L;
        }
        return this.tweet.id;
    }

    public void setTweet(Tweet tweet) {
        this.tweet = tweet;
        this.render();
    }

    public Tweet getTweet() {
        return this.tweet;
    }

    public void setOnActionCallback(Callback<Tweet> actionCallback) {
        this.tweetActionBarView.setOnActionCallback(new ResetTweetCallback(this, this.dependencyProvider.getTweetUi().getTweetRepository(), actionCallback));
        this.tweetActionBarView.setTweet(this.tweet);
    }

    public void setTweetMediaClickListener(TweetMediaClickListener tweetMediaClickListener) {
        this.tweetMediaClickListener = tweetMediaClickListener;
    }

    public void setTweetLinkClickListener(TweetLinkClickListener tweetLinkClickListener) {
        this.tweetLinkClickListener = tweetLinkClickListener;
    }

    void render() {
        Tweet displayTweet = TweetUtils.getDisplayTweet(this.tweet);
        this.setProfilePhotoView(displayTweet);
        this.setName(displayTweet);
        this.setScreenName(displayTweet);
        this.setTimestamp(displayTweet);
        this.setTweetMedia(displayTweet);
        this.setText(displayTweet);
        this.setContentDescription(displayTweet);
        this.setTweetActions(this.tweet);
        this.showRetweetedBy(this.tweet);
        if (TweetUtils.isTweetResolvable(this.tweet)) {
            this.setPermalinkUri(this.tweet.user.screenName, this.getTweetId());
        } else {
            this.permalinkUri = null;
        }
        this.setPermalinkLauncher();
        this.scribeImpression();
    }

    private void loadTweet() {
        final long tweetId = this.getTweetId();
        Callback<Tweet> repoCb = new Callback<Tweet>(){

            public void success(Result<Tweet> result) {
                BaseTweetView.this.setTweet((Tweet)result.data);
            }

            public void failure(TwitterException exception) {
                Fabric.getLogger().d(BaseTweetView.TAG, String.format("loadTweet failure for Tweet Id %d.", tweetId));
            }
        };
        this.dependencyProvider.getTweetUi().getTweetRepository().loadTweet(this.getTweetId(), repoCb);
    }

    Uri getPermalinkUri() {
        return this.permalinkUri;
    }

    void setPermalinkUri(String screenName, Long tweetId) {
        if (tweetId <= 0L) {
            return;
        }
        this.permalinkUri = TweetUtils.getPermalink(screenName, tweetId);
    }

    private void setPermalinkLauncher() {
        PermalinkClickListener listener = new PermalinkClickListener();
        this.setOnClickListener(listener);
    }

    void showRetweetedBy(Tweet tweet) {
        if (tweet == null || tweet.retweetedStatus == null) {
            this.retweetedByView.setVisibility(8);
        } else {
            this.retweetedByView.setText((CharSequence)this.getResources().getString(R.string.tw__retweeted_by_format, new Object[]{tweet.user.name}));
            this.retweetedByView.setVisibility(0);
        }
    }

    void launchPermalink() {
        Intent intent = new Intent("android.intent.action.VIEW", this.getPermalinkUri());
        if (!IntentUtils.safeStartActivity((Context)this.getContext(), (Intent)intent)) {
            Fabric.getLogger().e(TAG, "Activity cannot be found to open permalink URI");
        }
    }

    void scribeImpression() {
        if (this.tweet != null) {
            this.dependencyProvider.getTweetScribeClient().impression(this.tweet, this.getViewTypeName(), this.tweetActionsEnabled);
        }
    }

    void scribePermalinkClick() {
        if (this.tweet != null) {
            this.dependencyProvider.getTweetScribeClient().click(this.tweet, this.getViewTypeName());
        }
    }

    protected void applyStyles() {
        this.containerView.setBackgroundColor(this.containerBgColor);
        this.avatarView.setImageDrawable((Drawable)this.mediaBg);
        this.mediaView.setImageDrawable((Drawable)this.mediaBg);
        this.fullNameView.setTextColor(this.primaryTextColor);
        this.screenNameView.setTextColor(this.secondaryTextColor);
        this.contentView.setTextColor(this.primaryTextColor);
        this.timestampView.setTextColor(this.secondaryTextColor);
        this.twitterLogoView.setImageResource(this.birdLogoResId);
        this.retweetedByView.setTextColor(this.secondaryTextColor);
    }

    private void setName(Tweet displayTweet) {
        if (displayTweet != null && displayTweet.user != null) {
            this.fullNameView.setText((CharSequence)Utils.stringOrEmpty(displayTweet.user.name));
        } else {
            this.fullNameView.setText((CharSequence)EMPTY_STRING);
        }
    }

    private void setScreenName(Tweet displayTweet) {
        if (displayTweet != null && displayTweet.user != null) {
            this.screenNameView.setText(UserUtils.formatScreenName((CharSequence)Utils.stringOrEmpty(displayTweet.user.screenName)));
        } else {
            this.screenNameView.setText((CharSequence)EMPTY_STRING);
        }
    }

    @TargetApi(value=16)
    private void setText(Tweet displayTweet) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.contentView.setImportantForAccessibility(2);
        }
        CharSequence tweetText = Utils.charSeqOrEmpty(this.getLinkifiedText(displayTweet));
        SpanClickHandler.enableClicksOnSpans(this.contentView);
        if (!TextUtils.isEmpty((CharSequence)tweetText)) {
            this.contentView.setText(tweetText);
            this.contentView.setVisibility(0);
        } else {
            this.contentView.setText((CharSequence)EMPTY_STRING);
            this.contentView.setVisibility(8);
        }
    }

    private void setTimestamp(Tweet displayTweet) {
        String formattedTimestamp;
        if (displayTweet != null && displayTweet.createdAt != null && TweetDateUtils.isValidTimestamp(displayTweet.createdAt)) {
            Long createdAtTimestamp = TweetDateUtils.apiTimeToLong(displayTweet.createdAt);
            String timestamp = TweetDateUtils.getRelativeTimeString(this.getResources(), System.currentTimeMillis(), createdAtTimestamp);
            formattedTimestamp = TweetDateUtils.dotPrefix(timestamp);
        } else {
            formattedTimestamp = EMPTY_STRING;
        }
        this.timestampView.setText((CharSequence)formattedTimestamp);
    }

    void setProfilePhotoView(Tweet displayTweet) {
        Picasso imageLoader = this.dependencyProvider.getImageLoader();
        if (imageLoader == null) {
            return;
        }
        String url = displayTweet == null || displayTweet.user == null ? null : UserUtils.getProfileImageUrlHttps((User)displayTweet.user, (UserUtils.AvatarSize)UserUtils.AvatarSize.REASONABLY_SMALL);
        imageLoader.load(url).placeholder((Drawable)this.mediaBg).into(this.avatarView);
    }

    final void setTweetMedia(Tweet displayTweet) {
        this.clearMediaView();
        if (displayTweet != null && TweetMediaUtils.hasVideo(displayTweet)) {
            MediaEntity mediaEntity = TweetMediaUtils.getVideoEntity(displayTweet);
            this.mediaContainerView.setVisibility(0);
            this.mediaView.setOverlayDrawable(this.getContext().getResources().getDrawable(R.drawable.tw__player_overlay));
            this.mediaBadgeView.setMediaEntity(mediaEntity);
            this.setMediaLauncher(displayTweet, mediaEntity);
            this.setTweetMedia(mediaEntity);
            this.dependencyProvider.getVideoScribeClient().impression(displayTweet.id, mediaEntity);
        } else if (displayTweet != null && TweetMediaUtils.hasPhoto(displayTweet)) {
            MediaEntity mediaEntity = TweetMediaUtils.getPhotoEntity(displayTweet);
            this.mediaContainerView.setVisibility(0);
            this.mediaBadgeView.setMediaEntity(mediaEntity);
            this.setPhotoLauncher(displayTweet, mediaEntity);
            this.setTweetMedia(mediaEntity);
        } else {
            this.mediaContainerView.setVisibility(8);
        }
    }

    private void setMediaLauncher(final Tweet displayTweet, final MediaEntity entity) {
        this.mediaView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BaseTweetView.this.tweetMediaClickListener != null) {
                    BaseTweetView.this.tweetMediaClickListener.onMediaEntityClick(BaseTweetView.this.tweet, entity);
                } else {
                    VideoInfo.Variant variant = TweetMediaUtils.getSupportedVariant(entity);
                    if (variant != null) {
                        Intent intent = new Intent(BaseTweetView.this.getContext(), PlayerActivity.class);
                        intent.putExtra("MEDIA_ENTITY", (Serializable)entity);
                        intent.putExtra("TWEET_ID", displayTweet.id);
                        IntentUtils.safeStartActivity((Context)BaseTweetView.this.getContext(), (Intent)intent);
                    }
                }
            }
        });
    }

    private void setPhotoLauncher(final Tweet displayTweet, final MediaEntity entity) {
        this.mediaView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BaseTweetView.this.tweetMediaClickListener != null) {
                    BaseTweetView.this.tweetMediaClickListener.onMediaEntityClick(BaseTweetView.this.tweet, entity);
                } else {
                    Intent intent = new Intent(BaseTweetView.this.getContext(), GalleryActivity.class);
                    intent.putExtra("MEDIA_ENTITY", (Serializable)entity);
                    intent.putExtra("TWEET_ID", displayTweet.id);
                    IntentUtils.safeStartActivity((Context)BaseTweetView.this.getContext(), (Intent)intent);
                }
            }
        });
    }

    void setTweetMedia(MediaEntity photoEntity) {
        Picasso imageLoader = this.dependencyProvider.getImageLoader();
        if (imageLoader == null) {
            return;
        }
        this.mediaView.resetSize();
        this.mediaView.setAspectRatio(this.getAspectRatio(photoEntity));
        imageLoader.load(photoEntity.mediaUrlHttps).placeholder((Drawable)this.mediaBg).fit().centerCrop().into((ImageView)this.mediaView, (com.squareup.picasso.Callback)new PicassoCallback());
    }

    protected double getAspectRatio(MediaEntity photoEntity) {
        if (photoEntity == null || photoEntity.sizes == null || photoEntity.sizes.medium == null || photoEntity.sizes.medium.w == 0 || photoEntity.sizes.medium.h == 0) {
            return 1.7777777777777777;
        }
        return (double)photoEntity.sizes.medium.w / (double)photoEntity.sizes.medium.h;
    }

    @TargetApi(value=16)
    protected void clearMediaView() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mediaView.setBackground(null);
        } else {
            this.mediaView.setBackgroundDrawable(null);
        }
        this.mediaView.setOverlayDrawable(null);
        this.mediaView.setOnClickListener(null);
        this.mediaView.setClickable(false);
    }

    protected void setErrorImage() {
        Picasso imageLoader = this.dependencyProvider.getImageLoader();
        if (imageLoader == null) {
            return;
        }
        imageLoader.load(this.photoErrorResId).into((ImageView)this.mediaView, new com.squareup.picasso.Callback(){

            public void onSuccess() {
                BaseTweetView.this.mediaView.setBackgroundColor(BaseTweetView.this.mediaBgColor);
            }

            public void onError() {
            }
        });
    }

    protected CharSequence getLinkifiedText(Tweet displayTweet) {
        FormattedTweetText formattedText = this.dependencyProvider.getTweetUi().getTweetRepository().formatTweetText(displayTweet);
        if (formattedText == null) {
            return null;
        }
        boolean stripPhotoEntity = TweetMediaUtils.hasPhoto(displayTweet);
        return TweetTextLinkifier.linkifyUrls(formattedText, this.getLinkClickListener(), stripPhotoEntity, this.actionColor, this.actionHighlightColor);
    }

    void setContentDescription(Tweet displayTweet) {
        if (!TweetUtils.isTweetResolvable(displayTweet)) {
            this.setContentDescription(this.getResources().getString(R.string.tw__loading_tweet));
            return;
        }
        FormattedTweetText formattedTweetText = this.dependencyProvider.getTweetUi().getTweetRepository().formatTweetText(displayTweet);
        String tweetText = null;
        if (formattedTweetText != null) {
            tweetText = formattedTweetText.text;
        }
        long createdAt = TweetDateUtils.apiTimeToLong(displayTweet.createdAt);
        String timestamp = null;
        if (createdAt != -1L) {
            timestamp = DateFormat.getDateInstance().format(new Date(createdAt));
        }
        this.setContentDescription(this.getResources().getString(R.string.tw__tweet_content_description, new Object[]{Utils.stringOrEmpty(displayTweet.user.name), Utils.stringOrEmpty(tweetText), Utils.stringOrEmpty(timestamp)}));
    }

    void setTweetActions(Tweet tweet) {
        this.tweetActionBarView.setTweet(tweet);
    }

    public void setTweetActionsEnabled(boolean enabled) {
        this.tweetActionsEnabled = enabled;
        if (this.tweetActionsEnabled) {
            this.tweetActionBarView.setVisibility(0);
            this.bottomSeparator.setVisibility(8);
        } else {
            this.tweetActionBarView.setVisibility(8);
            this.bottomSeparator.setVisibility(0);
        }
    }

    protected LinkClickListener getLinkClickListener() {
        if (this.linkClickListener == null) {
            this.linkClickListener = new LinkClickListener(){

                @Override
                public void onUrlClicked(String url) {
                    if (TextUtils.isEmpty((CharSequence)url)) {
                        return;
                    }
                    if (BaseTweetView.this.tweetLinkClickListener != null) {
                        BaseTweetView.this.tweetLinkClickListener.onLinkClick(BaseTweetView.this.tweet, url);
                    } else {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                        if (!IntentUtils.safeStartActivity((Context)BaseTweetView.this.getContext(), (Intent)intent)) {
                            Fabric.getLogger().e(BaseTweetView.TAG, "Activity cannot be found to open URL");
                        }
                    }
                }

                @Override
                public void onPhotoClicked(MediaEntity mediaEntity) {
                }
            };
        }
        return this.linkClickListener;
    }

    static class DependencyProvider {
        TweetScribeClient tweetScribeClient;
        VideoScribeClient videoScribeClient;

        DependencyProvider() {
        }

        TweetUi getTweetUi() {
            return TweetUi.getInstance();
        }

        TweetScribeClient getTweetScribeClient() {
            if (this.tweetScribeClient == null) {
                this.tweetScribeClient = new TweetScribeClientImpl(this.getTweetUi());
            }
            return this.tweetScribeClient;
        }

        VideoScribeClient getVideoScribeClient() {
            if (this.videoScribeClient == null) {
                this.videoScribeClient = new VideoScribeClientImpl(this.getTweetUi());
            }
            return this.videoScribeClient;
        }

        Picasso getImageLoader() {
            return TweetUi.getInstance().getImageLoader();
        }
    }

    class PermalinkClickListener
    implements View.OnClickListener {
        PermalinkClickListener() {
        }

        public void onClick(View v) {
            if (BaseTweetView.this.getPermalinkUri() == null) {
                return;
            }
            BaseTweetView.this.scribePermalinkClick();
            BaseTweetView.this.launchPermalink();
        }
    }

    class PicassoCallback
    implements com.squareup.picasso.Callback {
        PicassoCallback() {
        }

        public void onSuccess() {
        }

        public void onError() {
            BaseTweetView.this.setErrorImage();
        }
    }
}

