/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.GuestCallback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.internal.TwitterCollection;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.core.models.TweetBuilder;
import com.twitter.sdk.android.core.models.User;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.LoggingCallback;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineCursor;
import com.twitter.sdk.android.tweetui.TimelineResult;
import com.twitter.sdk.android.tweetui.TweetUi;
import io.fabric.sdk.android.Fabric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CollectionTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    static final String COLLECTION_PREFIX = "custom-";
    private static final String SCRIBE_SECTION = "collection";
    final String collectionIdentifier;
    final Integer maxItemsPerRequest;

    CollectionTimeline(TweetUi tweetUi, Long collectionId, Integer maxItemsPerRequest) {
        super(tweetUi);
        this.collectionIdentifier = collectionId == null ? null : COLLECTION_PREFIX + Long.toString(collectionId);
        this.maxItemsPerRequest = maxItemsPerRequest;
    }

    @Override
    public void next(Long minPosition, Callback<TimelineResult<Tweet>> cb) {
        this.addRequest(this.createCollectionRequest(minPosition, null, cb));
    }

    @Override
    public void previous(Long maxPosition, Callback<TimelineResult<Tweet>> cb) {
        this.addRequest(this.createCollectionRequest(null, maxPosition, cb));
    }

    @Override
    String getTimelineType() {
        return SCRIBE_SECTION;
    }

    Callback<TwitterApiClient> createCollectionRequest(final Long minPosition, final Long maxPosition, final Callback<TimelineResult<Tweet>> cb) {
        return new LoggingCallback<TwitterApiClient>(cb, Fabric.getLogger()){

            public void success(Result<TwitterApiClient> result) {
                ((TwitterApiClient)result.data).getCollectionService().collection(CollectionTimeline.this.collectionIdentifier, CollectionTimeline.this.maxItemsPerRequest, maxPosition, minPosition, (Callback)new GuestCallback((Callback)new CollectionCallback((Callback<TimelineResult<Tweet>>)cb)));
            }
        };
    }

    static List<Tweet> getOrderedTweets(TwitterCollection collection) {
        if (collection == null || collection.contents == null || collection.contents.tweetMap == null || collection.contents.userMap == null || collection.metadata == null || collection.metadata.timelineItems == null || collection.metadata.position == null) {
            return Collections.emptyList();
        }
        ArrayList<Tweet> tweets = new ArrayList<Tweet>();
        HashMap<Long, Tweet> tweetMap = new HashMap<Long, Tweet>();
        for (Tweet trimmedTweet : collection.contents.tweetMap.values()) {
            Long userId = trimmedTweet.user.id;
            User user = (User)collection.contents.userMap.get(userId);
            Tweet tweet = new TweetBuilder().copy(trimmedTweet).setUser(user).build();
            tweetMap.put(tweet.id, tweet);
        }
        for (TwitterCollection.TimelineItem item : collection.metadata.timelineItems) {
            Tweet tweet = (Tweet)tweetMap.get(item.tweetItem.id);
            tweets.add(tweet);
        }
        return tweets;
    }

    static TimelineCursor getTimelineCursor(TwitterCollection twitterCollection) {
        if (twitterCollection == null || twitterCollection.metadata == null || twitterCollection.metadata.position == null) {
            return null;
        }
        Long minPosition = twitterCollection.metadata.position.minPosition;
        Long maxPosition = twitterCollection.metadata.position.maxPosition;
        return new TimelineCursor(minPosition, maxPosition);
    }

    public static class Builder {
        private final TweetUi tweetUi;
        private Long collectionId;
        private Integer maxItemsPerRequest = 30;

        public Builder() {
            this(TweetUi.getInstance());
        }

        public Builder(TweetUi tweetUi) {
            if (tweetUi == null) {
                throw new IllegalArgumentException("TweetUi instance must not be null");
            }
            this.tweetUi = tweetUi;
        }

        public Builder id(Long collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder maxItemsPerRequest(Integer maxItemsPerRequest) {
            this.maxItemsPerRequest = maxItemsPerRequest;
            return this;
        }

        public CollectionTimeline build() {
            if (this.collectionId == null) {
                throw new IllegalStateException("collection id must not be null");
            }
            return new CollectionTimeline(this.tweetUi, this.collectionId, this.maxItemsPerRequest);
        }
    }

    class CollectionCallback
    extends Callback<TwitterCollection> {
        private final Callback<TimelineResult<Tweet>> cb;

        CollectionCallback(Callback<TimelineResult<Tweet>> cb) {
            this.cb = cb;
        }

        public void success(Result<TwitterCollection> result) {
            TimelineCursor timelineCursor = CollectionTimeline.getTimelineCursor((TwitterCollection)result.data);
            List<Tweet> tweets = CollectionTimeline.getOrderedTweets((TwitterCollection)result.data);
            TimelineResult<Object> timelineResult = timelineCursor != null ? new TimelineResult<Tweet>(timelineCursor, tweets) : new TimelineResult(null, Collections.emptyList());
            if (this.cb != null) {
                this.cb.success(timelineResult, result.response);
            }
        }

        public void failure(TwitterException exception) {
            if (this.cb != null) {
                this.cb.failure(exception);
            }
        }
    }
}

