/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineCursor;
import com.twitter.sdk.android.tweetui.TimelineResult;
import com.twitter.sdk.android.tweetui.TweetUi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FixedTweetTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    private static final String SCRIBE_SECTION = "fixed";
    List<Tweet> tweets;

    FixedTweetTimeline(TweetUi tweetUi, List<Tweet> tweets) {
        super(tweetUi);
        this.tweets = tweets == null ? new ArrayList() : tweets;
    }

    @Override
    public void next(Long minPosition, Callback<TimelineResult<Tweet>> cb) {
        TimelineResult<Tweet> timelineResult = new TimelineResult<Tweet>(new TimelineCursor(this.tweets), this.tweets);
        cb.success(timelineResult, null);
    }

    @Override
    public void previous(Long maxPosition, Callback<TimelineResult<Tweet>> cb) {
        List empty = Collections.emptyList();
        TimelineResult timelineResult = new TimelineResult(new TimelineCursor(empty), empty);
        cb.success(timelineResult, null);
    }

    @Override
    String getTimelineType() {
        return SCRIBE_SECTION;
    }

    public static class Builder {
        private final TweetUi tweetUi;
        private List<Tweet> tweets;

        public Builder() {
            this(TweetUi.getInstance());
        }

        public Builder(TweetUi tweetUi) {
            if (tweetUi == null) {
                throw new IllegalArgumentException("TweetUi instance must not be null");
            }
            this.tweetUi = tweetUi;
        }

        public Builder setTweets(List<Tweet> tweets) {
            this.tweets = tweets;
            return this;
        }

        public FixedTweetTimeline build() {
            return new FixedTweetTimeline(this.tweetUi, this.tweets);
        }
    }
}

