/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.media.MediaPlayer;
import android.net.Uri;
import android.view.View;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.tweetui.internal.TweetMediaUtils;
import com.twitter.sdk.android.tweetui.internal.VideoControlView;
import com.twitter.sdk.android.tweetui.internal.VideoView;
import io.fabric.sdk.android.Fabric;

class PlayerController {
    private static final String TAG = "PlayerController";
    final VideoView videoView;
    final VideoControlView videoControlView;

    PlayerController(VideoView videoView, VideoControlView videoControlView) {
        this.videoView = videoView;
        this.videoControlView = videoControlView;
    }

    void prepare(MediaEntity entity) {
        try {
            boolean looping = TweetMediaUtils.isLooping(entity);
            String url = TweetMediaUtils.getSupportedVariant((MediaEntity)entity).url;
            Uri uri = Uri.parse((String)url);
            this.setUpMediaControl(looping);
            this.videoView.setVideoURI(uri, looping);
            this.videoView.requestFocus();
            this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    PlayerController.this.videoView.start();
                }
            });
        }
        catch (Exception e) {
            Fabric.getLogger().e(TAG, "Error occurred during video playback", (Throwable)e);
        }
    }

    void setUpMediaControl(boolean looping) {
        if (looping) {
            this.setUpLoopControl();
        } else {
            this.setUpMediaControl();
        }
    }

    void setUpLoopControl() {
        this.videoControlView.setVisibility(4);
        this.videoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PlayerController.this.videoView.isPlaying()) {
                    PlayerController.this.videoView.pause();
                } else {
                    PlayerController.this.videoView.start();
                }
            }
        });
    }

    void setUpMediaControl() {
        this.videoView.setMediaController(this.videoControlView);
    }

    void cleanup() {
        this.videoView.stopPlayback();
    }
}

