/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.GuestCallback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Search;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.LoggingCallback;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineCursor;
import com.twitter.sdk.android.tweetui.TimelineResult;
import com.twitter.sdk.android.tweetui.TweetUi;
import io.fabric.sdk.android.Fabric;
import java.util.List;

public class SearchTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    static final String FILTER_RETWEETS = " -filter:retweets";
    static final String RESULT_TYPE = "filtered";
    private static final String SCRIBE_SECTION = "search";
    final String query;
    final String languageCode;
    final Integer maxItemsPerRequest;

    SearchTimeline(TweetUi tweetUi, String query, String languageCode, Integer maxItemsPerRequest) {
        super(tweetUi);
        this.languageCode = languageCode;
        this.maxItemsPerRequest = maxItemsPerRequest;
        this.query = query == null ? null : query + FILTER_RETWEETS;
    }

    @Override
    public void next(Long sinceId, Callback<TimelineResult<Tweet>> cb) {
        this.addRequest(this.createSearchRequest(sinceId, null, cb));
    }

    @Override
    public void previous(Long maxId, Callback<TimelineResult<Tweet>> cb) {
        this.addRequest(this.createSearchRequest(null, SearchTimeline.decrementMaxId(maxId), cb));
    }

    @Override
    String getTimelineType() {
        return SCRIBE_SECTION;
    }

    Callback<TwitterApiClient> createSearchRequest(final Long sinceId, final Long maxId, final Callback<TimelineResult<Tweet>> cb) {
        return new LoggingCallback<TwitterApiClient>(cb, Fabric.getLogger()){

            public void success(Result<TwitterApiClient> result) {
                ((TwitterApiClient)result.data).getSearchService().tweets(SearchTimeline.this.query, null, SearchTimeline.this.languageCode, null, SearchTimeline.RESULT_TYPE, SearchTimeline.this.maxItemsPerRequest, null, sinceId, maxId, Boolean.valueOf(true), (Callback)new GuestCallback((Callback)new SearchCallback((Callback<TimelineResult<Tweet>>)cb)));
            }
        };
    }

    public static class Builder {
        private TweetUi tweetUi;
        private String query;
        private String lang;
        private Integer maxItemsPerRequest = 30;

        public Builder() {
            this(TweetUi.getInstance());
        }

        public Builder(TweetUi tweetUi) {
            if (tweetUi == null) {
                throw new IllegalArgumentException("TweetUi instance must not be null");
            }
            this.tweetUi = tweetUi;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.lang = languageCode;
            return this;
        }

        public Builder maxItemsPerRequest(Integer maxItemsPerRequest) {
            this.maxItemsPerRequest = maxItemsPerRequest;
            return this;
        }

        public SearchTimeline build() {
            if (this.query == null) {
                throw new IllegalStateException("query must not be null");
            }
            return new SearchTimeline(this.tweetUi, this.query, this.lang, this.maxItemsPerRequest);
        }
    }

    class SearchCallback
    extends Callback<Search> {
        protected final Callback<TimelineResult<Tweet>> cb;

        SearchCallback(Callback<TimelineResult<Tweet>> cb) {
            this.cb = cb;
        }

        public void success(Result<Search> result) {
            List tweets = ((Search)result.data).tweets;
            TimelineResult timelineResult = new TimelineResult(new TimelineCursor(tweets), tweets);
            if (this.cb != null) {
                this.cb.success(timelineResult, result.response);
            }
        }

        public void failure(TwitterException exception) {
            if (this.cb != null) {
                this.cb.failure(exception);
            }
        }
    }
}

