/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.view.View;
import com.twitter.sdk.android.core.IntentUtils;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.R;
import com.twitter.sdk.android.tweetui.TweetScribeClient;
import com.twitter.sdk.android.tweetui.TweetScribeClientImpl;
import com.twitter.sdk.android.tweetui.TweetUi;
import io.fabric.sdk.android.Fabric;

class ShareTweetAction
implements View.OnClickListener {
    final Tweet tweet;
    final TweetUi tweetUi;
    final TweetScribeClient tweetScribeClient;

    ShareTweetAction(Tweet tweet, TweetUi tweetUi) {
        this(tweet, tweetUi, new TweetScribeClientImpl(tweetUi));
    }

    ShareTweetAction(Tweet tweet, TweetUi tweetUi, TweetScribeClient tweetScribeClient) {
        this.tweet = tweet;
        this.tweetUi = tweetUi;
        this.tweetScribeClient = tweetScribeClient;
    }

    public void onClick(View v) {
        this.onClick(v.getContext(), v.getResources());
    }

    void scribeShareAction() {
        this.tweetScribeClient.share(this.tweet);
    }

    void onClick(Context context, Resources resources) {
        if (this.tweet == null || this.tweet.user == null) {
            return;
        }
        this.scribeShareAction();
        String shareSubject = this.getShareSubject(resources);
        String shareContent = this.getShareContent(resources);
        Intent shareIntent = this.getShareIntent(shareSubject, shareContent);
        String shareText = resources.getString(R.string.tw__share_tweet);
        Intent chooser = Intent.createChooser((Intent)shareIntent, (CharSequence)shareText);
        this.launchShareIntent(chooser, context);
    }

    String getShareContent(Resources resources) {
        return resources.getString(R.string.tw__share_content_format, new Object[]{this.tweet.user.screenName, this.tweet.id});
    }

    String getShareSubject(Resources resources) {
        return resources.getString(R.string.tw__share_subject_format, new Object[]{this.tweet.user.name, this.tweet.user.screenName});
    }

    void launchShareIntent(Intent chooser, Context context) {
        if (!IntentUtils.safeStartActivity((Context)context, (Intent)chooser)) {
            Fabric.getLogger().e("TweetUi", "Activity cannot be found to handle share intent");
        }
    }

    Intent getShareIntent(String subject, String content) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.setType("text/plain");
        return intent;
    }
}

