/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.os.Handler;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.GuestCallback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.FormattedTweetText;
import com.twitter.sdk.android.tweetui.LoggingCallback;
import com.twitter.sdk.android.tweetui.TweetTextUtils;
import com.twitter.sdk.android.tweetui.TweetUiAuthRequestQueue;
import com.twitter.sdk.android.tweetui.Utils;
import io.fabric.sdk.android.Fabric;
import java.util.List;

class TweetRepository {
    private static final String TAG = "TweetUi";
    private static final String AUTH_ERROR = "Auth could not be obtained.";
    private static final int DEFAULT_CACHE_SIZE = 20;
    private final Handler mainHandler;
    private final TweetUiAuthRequestQueue guestAuthQueue;
    private final TweetUiAuthRequestQueue userAuthQueue;
    final LruCache<Long, Tweet> tweetCache;
    final LruCache<Long, FormattedTweetText> formatCache;

    TweetRepository(Handler mainHandler, TweetUiAuthRequestQueue userAuthQueue, TweetUiAuthRequestQueue guestAuthQueue) {
        this.mainHandler = mainHandler;
        this.userAuthQueue = userAuthQueue;
        this.guestAuthQueue = guestAuthQueue;
        this.tweetCache = new LruCache(20);
        this.formatCache = new LruCache(20);
    }

    FormattedTweetText formatTweetText(Tweet tweet) {
        if (tweet == null) {
            return null;
        }
        FormattedTweetText cached = (FormattedTweetText)this.formatCache.get((Object)tweet.id);
        if (cached != null) {
            return cached;
        }
        FormattedTweetText formattedTweetText = TweetTextUtils.formatTweetText(tweet);
        if (formattedTweetText != null && !TextUtils.isEmpty((CharSequence)formattedTweetText.text)) {
            this.formatCache.put((Object)tweet.id, (Object)formattedTweetText);
        }
        return formattedTweetText;
    }

    protected void updateCache(Tweet tweet) {
        this.tweetCache.put((Object)tweet.id, (Object)tweet);
    }

    private void deliverTweet(final Tweet tweet, final Callback<Tweet> cb) {
        if (cb == null) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                cb.success(new Result((Object)tweet, null));
            }
        });
    }

    void favorite(final long tweetId, final Callback<Tweet> cb) {
        this.userAuthQueue.addClientRequest((Callback<TwitterApiClient>)new LoggingCallback<TwitterApiClient>(cb, Fabric.getLogger()){

            public void success(Result<TwitterApiClient> result) {
                ((TwitterApiClient)result.data).getFavoriteService().create(Long.valueOf(tweetId), Boolean.valueOf(true), cb);
            }
        });
    }

    void unfavorite(final long tweetId, final Callback<Tweet> cb) {
        this.userAuthQueue.addClientRequest((Callback<TwitterApiClient>)new LoggingCallback<TwitterApiClient>(cb, Fabric.getLogger()){

            public void success(Result<TwitterApiClient> result) {
                ((TwitterApiClient)result.data).getFavoriteService().destroy(Long.valueOf(tweetId), Boolean.valueOf(true), cb);
            }
        });
    }

    void retweet(final long tweetId, final Callback<Tweet> cb) {
        this.userAuthQueue.addClientRequest((Callback<TwitterApiClient>)new LoggingCallback<TwitterApiClient>(cb, Fabric.getLogger()){

            public void success(Result<TwitterApiClient> result) {
                ((TwitterApiClient)result.data).getStatusesService().retweet(Long.valueOf(tweetId), Boolean.valueOf(false), cb);
            }
        });
    }

    void unretweet(final long tweetId, final Callback<Tweet> cb) {
        this.userAuthQueue.addClientRequest((Callback<TwitterApiClient>)new LoggingCallback<TwitterApiClient>(cb, Fabric.getLogger()){

            public void success(Result<TwitterApiClient> result) {
                ((TwitterApiClient)result.data).getStatusesService().unretweet(Long.valueOf(tweetId), Boolean.valueOf(false), cb);
            }
        });
    }

    void loadTweet(final long tweetId, final Callback<Tweet> cb) {
        Tweet cachedTweet = (Tweet)this.tweetCache.get((Object)tweetId);
        if (cachedTweet != null) {
            this.deliverTweet(cachedTweet, cb);
            return;
        }
        this.guestAuthQueue.addClientRequest(new Callback<TwitterApiClient>(){

            public void success(Result<TwitterApiClient> result) {
                ((TwitterApiClient)result.data).getStatusesService().show(Long.valueOf(tweetId), null, null, null, (Callback)new SingleTweetCallback((Callback<Tweet>)cb));
            }

            public void failure(TwitterException exception) {
                Fabric.getLogger().e(TweetRepository.TAG, TweetRepository.AUTH_ERROR, (Throwable)exception);
                if (cb != null) {
                    cb.failure(exception);
                }
            }
        });
    }

    void loadTweets(final List<Long> tweetIds, final Callback<List<Tweet>> cb) {
        this.guestAuthQueue.addClientRequest(new Callback<TwitterApiClient>(){

            public void success(Result<TwitterApiClient> result) {
                String commaSepIds = TextUtils.join((CharSequence)",", (Iterable)tweetIds);
                ((TwitterApiClient)result.data).getStatusesService().lookup(commaSepIds, null, null, null, (Callback)new MultiTweetsCallback(tweetIds, (Callback<List<Tweet>>)cb));
            }

            public void failure(TwitterException exception) {
                Fabric.getLogger().e(TweetRepository.TAG, TweetRepository.AUTH_ERROR, (Throwable)exception);
                if (cb != null) {
                    cb.failure(exception);
                }
            }
        });
    }

    class MultiTweetsCallback
    extends GuestCallback<List<Tweet>> {
        final List<Long> tweetIds;

        MultiTweetsCallback(List<Long> tweetIds, Callback<List<Tweet>> cb) {
            super(cb);
            this.tweetIds = tweetIds;
        }

        public void success(Result<List<Tweet>> result) {
            if (this.cb != null) {
                List<Tweet> sorted = Utils.orderTweets(this.tweetIds, (List)result.data);
                this.cb.success(new Result(sorted, result.response));
            }
        }
    }

    class SingleTweetCallback
    extends GuestCallback<Tweet> {
        SingleTweetCallback(Callback<Tweet> cb) {
            super(cb);
        }

        public void success(Result<Tweet> result) {
            Tweet tweet = (Tweet)result.data;
            TweetRepository.this.updateCache(tweet);
            if (this.cb != null) {
                this.cb.success(new Result((Object)tweet, result.response));
            }
        }
    }
}

