/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import com.twitter.sdk.android.tweetui.FormattedMediaEntity;
import com.twitter.sdk.android.tweetui.FormattedTweetText;
import com.twitter.sdk.android.tweetui.FormattedUrlEntity;
import com.twitter.sdk.android.tweetui.LinkClickListener;
import com.twitter.sdk.android.tweetui.internal.ClickableLinkSpan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class TweetTextLinkifier {
    private static final String PHOTO_TYPE = "photo";

    private TweetTextLinkifier() {
    }

    static CharSequence linkifyUrls(FormattedTweetText tweetText, LinkClickListener listener, boolean stripLastPhotoEntity, int linkColor, int linkHighlightColor) {
        if (tweetText == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)tweetText.text)) {
            return tweetText.text;
        }
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)tweetText.text);
        List<FormattedUrlEntity> urls = tweetText.urlEntities;
        List<FormattedMediaEntity> media = tweetText.mediaEntities;
        FormattedMediaEntity lastPhoto = stripLastPhotoEntity ? TweetTextLinkifier.getLastPhotoEntity(tweetText) : null;
        List<FormattedUrlEntity> combined = TweetTextLinkifier.mergeAndSortEntities(urls, media);
        TweetTextLinkifier.addUrlEntities(spannable, combined, lastPhoto, listener, linkColor, linkHighlightColor);
        return spannable;
    }

    static List<FormattedUrlEntity> mergeAndSortEntities(List<FormattedUrlEntity> urls, List<FormattedMediaEntity> media) {
        if (media == null) {
            return urls;
        }
        ArrayList<FormattedUrlEntity> combined = new ArrayList<FormattedUrlEntity>(urls);
        combined.addAll(media);
        Collections.sort(combined, new Comparator<FormattedUrlEntity>(){

            @Override
            public int compare(FormattedUrlEntity lhs, FormattedUrlEntity rhs) {
                if (lhs == null && rhs != null) {
                    return -1;
                }
                if (lhs != null && rhs == null) {
                    return 1;
                }
                if (lhs == null && rhs == null) {
                    return 0;
                }
                if (lhs.start < rhs.start) {
                    return -1;
                }
                if (lhs.start > rhs.start) {
                    return 1;
                }
                return 0;
            }
        });
        return combined;
    }

    private static void addUrlEntities(SpannableStringBuilder spannable, List<FormattedUrlEntity> entities, FormattedMediaEntity lastPhoto, final LinkClickListener listener, int linkColor, int linkHighlightColor) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        int offset = 0;
        for (final FormattedUrlEntity url : entities) {
            int len;
            int start = url.start - offset;
            int end = url.end - offset;
            if (start < 0 || end > spannable.length()) continue;
            if (lastPhoto != null && lastPhoto.start == url.start) {
                spannable.replace(start, end, (CharSequence)"");
                len = end - start;
                end -= len;
                offset += len;
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)url.displayUrl)) continue;
            spannable.replace(start, end, (CharSequence)url.displayUrl);
            len = end - (start + url.displayUrl.length());
            offset += len;
            ClickableLinkSpan span = new ClickableLinkSpan(linkHighlightColor, linkColor, false){

                @Override
                public void onClick(View widget) {
                    if (listener == null) {
                        return;
                    }
                    listener.onUrlClicked(url.url);
                }
            };
            spannable.setSpan((Object)span, start, end -= len, 33);
        }
    }

    private static FormattedMediaEntity getLastPhotoEntity(FormattedTweetText formattedTweetText) {
        if (formattedTweetText == null) {
            return null;
        }
        List<FormattedMediaEntity> mediaEntityList = formattedTweetText.mediaEntities;
        if (mediaEntityList.isEmpty()) {
            return null;
        }
        for (int i = mediaEntityList.size() - 1; i >= 0; --i) {
            FormattedMediaEntity entity = mediaEntityList.get(i);
            if (!PHOTO_TYPE.equals(entity.type)) continue;
            return entity;
        }
        return null;
    }
}

