/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.content.Context;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.squareup.picasso.Picasso;
import com.twitter.sdk.android.core.Session;
import com.twitter.sdk.android.core.SessionManager;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.internal.scribe.DefaultScribeClient;
import com.twitter.sdk.android.core.internal.scribe.EventNamespace;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.tweetui.TweetRepository;
import com.twitter.sdk.android.tweetui.TweetUiAuthRequestQueue;
import com.twitter.sdk.android.tweetui.internal.GuestSessionProvider;
import com.twitter.sdk.android.tweetui.internal.UserSessionProvider;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.concurrency.DependsOn;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@DependsOn(value={TwitterCore.class})
public class TweetUi
extends Kit<Boolean> {
    static final String LOGTAG = "TweetUi";
    static final String NOT_STARTED_ERROR = "Must start TweetUi Kit in Fabric.with().";
    private static final String KIT_SCRIBE_NAME = "TweetUi";
    List<SessionManager<? extends Session>> userSessionManagers;
    List<SessionManager<? extends Session>> guestSessionManagers;
    UserSessionProvider userSessionProvider;
    GuestSessionProvider guestSessionProvider;
    String advertisingId;
    DefaultScribeClient scribeClient;
    private final AtomicReference<Gson> gsonRef = new AtomicReference();
    private TweetRepository tweetRepository;
    private TweetUiAuthRequestQueue userAuthQueue;
    private TweetUiAuthRequestQueue guestAuthQueue;
    private Picasso imageLoader;

    public static TweetUi getInstance() {
        TweetUi.checkInitialized();
        return (TweetUi)Fabric.getKit(TweetUi.class);
    }

    public String getIdentifier() {
        return "com.twitter.sdk.android:tweet-ui";
    }

    public String getVersion() {
        return "1.10.0.101";
    }

    protected boolean onPreExecute() {
        super.onPreExecute();
        TwitterCore twitterCore = TwitterCore.getInstance();
        this.userSessionManagers = new ArrayList<SessionManager<? extends Session>>(1);
        this.userSessionManagers.add((SessionManager<? extends Session>)twitterCore.getSessionManager());
        this.userSessionProvider = new UserSessionProvider(this.userSessionManagers);
        this.userAuthQueue = new TweetUiAuthRequestQueue(twitterCore, this.userSessionProvider);
        this.guestSessionManagers = new ArrayList<SessionManager<? extends Session>>(2);
        this.guestSessionManagers.add((SessionManager<? extends Session>)twitterCore.getSessionManager());
        this.guestSessionManagers.add((SessionManager<? extends Session>)twitterCore.getAppSessionManager());
        this.guestSessionProvider = new GuestSessionProvider(twitterCore, this.guestSessionManagers);
        this.guestAuthQueue = new TweetUiAuthRequestQueue(twitterCore, this.guestSessionProvider);
        this.tweetRepository = new TweetRepository(this.getFabric().getMainHandler(), this.userAuthQueue, this.guestAuthQueue);
        return true;
    }

    protected Boolean doInBackground() {
        this.imageLoader = Picasso.with((Context)this.getContext());
        this.userAuthQueue.sessionRestored(this.userSessionProvider.getActiveSession());
        this.guestAuthQueue.sessionRestored(this.guestSessionProvider.getActiveSession());
        this.initGson();
        this.setUpScribeClient();
        this.advertisingId = this.getIdManager().getAdvertisingId();
        return true;
    }

    private static void checkInitialized() {
        if (Fabric.getKit(TweetUi.class) == null) {
            throw new IllegalStateException(NOT_STARTED_ERROR);
        }
    }

    private void setUpScribeClient() {
        this.scribeClient = new DefaultScribeClient((Kit)this, "TweetUi", this.gsonRef.get(), this.guestSessionManagers, this.getIdManager());
    }

    void scribe(EventNamespace ... namespaces) {
        if (this.scribeClient == null) {
            return;
        }
        for (EventNamespace ns : namespaces) {
            this.scribeClient.scribe(new EventNamespace[]{ns});
        }
    }

    void scribe(EventNamespace ns, List<ScribeItem> items) {
        if (this.scribeClient == null) {
            return;
        }
        this.scribeClient.scribe(ns, items);
    }

    void initGson() {
        if (this.gsonRef.get() == null) {
            Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
            this.gsonRef.compareAndSet(null, gson);
        }
    }

    TweetRepository getTweetRepository() {
        return this.tweetRepository;
    }

    TweetUiAuthRequestQueue getGuestAuthQueue() {
        return this.guestAuthQueue;
    }

    void setTweetRepository(TweetRepository tweetRepository) {
        this.tweetRepository = tweetRepository;
    }

    Picasso getImageLoader() {
        return this.imageLoader;
    }

    void setImageLoader(Picasso imageLoader) {
        this.imageLoader = imageLoader;
    }

    void clearAppSession(long sessionId) {
        TwitterCore.getInstance().getAppSessionManager().clearSession(sessionId);
    }
}

