/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import android.net.Uri;
import android.text.TextUtils;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.LoadCallback;
import com.twitter.sdk.android.tweetui.LoggingCallback;
import com.twitter.sdk.android.tweetui.TweetUi;
import io.fabric.sdk.android.Fabric;
import java.util.List;
import java.util.Locale;

public final class TweetUtils {
    private static final String TAG = "TweetUi";
    private static final String PERMALINK_FORMAT = "https://twitter.com/%s/status/%d";
    private static final String UNKNOWN_SCREEN_NAME = "twitter_unknown";
    static final String LOAD_TWEET_DEBUG = "loadTweet failure for Tweet Id %d.";

    private TweetUtils() {
    }

    public static void loadTweet(long tweetId, final Callback<Tweet> cb) {
        TweetUi.getInstance().getTweetRepository().loadTweet(tweetId, (Callback<Tweet>)new LoggingCallback<Tweet>(cb, Fabric.getLogger()){

            public void success(Result<Tweet> result) {
                if (cb != null) {
                    cb.success(result);
                }
            }
        });
    }

    public static void loadTweets(List<Long> tweetIds, final Callback<List<Tweet>> cb) {
        TweetUi.getInstance().getTweetRepository().loadTweets(tweetIds, (Callback<List<Tweet>>)new LoggingCallback<List<Tweet>>(cb, Fabric.getLogger()){

            public void success(Result<List<Tweet>> result) {
                if (cb != null) {
                    cb.success(result);
                }
            }
        });
    }

    @Deprecated
    public static void loadTweet(long tweetId, LoadCallback<Tweet> loadCallback) {
        final CallbackAdapter<Tweet> cb = new CallbackAdapter<Tweet>(loadCallback);
        TweetUtils.loadTweet(tweetId, (Callback<Tweet>)new LoggingCallback<Tweet>(cb, Fabric.getLogger()){

            public void success(Result<Tweet> result) {
                if (cb != null) {
                    cb.success(result);
                }
            }
        });
    }

    @Deprecated
    public static void loadTweets(List<Long> tweetIds, LoadCallback<List<Tweet>> loadCallback) {
        final CallbackAdapter<List<Tweet>> cb = new CallbackAdapter<List<Tweet>>(loadCallback);
        TweetUtils.loadTweets(tweetIds, (Callback<List<Tweet>>)new LoggingCallback<List<Tweet>>(cb, Fabric.getLogger()){

            public void success(Result<List<Tweet>> result) {
                if (cb != null) {
                    cb.success(result);
                }
            }
        });
    }

    static boolean isTweetResolvable(Tweet tweet) {
        return tweet != null && tweet.id > 0L && tweet.user != null && !TextUtils.isEmpty((CharSequence)tweet.user.screenName);
    }

    static Tweet getDisplayTweet(Tweet tweet) {
        if (tweet == null || tweet.retweetedStatus == null) {
            return tweet;
        }
        return tweet.retweetedStatus;
    }

    static Uri getPermalink(String screenName, long tweetId) {
        if (tweetId <= 0L) {
            return null;
        }
        String permalink = TextUtils.isEmpty((CharSequence)screenName) ? String.format(Locale.US, PERMALINK_FORMAT, UNKNOWN_SCREEN_NAME, tweetId) : String.format(Locale.US, PERMALINK_FORMAT, screenName, tweetId);
        return Uri.parse((String)permalink);
    }

    public static class CallbackAdapter<T>
    extends Callback<T> {
        private LoadCallback<T> cb;

        CallbackAdapter(LoadCallback<T> cb) {
            this.cb = cb;
        }

        public void success(Result<T> result) {
            if (this.cb != null) {
                this.cb.success(result.data);
            }
        }

        public void failure(TwitterException exception) {
            if (this.cb != null) {
                this.cb.failure(exception);
            }
        }
    }
}

