/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.GuestCallback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.LoggingCallback;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineResult;
import com.twitter.sdk.android.tweetui.TweetUi;
import io.fabric.sdk.android.Fabric;

public class TwitterListTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    private static final String SCRIBE_SECTION = "list";
    final Long listId;
    final String slug;
    final String ownerScreenName;
    final Long ownerId;
    final Integer maxItemsPerRequest;
    final Boolean includeRetweets;

    TwitterListTimeline(TweetUi tweetUi, Long listId, String slug, Long ownerId, String ownerScreenName, Integer maxItemsPerRequest, Boolean includeRetweets) {
        super(tweetUi);
        this.listId = listId;
        this.slug = slug;
        this.ownerId = ownerId;
        this.ownerScreenName = ownerScreenName;
        this.maxItemsPerRequest = maxItemsPerRequest;
        this.includeRetweets = includeRetweets;
    }

    @Override
    public void next(Long sinceId, Callback<TimelineResult<Tweet>> cb) {
        this.addRequest(this.createListTimelineRequest(sinceId, null, cb));
    }

    @Override
    public void previous(Long maxId, Callback<TimelineResult<Tweet>> cb) {
        this.addRequest(this.createListTimelineRequest(null, TwitterListTimeline.decrementMaxId(maxId), cb));
    }

    Callback<TwitterApiClient> createListTimelineRequest(final Long sinceId, final Long maxId, final Callback<TimelineResult<Tweet>> cb) {
        return new LoggingCallback<TwitterApiClient>(cb, Fabric.getLogger()){

            public void success(Result<TwitterApiClient> result) {
                ((TwitterApiClient)result.data).getListService().statuses(TwitterListTimeline.this.listId, TwitterListTimeline.this.slug, TwitterListTimeline.this.ownerScreenName, TwitterListTimeline.this.ownerId, sinceId, maxId, TwitterListTimeline.this.maxItemsPerRequest, Boolean.valueOf(true), TwitterListTimeline.this.includeRetweets, (Callback)new GuestCallback((Callback)new BaseTimeline.TweetsCallback((Callback<TimelineResult<Tweet>>)cb)));
            }
        };
    }

    @Override
    String getTimelineType() {
        return SCRIBE_SECTION;
    }

    public static class Builder {
        private final TweetUi tweetUi;
        private Long listId;
        private String slug;
        private Long ownerId;
        private String ownerScreenName;
        private Integer maxItemsPerRequest = 30;
        private Boolean includeRetweets;

        public Builder() {
            this(TweetUi.getInstance());
        }

        public Builder(TweetUi tweetUi) {
            if (tweetUi == null) {
                throw new IllegalArgumentException("TweetUi instance must not be null");
            }
            this.tweetUi = tweetUi;
        }

        public Builder id(Long id2) {
            this.listId = id2;
            return this;
        }

        public Builder slugWithOwnerId(String slug, Long ownerId) {
            this.slug = slug;
            this.ownerId = ownerId;
            return this;
        }

        public Builder slugWithOwnerScreenName(String slug, String ownerScreenName) {
            this.slug = slug;
            this.ownerScreenName = ownerScreenName;
            return this;
        }

        public Builder maxItemsPerRequest(Integer maxItemsPerRequest) {
            this.maxItemsPerRequest = maxItemsPerRequest;
            return this;
        }

        public Builder includeRetweets(Boolean includeRetweets) {
            this.includeRetweets = includeRetweets;
            return this;
        }

        public TwitterListTimeline build() {
            if (!(this.listId == null ^ this.slug == null)) {
                throw new IllegalStateException("must specify either a list id or slug/owner pair");
            }
            if (this.slug != null && this.ownerId == null && this.ownerScreenName == null) {
                throw new IllegalStateException("slug/owner pair must set owner via ownerId or ownerScreenName");
            }
            return new TwitterListTimeline(this.tweetUi, this.listId, this.slug, this.ownerId, this.ownerScreenName, this.maxItemsPerRequest, this.includeRetweets);
        }
    }
}

