/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.GuestCallback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetui.BaseTimeline;
import com.twitter.sdk.android.tweetui.LoggingCallback;
import com.twitter.sdk.android.tweetui.Timeline;
import com.twitter.sdk.android.tweetui.TimelineResult;
import com.twitter.sdk.android.tweetui.TweetUi;
import io.fabric.sdk.android.Fabric;

public class UserTimeline
extends BaseTimeline
implements Timeline<Tweet> {
    private static final String SCRIBE_SECTION = "user";
    final Long userId;
    final String screenName;
    final Integer maxItemsPerRequest;
    final Boolean includeReplies;
    final Boolean includeRetweets;

    UserTimeline(TweetUi tweetUi, Long userId, String screenName, Integer maxItemsPerRequest, Boolean includeReplies, Boolean includeRetweets) {
        super(tweetUi);
        this.userId = userId;
        this.screenName = screenName;
        this.maxItemsPerRequest = maxItemsPerRequest;
        this.includeReplies = includeReplies == null ? false : includeReplies;
        this.includeRetweets = includeRetweets;
    }

    @Override
    public void next(Long sinceId, Callback<TimelineResult<Tweet>> cb) {
        this.addRequest(this.createUserTimelineRequest(sinceId, null, cb));
    }

    @Override
    public void previous(Long maxId, Callback<TimelineResult<Tweet>> cb) {
        this.addRequest(this.createUserTimelineRequest(null, UserTimeline.decrementMaxId(maxId), cb));
    }

    @Override
    String getTimelineType() {
        return SCRIBE_SECTION;
    }

    Callback<TwitterApiClient> createUserTimelineRequest(final Long sinceId, final Long maxId, final Callback<TimelineResult<Tweet>> cb) {
        return new LoggingCallback<TwitterApiClient>(cb, Fabric.getLogger()){

            public void success(Result<TwitterApiClient> result) {
                ((TwitterApiClient)result.data).getStatusesService().userTimeline(UserTimeline.this.userId, UserTimeline.this.screenName, UserTimeline.this.maxItemsPerRequest, sinceId, maxId, Boolean.valueOf(false), Boolean.valueOf(UserTimeline.this.includeReplies == false), null, UserTimeline.this.includeRetweets, (Callback)new GuestCallback((Callback)new BaseTimeline.TweetsCallback((Callback<TimelineResult<Tweet>>)cb)));
            }
        };
    }

    public static class Builder {
        private final TweetUi tweetUi;
        private Long userId;
        private String screenName;
        private Integer maxItemsPerRequest = 30;
        private Boolean includeReplies;
        private Boolean includeRetweets;

        public Builder() {
            this(TweetUi.getInstance());
        }

        public Builder(TweetUi tweetUi) {
            if (tweetUi == null) {
                throw new IllegalArgumentException("TweetUi instance must not be null");
            }
            this.tweetUi = tweetUi;
        }

        public Builder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public Builder screenName(String screenName) {
            this.screenName = screenName;
            return this;
        }

        public Builder maxItemsPerRequest(Integer maxItemsPerRequest) {
            this.maxItemsPerRequest = maxItemsPerRequest;
            return this;
        }

        public Builder includeReplies(Boolean includeReplies) {
            this.includeReplies = includeReplies;
            return this;
        }

        public Builder includeRetweets(Boolean includeRetweets) {
            this.includeRetweets = includeRetweets;
            return this;
        }

        public UserTimeline build() {
            return new UserTimeline(this.tweetUi, this.userId, this.screenName, this.maxItemsPerRequest, this.includeReplies, this.includeRetweets);
        }
    }
}

