/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui;

import com.twitter.sdk.android.core.internal.scribe.EventNamespace;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.core.models.MediaEntity;
import com.twitter.sdk.android.tweetui.TweetUi;
import com.twitter.sdk.android.tweetui.VideoScribeClient;
import java.util.ArrayList;

class VideoScribeClientImpl
implements VideoScribeClient {
    static final String TFW_CLIENT_EVENT_PAGE = "android";
    static final String TFW_CLIENT_EVENT_SECTION = "video";
    static final String SCRIBE_IMPRESSION_ACTION = "impression";
    static final String SCRIBE_PLAY_ACTION = "play";
    final TweetUi tweetUi;

    VideoScribeClientImpl(TweetUi tweetUi) {
        this.tweetUi = tweetUi;
    }

    @Override
    public void impression(long tweetId, MediaEntity mediaEntity) {
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(VideoScribeClientImpl.createScribeItem(tweetId, mediaEntity));
        this.tweetUi.scribe(VideoScribeClientImpl.getTfwImpressionNamespace(), items);
    }

    @Override
    public void play(long tweetId, MediaEntity mediaEntity) {
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(VideoScribeClientImpl.createScribeItem(tweetId, mediaEntity));
        this.tweetUi.scribe(VideoScribeClientImpl.getTfwPlayNamespace(), items);
    }

    static ScribeItem createScribeItem(long tweetId, MediaEntity mediaEntity) {
        return new ScribeItem.Builder().setItemType(0).setId(tweetId).setMediaDetails(VideoScribeClientImpl.createMediaDetails(tweetId, mediaEntity)).build();
    }

    static ScribeItem.MediaDetails createMediaDetails(long tweetId, MediaEntity mediaEntity) {
        return new ScribeItem.MediaDetails(tweetId, VideoScribeClientImpl.getMediaType(mediaEntity), mediaEntity.id);
    }

    static int getMediaType(MediaEntity mediaEntity) {
        if ("animated_gif".equals(mediaEntity.type)) {
            return 3;
        }
        return 1;
    }

    static EventNamespace getTfwImpressionNamespace() {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection(TFW_CLIENT_EVENT_SECTION).setAction(SCRIBE_IMPRESSION_ACTION).builder();
    }

    static EventNamespace getTfwPlayNamespace() {
        return new EventNamespace.Builder().setClient("tfw").setPage(TFW_CLIENT_EVENT_PAGE).setSection(TFW_CLIENT_EVENT_SECTION).setAction(SCRIBE_PLAY_ACTION).builder();
    }
}

