/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import android.text.TextPaint;
import android.text.style.ClickableSpan;
import com.twitter.sdk.android.tweetui.internal.HighlightedClickableSpan;

public abstract class ClickableLinkSpan
extends ClickableSpan
implements HighlightedClickableSpan {
    public final int linkColor;
    private final int selectedColor;
    private final boolean colored;
    private final boolean underlined;
    private boolean selected;

    public ClickableLinkSpan(int selectedColor) {
        this(selectedColor, 0, false, false);
    }

    public ClickableLinkSpan(int selectedColor, int linkColor, boolean underlined) {
        this(selectedColor, linkColor, true, underlined);
    }

    ClickableLinkSpan(int selectedColor, int linkColor, boolean colored, boolean underlined) {
        this.selectedColor = selectedColor;
        this.linkColor = linkColor;
        this.colored = colored;
        this.underlined = underlined;
    }

    public void updateDrawState(TextPaint ds) {
        if (this.colored) {
            ds.setColor(this.linkColor);
        } else {
            ds.setColor(ds.linkColor);
        }
        ds.bgColor = this.selected ? this.selectedColor : 0;
        if (this.underlined) {
            ds.setUnderlineText(true);
        }
    }

    @Override
    public void select(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }
}

