/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetui.internal;

import com.twitter.sdk.android.core.AppSession;
import com.twitter.sdk.android.core.AuthToken;
import com.twitter.sdk.android.core.Callback;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.Session;
import com.twitter.sdk.android.core.SessionManager;
import com.twitter.sdk.android.core.TwitterAuthToken;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.internal.SessionProvider;
import com.twitter.sdk.android.core.internal.oauth.GuestAuthToken;
import java.util.List;

public class GuestSessionProvider
extends SessionProvider {
    private final TwitterCore twitterCore;

    public GuestSessionProvider(TwitterCore twitterCore, List<SessionManager<? extends Session>> sessionManagers) {
        super(sessionManagers);
        this.twitterCore = twitterCore;
    }

    public Session getActiveSession() {
        Session session = super.getActiveSession();
        if (session == null) {
            return null;
        }
        AuthToken token = session.getAuthToken();
        if (token instanceof TwitterAuthToken || token instanceof GuestAuthToken) {
            return session;
        }
        return null;
    }

    public void requestAuth(Callback<Session> cb) {
        this.twitterCore.logInGuest((Callback)new AppSessionCallback(cb));
    }

    class AppSessionCallback
    extends Callback<AppSession> {
        private final Callback<Session> cb;

        AppSessionCallback(Callback<Session> cb) {
            this.cb = cb;
        }

        public void success(Result<AppSession> result) {
            this.cb.success(new Result(result.data, result.response));
        }

        public void failure(TwitterException exception) {
            this.cb.failure(exception);
        }
    }
}

